/**************************** CPPHeaderFile ***************************

* FileName [GlobalCEDag.h]

* PackageName [main]

* Synopsis [Header file for GlobalCEDag class.]

* Description [This class encapsulates the global counter example
* DAG.]

* SeeAlso [GlobalCEDag.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __GLOBALCEDAG_H__
#define __GLOBALCEDAG_H__

namespace magic {

//other classes needed
class BigInt;
typedef pair< set<BigInt>,set<BigInt> > ExclInfo;

class GlobalCEDag
{
 private:
  //the labeling of nodes with states
  static vector<BigInt> stateLabel;

  //the labeling of nodes with actions
  static vector<Action> actLabel;

  //the transition relation
  static vector< set<int> > trans;

  //state labels all root nodes
  static set<BigInt> allRoot;

  //choices made by state labels of the tree
  static map< BigInt,set< pair<Action,ExclInfo> > > allTrans;

  //the maximum number of strategies found so far
  static int strategyMax;

  //the number of strategies found so far
  static int strategyNum;  

  //top-level routines
  static bool ComputeFsp();
  static bool ComputeLtl();
  static bool ComputeDeadlock();
  static bool ComputeSeaw();

  static inline void MacroOne(const BigInt &elemId,const int &newNode,bool &newFlag,set<int> &stack,const int loop);
  static inline void MacroTwo(const int &node,bool &newFlag,set<int> &stack,const int loop,const ExclInfo &exclInfo,const Action &act);
  static inline bool MacroThree(const int &node,bool &newFlag,set<int> &stack,const int loop,const set<BigInt> &clause,const set<BigInt> &before,const Action &act);
  static void ComputeWithRoot(const int &node,bool &newFlag,set<int> &stack,const int loop);
  static vector<Action> RandomizeActSet(const set<Action> &arg);
  static vector<BigInt> RandomizeIntSet(const set<BigInt> &arg);
  static vector< pair<Action,ExclInfo> > RandomizeChoices(const set< pair<Action,ExclInfo> > &arg);
  static pair<bool,bool> ExcludedBefore(const BigInt &succ,const BigInt &pred);
  static bool IsValidSucc(const int &node,const Action &act,const set<BigInt> &succs);
  static void TopologicalSort();

 public:
  static void Initialize();
  static bool Compute();
  static bool NoLoop() { return trans.back().empty(); }

  friend class ConcCEDag;
  friend class CEDagVerifier;
};

} //namespace magic

#endif //__GLOBALCEDAG_H__

/*********************************************************************/
//end of GlobalCEDag.h
/*********************************************************************/
