/**************************** CPPHeaderFile ***************************

* FileName [GlobalAbsLts.h]

* PackageName [main]

* Synopsis [Header file for GlobalAbsLts class.]

* Description [This class encapsulates the global abstract LTS
* i.e. the parallel composition of all the local abstract LTSs.]

* SeeAlso [GlobalAbsLts.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __GLOBALABSLTS_H__
#define __GLOBALABSLTS_H__

namespace magic {

//other classes needed
typedef int L2AbsState;
class BigInt;

/*********************************************************************/
//this class encapsulates the global abstract LTS: the final model
/*********************************************************************/
class GlobalAbsLts
{
 private:
  //map from actions to the indices of components that can participate
  //in them
  static map< Action,set<size_t> > actToComp;

  //set of singleton actions
  static set<Action> singActs;

  static void CartesianProduct(const vector< set<L2AbsState> > &arg,size_t index,const BigInt &factor,const BigInt &curr,set<BigInt> &res);
  static void ComputeSuccsOrPreds(const size_t index,const L2AbsState &state,const Action &act,const bool succFlag,const bool prevFlag,set<L2AbsState> &res);
  static void Interleave(const BigInt &comp,const Action &act,bool succFlag,bool prevFlag,set<BigInt> &res);
  static void Synchronize(const BigInt &comp,const Action &act,bool succFlag,bool prevFlag,set<BigInt> &res);
  static void Handshake(const BigInt &comp,const Action &act,bool succFlag,bool prevFlag,set<BigInt> &res);
  static void GetPredsOnAction(const BigInt &comp,const Action &act,set<BigInt> &res);
  static bool SingletonAction(const BigInt &comp,const Action &act,bool succFlag,bool prevFlag,set<BigInt> &res);

 public:
  //the set of reachable states
  static set<BigInt> reach;

  GlobalAbsLts() { assert(false); }
  ~GlobalAbsLts() {}

  static void ComputeActInfo();
  static void GetInitStates(set<BigInt> &res);
  static void GetPrevInitStates(set<BigInt> &res);
  static void GetSuccsAndActions(const BigInt &comp,map< Action,set<BigInt> > &res);
  static void GetSuccsOnAction(const BigInt &comp,const Action &act,set<BigInt> &res);
  static void GetPredsAndActions(const BigInt &comp,map< Action,set<BigInt> > &res);
  static void GetActions(set<Action> &res);
  static BigInt GetStateNum();
  static int GetPrevStateNum();
  static void GetSuccsChanged(set<BigInt> &res);
  static void GetPrevSuccsOnAction(const BigInt &comp,const Action &act,set<BigInt> &res);
  static void GetPropositions(const BigInt &comp,set<Expr> &res);
  static Action GetCompAct(const Action &act,const BigInt &source,const BigInt &sink,int index);
  static bool IsDeadlocked(const BigInt &comp);

  //split a composite global state into states for individual
  //components of the program
  static vector<L2AbsState> CompToAbsStates(const BigInt &comp);
  
  static string CompToString(const BigInt &comp);
};

} //namespace magic

#endif //__GLOBALABSLTS_H__

/*********************************************************************/
//end of GlobalAbsLts.h
/*********************************************************************/
