/**************************** CPPHeaderFile ***************************

* FileName [GenericTP.h]

* PackageName [main]

* Synopsis [Header file for GenericTP class.]

* Description [This class is an abstract class that defines the
* interface between the tool and a theorem prover.]

* SeeAlso [TheoremProver.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __GENERICTP_H__
#define __GENERICTP_H__

namespace magic {

//other classes needed
class BasicExpr;

class GenericTP
{
 public:
  //initialise the theorem prover
  virtual void Initialise() = 0;
  
  //shutdown the theorem prover
  virtual void Shutdown() = 0;
  
  //prove that an antecedent implies a consequent. both the
  //antecedent and the consequent are provided as a list of
  //formulas. the result is true if the cojunction of all of the
  //antecedents implies the disjunction of all of the
  //consequents. return true if it can be proved and false
  //otherwise.
  virtual bool ProveImplies(const list<const BasicExpr*> &ante,const list<const BasicExpr*> &cons) = 0;
  
  //add a constraint to the theorem prover environment. this
  //constraint is provided as a C expression.
  virtual void AddConstraint(const BasicExpr *expr) = 0;
};

} //namespace magic

#endif //__GENERICTP_H__

/*********************************************************************/
//end of GenericTP.h
/*********************************************************************/
