/**************************** CPPHeaderFile ***************************

* FileName [Explain.h]

* PackageName [main]

* Synopsis [Header file for Explain class.]

* Description [This is the explain stuff.]

* SeeAlso [Explain.cpp]

* Author [Alex Groce]

* Copyright [ Copyright (c) 2004 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __EXPLAIN_H__
#define __EXPLAIN_H__

#include "ConcCEDag.h"
namespace magic {

class Explain
{
 private:
 
  ConcCEDag &CE;

  Component &component;

  size_t SATVars;

  bool LTL;

  FILE *clauseFile;
  size_t clauseNum;

  vector<pair<int,int> > deltas;

  map<size_t,pair<size_t,size_t> > PredValDeltas;
  map<size_t,size_t> ActionDeltas;
  map<size_t,size_t> ContLocDeletions;
  map<size_t,size_t> ContLocInsertions;
  
  size_t maxPValDelta;
  int maxDelta;
  int ActDeltaWeight;
  int PredDeltaWeight;

  set<size_t> assigned;

  size_t CESize;
  size_t unwind;
  size_t stop_unwind;
  
  vector<ContLoc*> CEContLocs;
  vector<PVal> CEPVals;
  vector<Action> CEActions;

  size_t SuccessLength;
  map<size_t,const ImplState*> SuccessImpls;
  map<size_t,Action> SuccessActions;
  map<size_t,size_t> SuccessAlignments;

  map<size_t,set<int> > SuccessBuchi;

  int errId;

  vector<map<ContLoc*,size_t> > ContLocMapping;
  vector<map<Action,size_t> > ActionMapping;
  map<size_t,pair<size_t,Action> > RevActionMapping;
  vector<map<pair<PVal,ContLoc*>,size_t> > PValMapping;
  vector<map<pair<size_t,pair<size_t,short> >, size_t> > PredValMapping;
  vector<map<pair<short,short>, size_t> > SpecMapping;

  map<pair<size_t,size_t>, size_t> AlignmentMapping;
  map<size_t,pair<size_t,size_t> > RevAlignmentMapping;
  set<size_t> Unalignable;

  map<size_t,pair<size_t,size_t> > RevLoopMapping;

  vector<map<const ImplState*,size_t> > ImplMapping;
  map<size_t,pair<size_t,const ImplState*> > RevImplMapping;

  map<const ImplState*,set<size_t> > PossibleLoops;
  map<size_t,pair<size_t,size_t> > AcceptingMapping;
  
  vector<map<pair<size_t,size_t>,size_t > > TransMapping;

  vector<map<int,size_t> > BuchiLtsMapping;
  map<size_t,pair<size_t,int> > RevBuchiLtsMapping;

  vector<size_t> EmptyMapping;

  void VectorInsert(const set<size_t>&,vector<int>&);
  void VectorNegInsert(const set<size_t>&,vector<int>&);

  size_t GetContLocVar(ContLoc*, size_t);
  size_t GetActionVar(const Action&, size_t);
  size_t GetPValVar(const PVal&, size_t, ContLoc*);
  size_t GetPredValVar(const pair<size_t,pair<size_t,short> >&, size_t);
  size_t GetSpecVar(const pair<short,short> &, size_t);
  size_t GetImplVar(size_t, size_t, size_t, const ImplState*, size_t);
  size_t GetTransVar(const pair<size_t,size_t>&, size_t);
  size_t GetBuchiLtsVar(int, size_t);
  int GetAlignmentVar(size_t,size_t,ContLoc*);

  bool PropCompatible(const ImplState*,int specState);

  void AddClause(const vector<int> &arg);

  void AddEquivalence(const vector<int>&, int);
  void AddMutexConstraints(const set<size_t>&);

  void AddInitialConstraints(const set<const ImplState*>&, size_t);
  void AddImplStateConstraints(const ImplState*,size_t,set<const ImplState*>&,
			       set<size_t>&, set<size_t>&, set<size_t>&, 
			       set<size_t>&);
  void AddTransitionConstraints(const set<const ImplState*>&,size_t,
				set<const ImplState*>&, const set<int>&,
				set<int>&);

  void AddAlignmentAndDeltas(size_t);

  void AddBuchiConstraints();

  bool GenerateAndSolvePBS();

  bool DisplayPBSResultsSpurious(ProcManager&);

 public:

  Explain(ConcCEDag &initCE, Component &c) : CE(initCE),
    component(c) {}

  void Run();
};

} //namespace magic

#endif //__EXPLAIN_H__

/*********************************************************************/
//end of Explain.h
/*********************************************************************/
