/**************************** CPPHeaderFile ***************************

* FileName [DeadlockChecker.h]

* PackageName [main]

* Synopsis [Header file for DeadlockChecker class.]

* Description [This class encapsulates a deadlock checker.]

* SeeAlso [DeadlockChecker.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __DEADLOCKCHECKER_H__
#define __DEADLOCKCHECKER_H__

namespace magic {

//other classes needed
class BigInt;

/*********************************************************************/
//this class encapsulates a deadlock checker
/*********************************************************************/
class DeadlockChecker
{
 private:  
  static set<BigInt> visited;
  static list<BigInt> statePath;
  static list<Action> actPath;
  static list< set<BigInt> > rings;

 public:
  static bool CheckDeadlock();

  friend class GlobalCEDag;
};

} //namespace magic

#endif //__LTLCHECKER_H__

/*********************************************************************/
//end of DeadlockChecker.h
/*********************************************************************/
