/******************************** CPPFile *****************************

* FileName [DeadlockChecker.cpp]

* PackageName [main]

* Synopsis [Method definitions of DeadlockChecker class.]

* SeeAlso [DeadlockChecker.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cassert>
#include <gmp.h>
#include <string>
#include <list>
#include <set>
#include <map>
#include <vector>
using namespace std;

#include "BigInt.h"
#include "Util.h"
#include "Statistics.h"
#include "Node.h"
#include "Action.h"
#include "Database.h"
#include "GlobalAbsLts.h"
#include "DeadlockChecker.h"
using namespace magic;

/*********************************************************************/
//define static fields
/*********************************************************************/
set<BigInt> DeadlockChecker::visited;
list<BigInt> DeadlockChecker::statePath;
list<Action> DeadlockChecker::actPath;
list< set<BigInt> > DeadlockChecker::rings;


/*********************************************************************/
//check deadlock. return true if no deadlock and false otherwise.
/*********************************************************************/
bool DeadlockChecker::CheckDeadlock()
{
  //cleanup
  statePath.clear();
  actPath.clear();
  visited.clear();
  rings.clear();    
  //get states to start exploration with
  set<BigInt> front;
  GlobalAbsLts::GetInitStates(front);
  //check deadlock by BFS
  bool deadlock = false;
  BigInt deadLockedState;
  while(!deadlock && !front.empty()) {
    set<BigInt> newFront;
    for(set<BigInt>::const_iterator i = front.begin();i != front.end();++i) {
      if(GlobalAbsLts::IsDeadlocked(*i)) {
	deadLockedState = *i;
	deadlock = true;
	break;
      }
      map< Action,set<BigInt> > saa;
      GlobalAbsLts::GetSuccsAndActions(*i,saa);
      for(map< Action,set<BigInt> >::const_iterator j = saa.begin();j != saa.end();++j) {
	for(set<BigInt>::const_iterator k = j->second.begin();k != j->second.end();++k) {
	  if((front.count(*k) == 0) && (visited.count(*k) == 0)) newFront.insert(*k);
	}
      }
    }
    if(!deadlock) {
      rings.push_back(front);
      visited.insert(front.begin(),front.end());
      front = newFront;
    }
  }
  Util::Message(2,"number of reachable states = %d ...\n",visited.size());
  Statistics::stateNum = (Statistics::stateNum < visited.size()) ? visited.size() : Statistics::stateNum;
  if(deadlock) {
    statePath.push_front(deadLockedState);    
    for(list< set<BigInt> >::reverse_iterator i = rings.rbegin();i != rings.rend();++i) {      
      map< Action,set<BigInt> > paa;
      GlobalAbsLts::GetPredsAndActions(deadLockedState,paa);
      bool flag = false;
      for(map< Action,set<BigInt> >::const_iterator j = paa.begin();(!flag) && (j != paa.end());++j) {
	for(set<BigInt>::const_iterator k = j->second.begin();k != j->second.end();++k) {
	  if(i->count(*k) != 0) {
	    actPath.push_front(j->first);
	    statePath.push_front(*k);
	    deadLockedState = *k;
	    flag = true;
	    break;
	  }
	}
      }
      assert(flag);
    }
    return false;
  } else return true;
}

/*********************************************************************/
//end of DeadlockChecker.cpp
/*********************************************************************/
