/**************************** CPPHeaderFile ***************************

* FileName [ContLocSet.h]

* PackageName [main]

* Synopsis [Header file for ContLocSet class.]

* Description [This class encapsulates a set of control locations.]

* SeeAlso [ContLocSet.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __CONTLOCSET_H__
#define __CONTLOCSET_H__

namespace magic {

//other classes needed
class ContLoc;

class ContLocSet
{
 private:
  //all the locations in the set
  list<ContLoc*> contLocs;
  //the initial location
  ContLoc *initLoc;
  //the set of final locations
  list<ContLoc*> finalLocs;
  //the set of return locations
  list<ContLoc*> returnLocs;
  //the set of labeled locations
  list<ContLoc*> labelLocs;
  //the set of break locations
  list<ContLoc*> breakLocs;
  //the set of continue locations
  list<ContLoc*> continueLocs;
  //the set of goto locations
  list<ContLoc*> gotoLocs;
  //the final expression
  Expr finalExpr;

  void ConcatLocs(list<ContLoc*> &one,const list<ContLoc*> &two);

 public:
  ContLocSet();
  ContLocSet(const list<ContLoc*> &all,ContLoc *il,const list<ContLoc*> &fl,
	     const list<ContLoc*> &rl,const list<ContLoc*> &ll,
	     const list<ContLoc*> &bl,const list<ContLoc*> &cl,
	     const list<ContLoc*> &gl,const Expr &fe) {
    contLocs = all;
    initLoc = il;
    finalLocs = fl;
    returnLocs = rl;
    labelLocs = ll;
    breakLocs = bl;
    continueLocs = cl;
    gotoLocs = gl;
    finalExpr = fe;
  }
  ContLocSet(const ContLocSet &rhs);
  const ContLocSet &operator = (const ContLocSet &rhs);

  bool IsEmpty() const { return contLocs.empty(); }
  void Concat(const ContLocSet &arg);
  void Merge(const ContLocSet &arg);
  void Append(const ContLocSet &arg);

  const Expr &GetFinalExpr() const { return finalExpr; }
  void SetFinalExpr(const Expr &e);
  ContLoc *GetInitLoc() { return initLoc; }
  list<ContLoc*> &GetFinalLocs() { return finalLocs; }
  list<ContLoc*> &GetContLocs() { return contLocs; }
  list<ContLoc*> &GetGotoLocs() { return gotoLocs; }
  list<ContLoc*> &GetReturnLocs() { return returnLocs; }
  list<ContLoc*> GetIdLabelLocs();
  list<ContLoc*> GetCaseLocs();
  list<ContLoc*> GetDefaultLocs();
  void MakeBranchesUseful();
  void MakeBranchesFair();
  void HandleCases();
  void HandleBreaks();
  void HandleContinues();
};

} //namespace magic

#endif //__CONTLOCSET_H__

/*********************************************************************/
//end of ContLocSet.h
/*********************************************************************/
