/**************************** CPPHeaderFile ***************************

* FileName [ContLocExtractor.h]

* PackageName [main]

* Synopsis [Header file for ContLocExtractor class.]

* Description [This class encapsulates a AST walker that computes the
* set of control locations of the given procedure.]

* SeeAlso [ContLocExtractor.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __CONTLOCEXTRACTOR_H__
#define __CONTLOCEXTRACTOR_H__

namespace magic {

//other classes needed
class Node;
class ContLocSet;
class Expr;

class ContLocExtractor : public DFSAdapter
{
 private:
  //the name of the procedure whose control locations we are computing
  string procName;
  //the cache
  map<const Node*,ContLocSet> cache;
  //the set of all control locations created
  set<ContLoc*> allLocs;

  ContLocSet &GetOut(const Node *n);
  void SetOut(const Node *n,const ContLocSet &c);
  ContLoc *CreateAssignContLoc(const BasicExpr *lhs,const BasicExpr *rhs);
  ContLocSet CreateSingletonContLocSet(ContLoc *cloc,const Expr &fexpr);
  ContLocSet CreateCondExprContLocSet(const BasicExpr *ifExpr,
				      const BasicExpr *thExpr,const BasicExpr *elExpr);
  void HandleGotos(ContLocSet &res);
  ContLocSet GetBranchContLocSet(ContLoc *loc,const BasicExpr *expr,const bool loopBranch);
  void CheckBranchUseful(ContLocSet &locs,const Expr &expr);
  void CheckBranchFair(ContLocSet &locs,const Expr &expr);

 public:
  ContLocExtractor();
  ContLocExtractor(const string &n);
  ContLocExtractor(const ContLocExtractor &rhs);
  virtual ~ContLocExtractor();
  const ContLocExtractor &operator = (const ContLocExtractor &rhs);

  //overriden methods of DFSAdapter - expressions
  void outIdExpr(const IdExpr &node);
  void outIntConstExpr(const IntConstExpr &node);
  void outConstExpr(const ConstExpr &node);
  void outStrExpr(const StrExpr &node);
  void outStrStrExpr(const StrStrExpr &node);
  void outStmtExpr(const StmtExpr &node);
  void outBrackExpr(const BrackExpr &node);
  void outParExpr(const ParExpr &node);
  void outDotExpr(const DotExpr &node);
  void outArrowExpr(const ArrowExpr &node);
  void outIncExpr(const IncExpr &node);
  void outUnaryExpr(const UnaryExpr &node);
  void outEmptyExpr(const EmptyExpr &node);
  void outBinaryExpr(const BinaryExpr &node);
  void outQuestExpr(const QuestExpr &node);
  void outAssignExpr(const AssignExpr &node);

  //overriden methods of DFSAdapter - statements
  void outLabelStmt(const LabelStmt &node);
  void outCaseStmt(const CaseStmt &node);
  void outDefaultStmt(const DefaultStmt &node);
  void outCompStmt(const CompStmt &node);
  void outExprStmt(const ExprStmt &node);
  void outEmptyStmt(const EmptyStmt &node);
  void outIfStmt(const IfStmt &node);
  void outSwitchStmt(const SwitchStmt &node);
  void outWhileStmt(const WhileStmt &node);
  void outDoStmt(const DoStmt &node);
  void outForStmt(const ForStmt &node);
  void outGotoStmt(const GotoStmt &node);
  void outContinueStmt(const ContinueStmt &node);
  void outBreakStmt(const BreakStmt &node);
  void outReturnStmt(const ReturnStmt &node);
};

} //namespace magic

#endif //__CONTLOCEXTRACTOR_H__

/*********************************************************************/
//end of ContLocExtractor.h
/*********************************************************************/
