/**************************** CPPHeaderFile ***************************

* FileName [CallGraphCreator.h]

* PackageName [main]

* Synopsis [Header file for CallGraphCreator class.]

* Description [This class encapsulates a AST walker that computes the
* set of procedures called by a given procedure.]

* SeeAlso [CallGraphCreator.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __CALLGRAPHCREATOR_H__
#define __CALLGRAPHCREATOR_H__

namespace magic {

class CallGraphCreator : public DFSAdapter
{
 private:
  //the info about the caller procedure
  ProcInfo &procInfo;
  //the set of called procedures
  set<string> callees;

 public:
  CallGraphCreator(ProcInfo &p) : procInfo(p) {}
  CallGraphCreator(const CallGraphCreator &rhs) : procInfo(rhs.procInfo),callees(rhs.callees) {}
  const CallGraphCreator &operator = (const CallGraphCreator &rhs) {
    assert(false);
    return *this;
  }
  virtual ~CallGraphCreator() {}

  set<string> GetCalledProcs() const { return callees; }

  //overloaded method
  void inParExpr(const ParExpr &node);
};

} //namespace magic

#endif //__CALLGRAPHCREATOR_H__

/*********************************************************************/
//end of CallGraphCreator.h
/*********************************************************************/
