/******************************** CPPFile *****************************

* FileName [CallGraphCreator.cpp]

* PackageName [main]

* Synopsis [Method definitions of CallGraphCreator class.]

* SeeAlso [CallGraphCreator.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include <cstdio>
#include <cassert>
#include <gmp.h>
#include <string>
#include <list>
#include <map>
#include <vector>
#include <set>
using namespace std;

#include "BigInt.h"
#include "Util.h"
#include "Node.h"
#include "DFSAdapter.h"
#include "ProcAbs.h"
#include "Action.h"
#include "Database.h"
#include "Predicate.h"
#include "PredSet.h"
#include "ContLoc.h"
#include "ProcInfo.h"
#include "CallGraphCreator.h"
using namespace magic;

/*********************************************************************/
//overloaded method
/*********************************************************************/
void CallGraphCreator::inParExpr(const ParExpr &node) 
{
  //add the called procedure to the list of called procedures if the
  //call is not abstracted by an action and is to be expanded
  string x = Util::TrimString(node.proc->ToString());
  pair<bool,int> a = Util::IsProcCall(&node);
  pair< set<string>,set<string> > y = procInfo.GetCallSiteInfo(node.proc,a.second);
  callees.insert(y.first.begin(),y.first.end());
}

/*********************************************************************/
//end of CallGraphCreator.cpp
/*********************************************************************/
