/**************************** CPPHeaderFile ***************************

* FileName [CallGraph.h]

* PackageName [main]

* Synopsis [Header file for CallGraph class.]

* Description [This class encapsulates a call graph.]

* SeeAlso [CallGraph.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __CALLGRAPH_H__
#define __CALLGRAPH_H__

namespace magic {

class CallGraph
{
 private:
  //the list of procedure names in the call graph
  set<string> nodes;

  //the edges
  map< string,set<string> > edges;

 public:
  CallGraph() {}
  CallGraph(const CallGraph &rhs) { *this = rhs; }
  const CallGraph &operator = (const CallGraph &rhs) {
    nodes = rhs.nodes;
    edges = rhs.edges;
    return *this;
  }
  void AddNode(const string &name) {
    nodes.insert(name);
  }
  void AddEdge(const string &from,const string &to) {
    edges[from].insert(to);
  }
  bool ContainsNode(const string &name) {
    return (nodes.count(name) != 0);
  }
  const set<string> &GetNodes() const { return nodes; }
  const map< string,set<string> > &GetEdges() const { return edges; }
};

} //namespace magic

#endif //__CALLGRAPH_H__

/*********************************************************************/
//end of CallGraph.h
/*********************************************************************/
