/**************************** CPPHeaderFile ***************************

* FileName [CEDagVerifier.h]

* PackageName [main]

* Synopsis [Header file for CEDagVerifier class.]

* Description [This class verifies if the projection of the counter
* example on a program component is valid.]

* SeeAlso [CEDagVerifier.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __CEDAGVERIFIER_H__
#define __CEDAGVERIFIER_H__

namespace magic {

//other classes needed
class ProcManager;
class ImplState;
class ConcCEDag;

/*********************************************************************/
//the CE dag verifier
/*********************************************************************/
class CEDagVerifier
{
 private:
  //the component we are concerned with
  Component &component;

  //flag to indicate if all counterexamples should be displayed
  bool displayCE;

  //flag to indicate if a spurious path was discovered in the concrete
  //CE dag
  bool spuriousCE;

  //top-level routines
  int RunFsp();
  int RunLtl();
  int RunDeadlock();

  void VerifyConcreteDag(const ConcCEDag &concDag);
  set<Expr> UpdateSP(const set<Expr> &old,const Expr &lhs,const Expr &rhs) const;
  set<Expr> UpdateSP(const set<Expr> &old,const list<Expr> &lhsList,const list<Expr> &rhsList) const;
  set<Expr> UpdateWP(const set<Expr> &old,const Expr &lhs,const Expr &rhs) const;
  set<Expr> UpdateWP(const set<Expr> &old,const list<Expr> &lhsList,const list<Expr> &rhsList) const;

 public:
  static const int CE_VALID;
  static const int CE_INVALID_DAG;
  static const int CE_UNDECIDED_DAG;
  static const int CE_INVALID_PATH;
  static const int CE_UNDECIDED_PATH;

  CEDagVerifier(Component &c,bool d) : component(c) { 
    displayCE = d;
    spuriousCE = false;
  }
  CEDagVerifier(const CEDagVerifier &rhs) : component(rhs.component) { 
    displayCE = rhs.displayCE;
    spuriousCE = rhs.spuriousCE; 
  }

  int Run();
  void UpdatePrePost(const set<ContLoc*> &seeds,PredSet &preds,const int node,
		     const ConcCEDag &concDag,
		     map< int,pair<Action,Expr> > &inlinedAssignMap,
		     const bool pre) const;
  void UpdatePrePost(const set<ContLoc*> &seeds,set<ContLoc*> &expLocs,
		     set<Expr> &expSet,const int node,const ConcCEDag &concDag,
		     map< int,pair<Action,Expr> > &inlinedAssignMap,
		     const bool pre,const int type) const;
};

} //namespace magic

#endif //__CEDAGVERIFIER_H__

/*********************************************************************/
//end of CEDagVerifier.h
/*********************************************************************/
