/**************************** CPPHeaderFile ***************************

* FileName [Buchi.h]

* PackageName [main]

* Synopsis [Header file for Buchi class.]

* Description [This class encapsulates a Buchi automaton.]

* SeeAlso [Buchi.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __BUCHI_H__
#define __BUCHI_H__

namespace magic {

//other classes needed
class LtlFormula;

/*********************************************************************/
//the buchi automaton
/*********************************************************************/
class Buchi
{
 private:
  static LtlFormula formula;
  static size_t stateNum;
  static set<size_t> init;
  static map< size_t,set<size_t> > trans;
  static map< size_t,set<Expr> > posProp,negProp;
  static map< size_t,set<Action> > posAct,negAct;
  static set< set<size_t> > accept,scc;
  static vector< set<size_t> > acceptVector;

  static void Cleanup();
  static void CreateBuchi(const string &fname,map<Expr,string> &propToVar,
			  map<string,Expr> &varToProp,map<Action,string> &actToVar,
			  map<string,Action> &varToAct);
  static void ParseBuchi(const string &fname,map<Expr,string> &propToVar,
			 map<string,Expr> &varToProp,map<Action,string> &actToVar,
			 map<string,Action> &varToAct);
  static bool BuchiEmpty();
  static void ComputeSCC();
  static void DFS1(const size_t node,set<size_t> &visited,map<size_t,size_t> &finish);
  static void DFS2(const size_t node,const map< size_t,set<size_t> > &revTrans,set<size_t> &visited,set<size_t> &sccEle);
  static void SimplifyAccepting();
  static void Degeneralize();

 public:
  static const int LTL_TAUTOLOGY;
  static const int LTL_UNSATISFIABLE;
  static const int LTL_NON_TRIVIAL;

  static int Initialize(const LtlFormula &f);
  static size_t GetStateNum() { return stateNum * acceptVector.size(); }
  static void GetInitStates(set<int> &res);
  static set<Expr> GetPosProps(int node);
  static set<Expr> GetNegProps(int node);
  static set<Action> GetPosActs(int node);
  static set<Action> GetNegActs(int node);
  static set<int> GetSuccs(int node);
  static bool IsAccept(const int node);
  static bool IsSink(const int node);
  static void Display();  
};

} //namespace magic

#endif //__BUCHI_H__

/*********************************************************************/
//end of Buchi.h
/*********************************************************************/
