/**************************** CPPHeaderFile ***************************

* FileName [BigInt.h]

* PackageName [main]

* Synopsis [Header file for BigInt class.]

* Description [This class encapsulates an arbitrary precision
* integer.]

* SeeAlso [BigInt.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __BIGINT_H__
#define __BIGINT_H__

namespace magic {

/*********************************************************************/
//this class encapsulates an arbitrary precision integer
/*********************************************************************/
class BigInt 
{
 protected:  
  mpz_t data;

 public:
  BigInt();
  BigInt(const signed long int i);
  BigInt(const string &str,const int base);
  BigInt(const BigInt &rhs);
  ~BigInt();
  
  const BigInt &operator = (const BigInt &rhs);
  bool operator == (const BigInt &rhs) const;
  bool operator < (const BigInt &rhs) const;
  BigInt operator + (const BigInt &rhs) const;
  BigInt operator - (const BigInt &rhs) const;
  BigInt operator * (const BigInt &rhs) const;
  BigInt operator / (const BigInt &rhs) const;

  string ToString() const;
  signed long int ToSL() const;

  void Read(FILE *in);
  void Write(FILE *in) const;

  static void Add(BigInt &res,const BigInt &lhs,const BigInt &rhs);
  static void Mul(BigInt &res,const BigInt &lhs,const BigInt &rhs);
  static void Div(BigInt &quo,BigInt &rem,const BigInt &lhs,const BigInt &rhs);
};

} //namespace magic

#endif //__BIGINT_H__

/*********************************************************************/
//end of BigInt.h
/*********************************************************************/
