/**************************** CPPHeaderFile ***************************

* FileName [AbsRefiner.h]

* PackageName [main]

* Synopsis [Header file for the AbsRefiner class. This class is
* responsbile for refining the abstraction by seeding the control
* locations with appropriate predicates.]

* Description []

* SeeAlso [AbsRefiner.cpp]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University.  All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#ifndef __ABSREFINER_H__
#define __ABSREFINER_H__

namespace magic {

//other classes needed
class Expr;
class PredSet;

/*********************************************************************/
//the abstraction refiner
/*********************************************************************/
class AbsRefiner
{
 private:
  static int RunC();

#ifdef MAGIC_FULL
  static int RunPacc();
#endif //MAGIC_FULL

 public:
  static const int CE_VALID;
  static const int CE_INVALID_REFINED;
  static const int CE_INVALID_NOT_REFINED;

  static int Run();
};

} //namespace magic

#endif //__ABSREFINER_H__

/*********************************************************************/
//end of AbsRefiner.h
/*********************************************************************/
