/******************************** CPPFile *****************************

* FileName [AGChecker.cpp]

* PackageName [main]

* Synopsis [Method definitions of AGChecker class.]

* SeeAlso [AGChecker.h]

* Author [Sagar Chaki]

* Copyright [ Copyright (c) 2002 by Carnegie Mellon University. All
* Rights Reserved. This software is for educational purposes only.
* Permission is given to academic institutions to use, copy, and
* modify this software and its documentation provided that this
* introductory message is not removed, that this software and its
* documentation is used for the institutions' internal research and
* educational purposes, and that no monies are exchanged. No guarantee
* is expressed or implied by the distribution of this code. Send
* bug-reports and/or questions to: chaki+@cs.cmu.edu. ]

**********************************************************************/

#include "common.h"
#include "FA.h"
#include "NFA.h"
#include "DFA.h"
#include "AngluinLearn.h"
#include "AGChecker.h"
using namespace magic;

/*********************************************************************/
//check for reachability of ERROR state using Assume-Guarantee +
//learning
/*********************************************************************/
bool AGChecker::Run()
{  
  path ce;
  bool CE;
  DFA A; //to be learnt next
  //start is NULL, hack:toLearn aut is set to M. CHECK constructor code!!
  //MATeacher T2(L.GetPrevCandidate(), MAGIC); 
  MATeacher T2(MAGIC); 
  AngluinLearn L2(NULL, T2);
  
  while(1) {
    string mcString("magic --abstraction abs0 --trace _MA.spec _M.spec _A.spec _M.c.pp _A.c.pp --ceShowAct --dataComm");

    while(1) {
      cout<<"writing DFA _A to magic files"<<endl;
      (L2.GetNewCandidate())->writeToMagicFiles("_A");
      ce.clear();
      CE = T2.CheckIfCandidate(mcString,ce);
      if( !CE) break;
      cout<<"***learning from ce=$"<<ce<<"$"<<endl;
      L2.LearnCE(ce, false);
    }
    cout<<"Finished learning Assumptions"<<endl;

    //check rest against A
    (L2.GetPrevCandidate())->writeToMagicFiles("_A");
    system("magic --abstraction abs0 --trace _Mrest.spec _A.spec read_msg_queue.c.pp ipc_queue.c.pp critical_section.c.pp read_msg_queue.spec ipc_queue.spec critical_section.spec	--ceShowAct --dataComm");   //dont need A.c.pp, put link in _Mrest.spec
    CE = ReadCEFromFile("ce.out",ce);
    if(!CE) {
      cout<<"New component is substitutable. Compositional verification over."<<endl;
      break;
    }

    //otherwise check if ce is correct or not, ie M || ce falsifies P
    ofstream trFile("_tr.spec");
    trFile << "cproc do_tr {\n abstract {abs0, 1, DoTr};\n}\n";
    trFile << "DoTr = (";
    istringstream s(ce);
    string token;
    s>>token; trFile << token;
    while( s>> token) {
      trFile << " -> "<< token;
    }
    trFile << " -> return{} -> STOP)";
    trFile<<"}.\n";
    trFile.close();
    cout<<"checking if ["<<ce<<"] is correct"<<endl;
    system("magic --abstraction abs0 --trace _Mtr.spec _M.spec _tr.spec _M.c.pp _tr.c.pp --ceShowAct --dataComm");
    ifstream ceFile("ce.out");
    string line;
    getline(ceFile,line);
    //if true return ERROR
    if( line != "1") { cout<<"counterexample ["<<ce<<"] found"<<endl; break;}
    //if false add it to A and repeat.
    else  {
      L2.LearnCE(ce, false);
      ce.clear();
    }
  } 
  return false;
}

/*********************************************************************/
//end of AGChecker.cpp
/*********************************************************************/
