typedef unsigned int size_t;
typedef long __time_t;
typedef __time_t time_t;
struct stack_st {
   int num ;
   char **data ;
   int sorted ;
   int num_alloc ;
   int (*comp)(char const * const * , char const * const * ) ;
};
typedef struct stack_st STACK;
struct bio_st;
struct crypto_ex_data_st {
   STACK *sk ;
   int dummy ;
};
typedef struct crypto_ex_data_st CRYPTO_EX_DATA;
typedef int CRYPTO_EX_new(void *parent , void *ptr , CRYPTO_EX_DATA *ad , int idx ,
                          long argl , void *argp );
typedef void CRYPTO_EX_free(void *parent , void *ptr , CRYPTO_EX_DATA *ad , int idx ,
                            long argl , void *argp );
typedef int CRYPTO_EX_dup(CRYPTO_EX_DATA *to , CRYPTO_EX_DATA *from , void *from_d ,
                          int idx , long argl , void *argp );
typedef struct bio_st BIO;
typedef void bio_info_cb(struct bio_st * , int , char const * , int , long ,
                         long );struct bio_method_st {
   int type ;
   char const *name ;
   int (*bwrite)(BIO * , char const * , int ) ;
   int (*bread)(BIO * , char * , int ) ;
   int (*bputs)(BIO * , char const * ) ;
   int (*bgets)(BIO * , char * , int ) ;
   long (*ctrl)(BIO * , int , long , void * ) ;
   int (*create)(BIO * ) ;
   int (*destroy)(BIO * ) ;
   long (*callback_ctrl)(BIO * , int , bio_info_cb * ) ;
};
typedef struct bio_method_st BIO_METHOD;
struct bio_st {
   BIO_METHOD *method ;
   long (*callback)(struct bio_st * , int , char const * , int , long , long ) ;
   char *cb_arg ;
   int init ;
   int shutdown ;
   int flags ;
   int retry_reason ;
   int num ;
   void *ptr ;
   struct bio_st *next_bio ;
   struct bio_st *prev_bio ;
   int references ;
   unsigned long num_read ;
   unsigned long num_write ;
   CRYPTO_EX_DATA ex_data ;
};
struct bignum_st {
   unsigned long *d ;
   int top ;
   int dmax ;
   int neg ;
   int flags ;
};
typedef struct bignum_st BIGNUM;
struct bignum_ctx {
   int tos ;
   BIGNUM bn[16] ;
   int flags ;
   int depth ;
   int pos[12] ;
   int too_many ;
};
typedef struct bignum_ctx BN_CTX;
struct bn_blinding_st {
   int init ;
   BIGNUM *A ;
   BIGNUM *Ai ;
   BIGNUM *mod ;
};
typedef struct bn_blinding_st BN_BLINDING;
struct bn_mont_ctx_st {
   int ri ;
   BIGNUM RR ;
   BIGNUM N ;
   BIGNUM Ni ;
   unsigned long n0 ;
   int flags ;
};
typedef struct bn_mont_ctx_st BN_MONT_CTX;
struct X509_algor_st;struct X509_algor_st;
struct asn1_object_st {
   char const *sn ;
   char const *ln ;
   int nid ;
   int length ;
   unsigned char *data ;
   int flags ;
};
typedef struct asn1_object_st ASN1_OBJECT;
struct asn1_string_st {
   int length ;
   int type ;
   unsigned char *data ;
   long flags ;
};
typedef struct asn1_string_st ASN1_STRING;
typedef struct asn1_string_st ASN1_INTEGER;
typedef struct asn1_string_st ASN1_ENUMERATED;
typedef struct asn1_string_st ASN1_BIT_STRING;
typedef struct asn1_string_st ASN1_OCTET_STRING;
typedef struct asn1_string_st ASN1_PRINTABLESTRING;
typedef struct asn1_string_st ASN1_T61STRING;
typedef struct asn1_string_st ASN1_IA5STRING;
typedef struct asn1_string_st ASN1_GENERALSTRING;
typedef struct asn1_string_st ASN1_UNIVERSALSTRING;
typedef struct asn1_string_st ASN1_BMPSTRING;
typedef struct asn1_string_st ASN1_UTCTIME;
typedef struct asn1_string_st ASN1_TIME;
typedef struct asn1_string_st ASN1_GENERALIZEDTIME;
typedef struct asn1_string_st ASN1_VISIBLESTRING;
typedef struct asn1_string_st ASN1_UTF8STRING;
typedef int ASN1_BOOLEAN;
union __anonunion_value_19 {
   char *ptr ;
   ASN1_BOOLEAN boolean ;
   ASN1_STRING *asn1_string ;
   ASN1_OBJECT *object ;
   ASN1_INTEGER *integer ;
   ASN1_ENUMERATED *enumerated ;
   ASN1_BIT_STRING *bit_string ;
   ASN1_OCTET_STRING *octet_string ;
   ASN1_PRINTABLESTRING *printablestring ;
   ASN1_T61STRING *t61string ;
   ASN1_IA5STRING *ia5string ;
   ASN1_GENERALSTRING *generalstring ;
   ASN1_BMPSTRING *bmpstring ;
   ASN1_UNIVERSALSTRING *universalstring ;
   ASN1_UTCTIME *utctime ;
   ASN1_GENERALIZEDTIME *generalizedtime ;
   ASN1_VISIBLESTRING *visiblestring ;
   ASN1_UTF8STRING *utf8string ;
   ASN1_STRING *set ;
   ASN1_STRING *sequence ;
};
struct asn1_type_st {
   int type ;
   union __anonunion_value_19 value ;
};
typedef struct asn1_type_st ASN1_TYPE;
struct lhash_node_st {
   void *data ;
   struct lhash_node_st *next ;
   unsigned long hash ;
};
typedef struct lhash_node_st LHASH_NODE;
struct lhash_st {
   LHASH_NODE **b ;
   int (*comp)() ;
   unsigned long (*hash)() ;
   unsigned int num_nodes ;
   unsigned int num_alloc_nodes ;
   unsigned int p ;
   unsigned int pmax ;
   unsigned long up_load ;
   unsigned long down_load ;
   unsigned long num_items ;
   unsigned long num_expands ;
   unsigned long num_expand_reallocs ;
   unsigned long num_contracts ;
   unsigned long num_contract_reallocs ;
   unsigned long num_hash_calls ;
   unsigned long num_comp_calls ;
   unsigned long num_insert ;
   unsigned long num_replace ;
   unsigned long num_delete ;
   unsigned long num_no_delete ;
   unsigned long num_retrieve ;
   unsigned long num_retrieve_miss ;
   unsigned long num_hash_comps ;
   int error ;
};
typedef struct lhash_st LHASH;
struct buf_mem_st {
   int length ;
   char *data ;
   int max ;
};
typedef struct buf_mem_st BUF_MEM;
struct MD2state_st {
   int num ;
   unsigned char data[16] ;
   unsigned int cksm[16] ;
   unsigned int state[16] ;
};
typedef struct MD2state_st MD2_CTX;
struct MD4state_st {
   unsigned int A ;
   unsigned int B ;
   unsigned int C ;
   unsigned int D ;
   unsigned int Nl ;
   unsigned int Nh ;
   unsigned int data[16] ;
   int num ;
};
typedef struct MD4state_st MD4_CTX;
struct MD5state_st {
   unsigned int A ;
   unsigned int B ;
   unsigned int C ;
   unsigned int D ;
   unsigned int Nl ;
   unsigned int Nh ;
   unsigned int data[16] ;
   int num ;
};
typedef struct MD5state_st MD5_CTX;
struct SHAstate_st {
   unsigned int h0 ;
   unsigned int h1 ;
   unsigned int h2 ;
   unsigned int h3 ;
   unsigned int h4 ;
   unsigned int Nl ;
   unsigned int Nh ;
   unsigned int data[16] ;
   int num ;
};
typedef struct SHAstate_st SHA_CTX;
struct RIPEMD160state_st {
   unsigned int A ;
   unsigned int B ;
   unsigned int C ;
   unsigned int D ;
   unsigned int E ;
   unsigned int Nl ;
   unsigned int Nh ;
   unsigned int data[16] ;
   int num ;
};
typedef struct RIPEMD160state_st RIPEMD160_CTX;
typedef unsigned char des_cblock[8];
union __anonunion_ks_20 {
   des_cblock cblock ;
   unsigned long deslong[2] ;
};
struct des_ks_struct {
   union __anonunion_ks_20 ks ;
   int weak_key ;
};
typedef struct des_ks_struct des_key_schedule[16];
struct rc4_key_st {
   unsigned int x ;
   unsigned int y ;
   unsigned int data[256] ;
};
typedef struct rc4_key_st RC4_KEY;
struct rc2_key_st {
   unsigned int data[64] ;
};
typedef struct rc2_key_st RC2_KEY;
struct rc5_key_st {
   int rounds ;
   unsigned long data[34] ;
};
typedef struct rc5_key_st RC5_32_KEY;
struct bf_key_st {
   unsigned int P[18] ;
   unsigned int S[1024] ;
};
typedef struct bf_key_st BF_KEY;
struct cast_key_st {
   unsigned long data[32] ;
   int short_key ;
};
typedef struct cast_key_st CAST_KEY;
struct idea_key_st {
   unsigned int data[9][6] ;
};
typedef struct idea_key_st IDEA_KEY_SCHEDULE;
struct mdc2_ctx_st {
   int num ;
   unsigned char data[8] ;
   des_cblock h ;
   des_cblock hh ;
   int pad_type ;
};
typedef struct mdc2_ctx_st MDC2_CTX;
struct rsa_st;typedef struct rsa_st RSA;
struct rsa_meth_st {
   char const *name ;
   int (*rsa_pub_enc)(int flen , unsigned char *from , unsigned char *to , RSA *rsa ,
                      int padding ) ;
   int (*rsa_pub_dec)(int flen , unsigned char *from , unsigned char *to , RSA *rsa ,
                      int padding ) ;
   int (*rsa_priv_enc)(int flen , unsigned char *from , unsigned char *to , RSA *rsa ,
                       int padding ) ;
   int (*rsa_priv_dec)(int flen , unsigned char *from , unsigned char *to , RSA *rsa ,
                       int padding ) ;
   int (*rsa_mod_exp)(BIGNUM *r0 , BIGNUM *I , RSA *rsa ) ;
   int (*bn_mod_exp)(BIGNUM *r , BIGNUM *a , BIGNUM const *p , BIGNUM const *m ,
                     BN_CTX *ctx , BN_MONT_CTX *m_ctx ) ;
   int (*init)(RSA *rsa ) ;
   int (*finish)(RSA *rsa ) ;
   int flags ;
   char *app_data ;
   int (*rsa_sign)(int type , unsigned char *m , unsigned int m_len , unsigned char *sigret ,
                   unsigned int *siglen , RSA *rsa ) ;
   int (*rsa_verify)(int dtype , unsigned char *m , unsigned int m_len , unsigned char *sigbuf ,
                     unsigned int siglen , RSA *rsa ) ;
};
typedef struct rsa_meth_st RSA_METHOD;
struct rsa_st {
   int pad ;
   int version ;
   RSA_METHOD *meth ;
   BIGNUM *n ;
   BIGNUM *e ;
   BIGNUM *d ;
   BIGNUM *p ;
   BIGNUM *q ;
   BIGNUM *dmp1 ;
   BIGNUM *dmq1 ;
   BIGNUM *iqmp ;
   CRYPTO_EX_DATA ex_data ;
   int references ;
   int flags ;
   BN_MONT_CTX *_method_mod_n ;
   BN_MONT_CTX *_method_mod_p ;
   BN_MONT_CTX *_method_mod_q ;
   char *bignum_data ;
   BN_BLINDING *blinding ;
};
struct dh_st;typedef struct dh_st DH;
struct dh_method {
   char const *name ;
   int (*generate_key)(DH *dh ) ;
   int (*compute_key)(unsigned char *key , BIGNUM *pub_key , DH *dh ) ;
   int (*bn_mod_exp)(DH *dh , BIGNUM *r , BIGNUM *a , BIGNUM const *p , BIGNUM const *m ,
                     BN_CTX *ctx , BN_MONT_CTX *m_ctx ) ;
   int (*init)(DH *dh ) ;
   int (*finish)(DH *dh ) ;
   int flags ;
   char *app_data ;
};
typedef struct dh_method DH_METHOD;
struct dh_st {
   int pad ;
   int version ;
   BIGNUM *p ;
   BIGNUM *g ;
   int length ;
   BIGNUM *pub_key ;
   BIGNUM *priv_key ;
   int flags ;
   char *method_mont_p ;
   BIGNUM *q ;
   BIGNUM *j ;
   unsigned char *seed ;
   int seedlen ;
   BIGNUM *counter ;
   int references ;
   CRYPTO_EX_DATA ex_data ;
   DH_METHOD *meth ;
};
struct dsa_st;typedef struct dsa_st DSA;
struct DSA_SIG_st {
   BIGNUM *r ;
   BIGNUM *s ;
};
typedef struct DSA_SIG_st DSA_SIG;
struct dsa_method {
   char const *name ;
   DSA_SIG *(*dsa_do_sign)(unsigned char const *dgst , int dlen , DSA *dsa ) ;
   int (*dsa_sign_setup)(DSA *dsa , BN_CTX *ctx_in , BIGNUM **kinvp , BIGNUM **rp ) ;
   int (*dsa_do_verify)(unsigned char const *dgst , int dgst_len , DSA_SIG *sig ,
                        DSA *dsa ) ;
   int (*dsa_mod_exp)(DSA *dsa , BIGNUM *rr , BIGNUM *a1 , BIGNUM *p1 , BIGNUM *a2 ,
                      BIGNUM *p2 , BIGNUM *m , BN_CTX *ctx , BN_MONT_CTX *in_mont ) ;
   int (*bn_mod_exp)(DSA *dsa , BIGNUM *r , BIGNUM *a , BIGNUM const *p , BIGNUM const *m ,
                     BN_CTX *ctx , BN_MONT_CTX *m_ctx ) ;
   int (*init)(DSA *dsa ) ;
   int (*finish)(DSA *dsa ) ;
   int flags ;
   char *app_data ;
};
typedef struct dsa_method DSA_METHOD;
struct dsa_st {
   int pad ;
   int version ;
   int write_params ;
   BIGNUM *p ;
   BIGNUM *q ;
   BIGNUM *g ;
   BIGNUM *pub_key ;
   BIGNUM *priv_key ;
   BIGNUM *kinv ;
   BIGNUM *r ;
   int flags ;
   char *method_mont_p ;
   int references ;
   CRYPTO_EX_DATA ex_data ;
   DSA_METHOD *meth ;
};
union __anonunion_pkey_21 {
   char *ptr ;
   struct rsa_st *rsa ;
   struct dsa_st *dsa ;
   struct dh_st *dh ;
};
struct evp_pkey_st {
   int type ;
   int save_type ;
   int references ;
   union __anonunion_pkey_21 pkey ;
   int save_parameters ;
   STACK *attributes ;
};
typedef struct evp_pkey_st EVP_PKEY;
struct env_md_st {
   int type ;
   int pkey_type ;
   int md_size ;
   void (*init)() ;
   void (*update)() ;
   void (*final)() ;
   int (*sign)() ;
   int (*verify)() ;
   int required_pkey_type[5] ;
   int block_size ;
   int ctx_size ;
};
typedef struct env_md_st EVP_MD;
union __anonunion_md_22 {
   unsigned char base[4] ;
   MD2_CTX md2 ;
   MD5_CTX md5 ;
   MD4_CTX md4 ;
   RIPEMD160_CTX ripemd160 ;
   SHA_CTX sha ;
   MDC2_CTX mdc2 ;
};
struct env_md_ctx_st {
   EVP_MD const *digest ;
   union __anonunion_md_22 md ;
};
typedef struct env_md_ctx_st EVP_MD_CTX;
struct evp_cipher_st;typedef struct evp_cipher_st EVP_CIPHER;
struct evp_cipher_ctx_st;typedef struct evp_cipher_ctx_st EVP_CIPHER_CTX;
struct evp_cipher_st {
   int nid ;
   int block_size ;
   int key_len ;
   int iv_len ;
   unsigned long flags ;
   int (*init)(EVP_CIPHER_CTX *ctx , unsigned char const *key , unsigned char const *iv ,
               int enc ) ;
   int (*do_cipher)(EVP_CIPHER_CTX *ctx , unsigned char *out , unsigned char const *in ,
                    unsigned int inl ) ;
   int (*cleanup)(EVP_CIPHER_CTX * ) ;
   int ctx_size ;
   int (*set_asn1_parameters)(EVP_CIPHER_CTX * , ASN1_TYPE * ) ;
   int (*get_asn1_parameters)(EVP_CIPHER_CTX * , ASN1_TYPE * ) ;
   int (*ctrl)(EVP_CIPHER_CTX * , int type , int arg , void *ptr ) ;
   void *app_data ;
};
struct __anonstruct_rc4_24 {
   unsigned char key[16] ;
   RC4_KEY ks ;
};
struct __anonstruct_desx_cbc_25 {
   des_key_schedule ks ;
   des_cblock inw ;
   des_cblock outw ;
};
struct __anonstruct_des_ede_26 {
   des_key_schedule ks1 ;
   des_key_schedule ks2 ;
   des_key_schedule ks3 ;
};
struct __anonstruct_rc2_27 {
   int key_bits ;
   RC2_KEY ks ;
};
struct __anonstruct_rc5_28 {
   int rounds ;
   RC5_32_KEY ks ;
};
union __anonunion_c_23 {
   struct __anonstruct_rc4_24 rc4 ;
   des_key_schedule des_ks ;
   struct __anonstruct_desx_cbc_25 desx_cbc ;
   struct __anonstruct_des_ede_26 des_ede ;
   IDEA_KEY_SCHEDULE idea_ks ;
   struct __anonstruct_rc2_27 rc2 ;
   struct __anonstruct_rc5_28 rc5 ;
   BF_KEY bf_ks ;
   CAST_KEY cast_ks ;
};
struct evp_cipher_ctx_st {
   EVP_CIPHER const *cipher ;
   int encrypt ;
   int buf_len ;
   unsigned char oiv[8] ;
   unsigned char iv[8] ;
   unsigned char buf[8] ;
   int num ;
   void *app_data ;
   int key_len ;
   union __anonunion_c_23 c ;
};
struct X509_algor_st {
   ASN1_OBJECT *algorithm ;
   ASN1_TYPE *parameter ;
};
typedef struct X509_algor_st X509_ALGOR;
struct X509_val_st {
   ASN1_TIME *notBefore ;
   ASN1_TIME *notAfter ;
};
typedef struct X509_val_st X509_VAL;
struct X509_pubkey_st {
   X509_ALGOR *algor ;
   ASN1_BIT_STRING *public_key ;
   EVP_PKEY *pkey ;
};
typedef struct X509_pubkey_st X509_PUBKEY;
struct X509_name_st {
   STACK *entries ;
   int modified ;
   BUF_MEM *bytes ;
   unsigned long hash ;
};
typedef struct X509_name_st X509_NAME;
struct x509_cinf_st {
   ASN1_INTEGER *version ;
   ASN1_INTEGER *serialNumber ;
   X509_ALGOR *signature ;
   X509_NAME *issuer ;
   X509_VAL *validity ;
   X509_NAME *subject ;
   X509_PUBKEY *key ;
   ASN1_BIT_STRING *issuerUID ;
   ASN1_BIT_STRING *subjectUID ;
   STACK *extensions ;
};
typedef struct x509_cinf_st X509_CINF;
struct x509_cert_aux_st {
   STACK *trust ;
   STACK *reject ;
   ASN1_UTF8STRING *alias ;
   ASN1_OCTET_STRING *keyid ;
   STACK *other ;
};
typedef struct x509_cert_aux_st X509_CERT_AUX;
struct AUTHORITY_KEYID_st;struct x509_st {
   X509_CINF *cert_info ;
   X509_ALGOR *sig_alg ;
   ASN1_BIT_STRING *signature ;
   int valid ;
   int references ;
   char *name ;
   CRYPTO_EX_DATA ex_data ;
   long ex_pathlen ;
   unsigned long ex_flags ;
   unsigned long ex_kusage ;
   unsigned long ex_xkusage ;
   unsigned long ex_nscert ;
   ASN1_OCTET_STRING *skid ;
   struct AUTHORITY_KEYID_st *akid ;
   unsigned char sha1_hash[20] ;
   X509_CERT_AUX *aux ;
};
typedef struct x509_st X509;
struct x509_store_ctx_st;typedef struct x509_store_ctx_st X509_STORE_CTX;
struct x509_store_st {
   int cache ;
   STACK *objs ;
   STACK *get_cert_methods ;
   int (*verify)(X509_STORE_CTX *ctx ) ;
   int (*verify_cb)(int ok , X509_STORE_CTX *ctx ) ;
   CRYPTO_EX_DATA ex_data ;
   int references ;
   int depth ;
};
typedef struct x509_store_st X509_STORE;
struct x509_store_ctx_st {
   X509_STORE *ctx ;
   int current_method ;
   X509 *cert ;
   STACK *untrusted ;
   int purpose ;
   int trust ;
   time_t check_time ;
   unsigned long flags ;
   void *other_ctx ;
   int (*verify)(X509_STORE_CTX *ctx ) ;
   int (*verify_cb)(int ok , X509_STORE_CTX *ctx ) ;
   int (*get_issuer)(X509 **issuer , X509_STORE_CTX *ctx , X509 *x ) ;
   int (*check_issued)(X509_STORE_CTX *ctx , X509 *x , X509 *issuer ) ;
   int (*cleanup)(X509_STORE_CTX *ctx ) ;
   int depth ;
   int valid ;
   int last_untrusted ;
   STACK *chain ;
   int error_depth ;
   int error ;
   X509 *current_cert ;
   X509 *current_issuer ;
   CRYPTO_EX_DATA ex_data ;
};
struct AUTHORITY_KEYID_st {
   ASN1_OCTET_STRING *keyid ;
   STACK *issuer ;
   ASN1_INTEGER *serial ;
};
struct comp_method_st {
   int type ;
   char const *name ;
   int (*init)() ;
   void (*finish)() ;
   int (*compress)() ;
   int (*expand)() ;
   long (*ctrl)() ;
   long (*callback_ctrl)() ;
};
typedef struct comp_method_st COMP_METHOD;
struct comp_ctx_st {
   COMP_METHOD *meth ;
   unsigned long compress_in ;
   unsigned long compress_out ;
   unsigned long expand_in ;
   unsigned long expand_out ;
   CRYPTO_EX_DATA ex_data ;
};
typedef struct comp_ctx_st COMP_CTX;
typedef int pem_password_cb(char *buf , int size , int rwflag , void *userdata );
struct ssl_st;
struct ssl_cipher_st {
   int valid ;
   char const *name ;
   unsigned long id ;
   unsigned long algorithms ;
   unsigned long algo_strength ;
   unsigned long algorithm2 ;
   int strength_bits ;
   int alg_bits ;
   unsigned long mask ;
   unsigned long mask_strength ;
};
typedef struct ssl_cipher_st SSL_CIPHER;
typedef struct ssl_st SSL;
struct ssl_ctx_st;typedef struct ssl_ctx_st SSL_CTX;
struct ssl3_enc_method;struct ssl_method_st {
   int version ;
   int (*ssl_new)(SSL *s ) ;
   void (*ssl_clear)(SSL *s ) ;
   void (*ssl_free)(SSL *s ) ;
   int (*ssl_accept)(SSL *s ) ;
   int (*ssl_connect)(SSL *s ) ;
   int (*ssl_read)(SSL *s , void *buf , int len ) ;
   int (*ssl_peek)(SSL *s , void *buf , int len ) ;
   int (*ssl_write)(SSL *s , void const *buf , int len ) ;
   int (*ssl_shutdown)(SSL *s ) ;
   int (*ssl_renegotiate)(SSL *s ) ;
   int (*ssl_renegotiate_check)(SSL *s ) ;
   long (*ssl_ctrl)(SSL *s , int cmd , long larg , char *parg ) ;
   long (*ssl_ctx_ctrl)(SSL_CTX *ctx , int cmd , long larg , char *parg ) ;
   SSL_CIPHER *(*get_cipher_by_char)(unsigned char const *ptr ) ;
   int (*put_cipher_by_char)(SSL_CIPHER const *cipher , unsigned char *ptr ) ;
   int (*ssl_pending)(SSL *s ) ;
   int (*num_ciphers)(void) ;
   SSL_CIPHER *(*get_cipher)(unsigned int ncipher ) ;
   struct ssl_method_st *(*get_ssl_method)(int version ) ;
   long (*get_timeout)(void) ;
   struct ssl3_enc_method *ssl3_enc ;
   int (*ssl_version)() ;
   long (*ssl_callback_ctrl)(SSL *s , int cb_id , void (*fp)() ) ;
   long (*ssl_ctx_callback_ctrl)(SSL_CTX *s , int cb_id , void (*fp)() ) ;
};
typedef struct ssl_method_st SSL_METHOD;
struct sess_cert_st;struct ssl_session_st {
   int ssl_version ;
   unsigned int key_arg_length ;
   unsigned char key_arg[8] ;
   int master_key_length ;
   unsigned char master_key[48] ;
   unsigned int session_id_length ;
   unsigned char session_id[32] ;
   unsigned int sid_ctx_length ;
   unsigned char sid_ctx[32] ;
   int not_resumable ;
   struct sess_cert_st *sess_cert ;
   X509 *peer ;
   long verify_result ;
   int references ;
   long timeout ;
   long time ;
   int compress_meth ;
   SSL_CIPHER *cipher ;
   unsigned long cipher_id ;
   STACK *ciphers ;
   CRYPTO_EX_DATA ex_data ;
   struct ssl_session_st *prev ;
   struct ssl_session_st *next ;
};
typedef struct ssl_session_st SSL_SESSION;
struct ssl_comp_st {
   int id ;
   char *name ;
   COMP_METHOD *method ;
};
typedef struct ssl_comp_st SSL_COMP;
struct __anonstruct_stats_40 {
   int sess_connect ;
   int sess_connect_renegotiate ;
   int sess_connect_good ;
   int sess_accept ;
   int sess_accept_renegotiate ;
   int sess_accept_good ;
   int sess_miss ;
   int sess_timeout ;
   int sess_cache_full ;
   int sess_hit ;
   int sess_cb_hit ;
};
struct cert_st;struct ssl_ctx_st {
   SSL_METHOD *method ;
   unsigned long options ;
   unsigned long mode ;
   STACK *cipher_list ;
   STACK *cipher_list_by_id ;
   struct x509_store_st *cert_store ;
   struct lhash_st *sessions ;
   unsigned long session_cache_size ;
   struct ssl_session_st *session_cache_head ;
   struct ssl_session_st *session_cache_tail ;
   int session_cache_mode ;
   long session_timeout ;
   int (*new_session_cb)(struct ssl_st *ssl , SSL_SESSION *sess ) ;
   void (*remove_session_cb)(struct ssl_ctx_st *ctx , SSL_SESSION *sess ) ;
   SSL_SESSION *(*get_session_cb)(struct ssl_st *ssl , unsigned char *data , int len ,
                                  int *copy ) ;
   struct __anonstruct_stats_40 stats ;
   int references ;
   void (*info_callback)() ;
   int (*app_verify_callback)() ;
   char *app_verify_arg ;
   struct cert_st *cert ;
   int read_ahead ;
   int verify_mode ;
   int verify_depth ;
   unsigned int sid_ctx_length ;
   unsigned char sid_ctx[32] ;
   int (*default_verify_callback)(int ok , X509_STORE_CTX *ctx ) ;
   int purpose ;
   int trust ;
   pem_password_cb *default_passwd_callback ;
   void *default_passwd_callback_userdata ;
   int (*client_cert_cb)() ;
   STACK *client_CA ;
   int quiet_shutdown ;
   CRYPTO_EX_DATA ex_data ;
   EVP_MD const *rsa_md5 ;
   EVP_MD const *md5 ;
   EVP_MD const *sha1 ;
   STACK *extra_certs ;
   STACK *comp_methods ;
};
struct ssl2_state_st;struct ssl3_state_st;struct ssl_st {
   int version ;
   int type ;
   SSL_METHOD *method ;
   BIO *rbio ;
   BIO *wbio ;
   BIO *bbio ;
   int rwstate ;
   int in_handshake ;
   int (*handshake_func)() ;
   int server ;
   int new_session ;
   int quiet_shutdown ;
   int shutdown ;
   int state ;
   int rstate ;
   BUF_MEM *init_buf ;
   int init_num ;
   int init_off ;
   unsigned char *packet ;
   unsigned int packet_length ;
   struct ssl2_state_st *s2 ;
   struct ssl3_state_st *s3 ;
   int read_ahead ;
   int hit ;
   int purpose ;
   int trust ;
   STACK *cipher_list ;
   STACK *cipher_list_by_id ;
   EVP_CIPHER_CTX *enc_read_ctx ;
   EVP_MD const *read_hash ;
   COMP_CTX *expand ;
   EVP_CIPHER_CTX *enc_write_ctx ;
   EVP_MD const *write_hash ;
   COMP_CTX *compress ;
   struct cert_st *cert ;
   unsigned int sid_ctx_length ;
   unsigned char sid_ctx[32] ;
   SSL_SESSION *session ;
   int verify_mode ;
   int verify_depth ;
   int (*verify_callback)(int ok , X509_STORE_CTX *ctx ) ;
   void (*info_callback)() ;
   int error ;
   int error_code ;
   SSL_CTX *ctx ;
   int debug ;
   long verify_result ;
   CRYPTO_EX_DATA ex_data ;
   STACK *client_CA ;
   int references ;
   unsigned long options ;
   unsigned long mode ;
   int first_packet ;
   int client_version ;
};
struct __anonstruct_tmp_41 {
   unsigned int conn_id_length ;
   unsigned int cert_type ;
   unsigned int cert_length ;
   unsigned int csl ;
   unsigned int clear ;
   unsigned int enc ;
   unsigned char ccl[32] ;
   unsigned int cipher_spec_length ;
   unsigned int session_id_length ;
   unsigned int clen ;
   unsigned int rlen ;
};
struct ssl2_state_st {
   int three_byte_header ;
   int clear_text ;
   int escape ;
   int ssl2_rollback ;
   unsigned int wnum ;
   int wpend_tot ;
   unsigned char const *wpend_buf ;
   int wpend_off ;
   int wpend_len ;
   int wpend_ret ;
   int rbuf_left ;
   int rbuf_offs ;
   unsigned char *rbuf ;
   unsigned char *wbuf ;
   unsigned char *write_ptr ;
   unsigned int padding ;
   unsigned int rlength ;
   int ract_data_length ;
   unsigned int wlength ;
   int wact_data_length ;
   unsigned char *ract_data ;
   unsigned char *wact_data ;
   unsigned char *mac_data ;
   unsigned char *pad_data_UNUSED ;
   unsigned char *read_key ;
   unsigned char *write_key ;
   unsigned int challenge_length ;
   unsigned char challenge[32] ;
   unsigned int conn_id_length ;
   unsigned char conn_id[16] ;
   unsigned int key_material_length ;
   unsigned char key_material[48] ;
   unsigned long read_sequence ;
   unsigned long write_sequence ;
   struct __anonstruct_tmp_41 tmp ;
};
struct ssl3_record_st {
   int type ;
   unsigned int length ;
   unsigned int off ;
   unsigned char *data ;
   unsigned char *input ;
   unsigned char *comp ;
};
typedef struct ssl3_record_st SSL3_RECORD;
struct ssl3_buffer_st {
   unsigned char *buf ;
   int offset ;
   int left ;
};
typedef struct ssl3_buffer_st SSL3_BUFFER;
struct __anonstruct_tmp_42 {
   unsigned char cert_verify_md[72] ;
   unsigned char finish_md[72] ;
   int finish_md_len ;
   unsigned char peer_finish_md[72] ;
   int peer_finish_md_len ;
   unsigned long message_size ;
   int message_type ;
   SSL_CIPHER *new_cipher ;
   DH *dh ;
   int next_state ;
   int reuse_message ;
   int cert_req ;
   int ctype_num ;
   char ctype[7] ;
   STACK *ca_names ;
   int use_rsa_tmp ;
   int key_block_length ;
   unsigned char *key_block ;
   EVP_CIPHER const *new_sym_enc ;
   EVP_MD const *new_hash ;
   SSL_COMP const *new_compression ;
   int cert_request ;
};
struct ssl3_state_st {
   long flags ;
   int delay_buf_pop_ret ;
   unsigned char read_sequence[8] ;
   unsigned char read_mac_secret[36] ;
   unsigned char write_sequence[8] ;
   unsigned char write_mac_secret[36] ;
   unsigned char server_random[32] ;
   unsigned char client_random[32] ;
   SSL3_BUFFER rbuf ;
   SSL3_BUFFER wbuf ;
   SSL3_RECORD rrec ;
   SSL3_RECORD wrec ;
   unsigned char alert_fragment[2] ;
   unsigned int alert_fragment_len ;
   unsigned char handshake_fragment[4] ;
   unsigned int handshake_fragment_len ;
   unsigned int wnum ;
   int wpend_tot ;
   int wpend_type ;
   int wpend_ret ;
   unsigned char const *wpend_buf ;
   EVP_MD_CTX finish_dgst1 ;
   EVP_MD_CTX finish_dgst2 ;
   int change_cipher_spec ;
   int warn_alert ;
   int fatal_alert ;
   int alert_dispatch ;
   unsigned char send_alert[2] ;
   int renegotiate ;
   int total_renegotiations ;
   int num_renegotiations ;
   int in_read_app_data ;
   struct __anonstruct_tmp_42 tmp ;
};
struct cert_pkey_st {
   X509 *x509 ;
   EVP_PKEY *privatekey ;
};
typedef struct cert_pkey_st CERT_PKEY;
struct cert_st {
   CERT_PKEY *key ;
   int valid ;
   unsigned long mask ;
   unsigned long export_mask ;
   RSA *rsa_tmp ;
   RSA *(*rsa_tmp_cb)(SSL *ssl , int is_export , int keysize ) ;
   DH *dh_tmp ;
   DH *(*dh_tmp_cb)(SSL *ssl , int is_export , int keysize ) ;
   CERT_PKEY pkeys[5] ;
   int references ;
};
typedef struct cert_st CERT;
struct sess_cert_st {
   STACK *cert_chain ;
   int peer_cert_type ;
   CERT_PKEY *peer_key ;
   CERT_PKEY peer_pkeys[5] ;
   RSA *peer_rsa_tmp ;
   DH *peer_dh_tmp ;
   int references ;
};
struct ssl3_enc_method {
   int (*enc)(SSL * , int ) ;
   int (*mac)(SSL * , unsigned char * , int ) ;
   int (*setup_key_block)(SSL * ) ;
   int (*generate_master_secret)(SSL * , unsigned char * , unsigned char * , int ) ;
   int (*change_cipher_state)(SSL * , int ) ;
   int (*final_finish_mac)(SSL * , EVP_MD_CTX * , EVP_MD_CTX * , char const * ,
                           int , unsigned char * ) ;
   int finish_mac_length ;
   int (*cert_verify_mac)(SSL * , EVP_MD_CTX * , unsigned char * ) ;
   char const *client_finished_label ;
   int client_finished_label_len ;
   char const *server_finished_label ;
   int server_finished_label_len ;
   int (*alert_value)(int ) ;
};
typedef struct ssl3_enc_method SSL3_ENC_METHOD;
extern int sk_num(STACK const * ) ;
extern char *sk_value(STACK const * , int ) ;
extern char *sk_set(STACK * , int , char * ) ;
extern STACK *sk_new_null(void) ;
extern void sk_free(STACK * ) ;
extern void sk_pop_free(STACK *st , void (*func)(void * ) ) ;
extern int sk_push(STACK *st , char *data ) ;
extern void sk_zero(STACK *st ) ;
extern STACK *sk_dup(STACK *st ) ;
extern int CRYPTO_get_ex_new_index(int idx , STACK **skp , long argl , void *argp ,
                                   CRYPTO_EX_new *new_func , CRYPTO_EX_dup *dup_func ,
                                   CRYPTO_EX_free *free_func ) ;extern int CRYPTO_set_ex_data(CRYPTO_EX_DATA *ad , int idx , void *val ) ;
extern void *CRYPTO_get_ex_data(CRYPTO_EX_DATA *ad , int idx ) ;
extern int CRYPTO_dup_ex_data(STACK *meth , CRYPTO_EX_DATA *to , CRYPTO_EX_DATA *from ) ;
extern void CRYPTO_free_ex_data(STACK *meth , void *obj , CRYPTO_EX_DATA *ad ) ;
extern void CRYPTO_new_ex_data(STACK *meth , void *obj , CRYPTO_EX_DATA *ad ) ;
extern int CRYPTO_add_lock(int *pointer , int amount , int type , char const *file ,
                           int line ) ;
extern void *CRYPTO_malloc(int num , char const *file , int line ) ;
extern void CRYPTO_free(void * ) ;
extern BIO *BIO_new(BIO_METHOD *type ) ;
extern int BIO_free(BIO *a ) ;
extern long BIO_ctrl(BIO *bp , int cmd , long larg , void *parg ) ;
extern long BIO_int_ctrl(BIO *bp , int cmd , long larg , int iarg ) ;
extern BIO *BIO_push(BIO *b , BIO *append ) ;
extern BIO *BIO_pop(BIO *b ) ;
extern void BIO_free_all(BIO *a ) ;
extern BIO *BIO_find_type(BIO *b , int bio_type ) ;
extern int BIO_get_retry_reason(BIO *bio ) ;
extern BIO_METHOD *BIO_s_socket(void) ;
extern BIO_METHOD *BIO_f_buffer(void) ;
extern time_t time(time_t *__timer ) ;
extern LHASH *lh_new(unsigned long (*h)() , int (*c)() ) ;
extern void lh_free(LHASH *lh ) ;
extern void BUF_MEM_free(BUF_MEM *a ) ;
extern int RSA_size(RSA * ) ;
extern int DH_size(DH *dh ) ;
extern int EVP_CIPHER_CTX_cleanup(EVP_CIPHER_CTX *a ) ;
extern EVP_MD const *EVP_get_digestbyname(char const *name ) ;
extern int EVP_PKEY_size(EVP_PKEY *pkey ) ;
extern X509_STORE *X509_STORE_new(void) ;
extern void X509_STORE_free(X509_STORE *v ) ;
extern int X509_STORE_load_locations(X509_STORE *ctx , char const *file , char const *dir ) ;
extern int X509_STORE_set_default_paths(X509_STORE *ctx ) ;
extern X509_NAME *X509_NAME_dup(X509_NAME *xn ) ;
extern void X509_NAME_free(X509_NAME *a ) ;
extern void X509_free(X509 *a ) ;
extern int X509_check_private_key(X509 *x509 , EVP_PKEY *pkey ) ;
extern int X509_TRUST_get_by_id(int id ) ;
extern int X509_PURPOSE_get_by_id(int id ) ;
extern void *memcpy(void * __restrict __dest , void const * __restrict __src ,
                    size_t __n ) ;
extern void *memset(void *__s , int __c , size_t __n ) ;
extern int memcmp(void const *__s1 , void const *__s2 , size_t __n ) __attribute__((__pure__)) ;
extern void COMP_CTX_free(COMP_CTX *ctx ) ;
extern void ERR_put_error(int lib , int func , int reason , char const *file , int line ) ;
extern unsigned long ERR_peek_error(void) ;
struct lhash_st *SSL_CTX_sessions(SSL_CTX *ctx ) ;
size_t SSL_get_finished(SSL *s , void *buf , size_t count ) ;
size_t SSL_get_peer_finished(SSL *s , void *buf , size_t count ) ;
int SSL_CTX_set_cipher_list(SSL_CTX *ctx , char const *str ) ;
SSL_CTX *SSL_CTX_new(SSL_METHOD *meth ) ;
void SSL_CTX_free(SSL_CTX *a ) ;
X509_STORE *SSL_CTX_get_cert_store(SSL_CTX *ctx ) ;
void SSL_CTX_set_cert_store(SSL_CTX *ctx , X509_STORE *store ) ;
int SSL_want(SSL *s ) ;
int SSL_clear(SSL *s ) ;
extern void SSL_CTX_flush_sessions(SSL_CTX *ctx , long tm ) ;
SSL_CIPHER *SSL_get_current_cipher(SSL *s ) ;
int SSL_get_fd(SSL *s ) ;
int SSL_get_rfd(SSL *s ) ;
int SSL_get_wfd(SSL *s ) ;
char const *SSL_get_cipher_list(SSL *s , int n ) ;
char *SSL_get_shared_ciphers(SSL *s , char *buf , int len ) ;
int SSL_get_read_ahead(SSL *s ) ;
int SSL_pending(SSL *s ) ;
int SSL_set_fd(SSL *s , int fd ) ;
int SSL_set_rfd(SSL *s , int fd ) ;
int SSL_set_wfd(SSL *s , int fd ) ;
void SSL_set_bio(SSL *s , BIO *rbio , BIO *wbio ) ;
BIO *SSL_get_rbio(SSL *s ) ;
BIO *SSL_get_wbio(SSL *s ) ;
int SSL_set_cipher_list(SSL *s , char const *str ) ;
void SSL_set_read_ahead(SSL *s , int yes ) ;
int SSL_get_verify_mode(SSL *s ) ;
int SSL_get_verify_depth(SSL *s ) ;
int (*SSL_get_verify_callback(SSL *s ))(int , X509_STORE_CTX * ) ;
void SSL_set_verify(SSL *s , int mode , int (*callback)(int ok , X509_STORE_CTX *ctx ) ) ;
void SSL_set_verify_depth(SSL *s , int depth ) ;
void SSL_copy_session_id(SSL *t , SSL *f ) ;
unsigned long SSL_SESSION_hash(SSL_SESSION *a ) ;
int SSL_SESSION_cmp(SSL_SESSION *a , SSL_SESSION *b ) ;
extern void SSL_SESSION_free(SSL_SESSION *ses ) ;
extern int SSL_set_session(SSL *to , SSL_SESSION *session ) ;
extern int SSL_CTX_add_session(SSL_CTX *s , SSL_SESSION *c ) ;
X509 *SSL_get_peer_certificate(SSL *s ) ;
STACK *SSL_get_peer_cert_chain(SSL *s ) ;
int SSL_CTX_get_verify_mode(SSL_CTX *ctx ) ;
int SSL_CTX_get_verify_depth(SSL_CTX *ctx ) ;
int (*SSL_CTX_get_verify_callback(SSL_CTX *ctx ))(int , X509_STORE_CTX * ) ;
void SSL_CTX_set_verify(SSL_CTX *ctx , int mode , int (*cb)(int , X509_STORE_CTX * ) ) ;
void SSL_CTX_set_verify_depth(SSL_CTX *ctx , int depth ) ;
void SSL_CTX_set_cert_verify_callback(SSL_CTX *ctx , int (*cb)() , char *arg ) ;
void SSL_CTX_set_default_passwd_cb(SSL_CTX *ctx , pem_password_cb *cb ) ;
void SSL_CTX_set_default_passwd_cb_userdata(SSL_CTX *ctx , void *u ) ;
int SSL_CTX_check_private_key(SSL_CTX *ctx ) ;
int SSL_check_private_key(SSL *ssl ) ;
int SSL_CTX_set_session_id_context(SSL_CTX *ctx , unsigned char const *sid_ctx ,
                                   unsigned int sid_ctx_len ) ;
SSL *SSL_new(SSL_CTX *ctx ) ;
int SSL_set_session_id_context(SSL *ssl , unsigned char const *sid_ctx , unsigned int sid_ctx_len ) ;
int SSL_CTX_set_purpose(SSL_CTX *s , int purpose ) ;
int SSL_set_purpose(SSL *s , int purpose ) ;
int SSL_CTX_set_trust(SSL_CTX *s , int trust ) ;
int SSL_set_trust(SSL *s , int trust ) ;
void SSL_free(SSL *s ) ;
int SSL_accept(SSL *s ) ;
int SSL_connect(SSL *s ) ;
int SSL_read(SSL *s , void *buf , int num ) ;
int SSL_peek(SSL *s , void *buf , int num ) ;
int SSL_write(SSL *s , void const *buf , int num ) ;
long SSL_ctrl(SSL *s , int cmd , long larg , char *parg ) ;
long SSL_callback_ctrl(SSL *s , int cmd , void (*fp)() ) ;
long SSL_CTX_ctrl(SSL_CTX *ctx , int cmd , long larg , char *parg ) ;
long SSL_CTX_callback_ctrl(SSL_CTX *ctx , int cmd , void (*fp)() ) ;
int SSL_get_error(SSL *s , int i ) ;
char const *SSL_get_version(SSL *s ) ;
int SSL_CTX_set_ssl_version(SSL_CTX *ctx , SSL_METHOD *meth ) ;
STACK *SSL_get_ciphers(SSL *s ) ;
int SSL_do_handshake(SSL *s ) ;
int SSL_renegotiate(SSL *s ) ;
int SSL_shutdown(SSL *s ) ;
SSL_METHOD *SSL_get_ssl_method(SSL *s ) ;
int SSL_set_ssl_method(SSL *s , SSL_METHOD *meth ) ;
void SSL_set_connect_state(SSL *s ) ;
void SSL_set_accept_state(SSL *s ) ;
long SSL_get_default_timeout(SSL *s ) ;
SSL *SSL_dup(SSL *s ) ;
X509 *SSL_get_certificate(SSL *s ) ;
struct evp_pkey_st *SSL_get_privatekey(SSL *s ) ;
void SSL_CTX_set_quiet_shutdown(SSL_CTX *ctx , int mode ) ;
int SSL_CTX_get_quiet_shutdown(SSL_CTX *ctx ) ;
void SSL_set_quiet_shutdown(SSL *s , int mode ) ;
int SSL_get_quiet_shutdown(SSL *s ) ;
void SSL_set_shutdown(SSL *s , int mode ) ;
int SSL_get_shutdown(SSL *s ) ;
int SSL_version(SSL *s ) ;
int SSL_CTX_set_default_verify_paths(SSL_CTX *ctx ) ;
int SSL_CTX_load_verify_locations(SSL_CTX *ctx , char const *CAfile , char const *CApath ) ;
extern SSL_SESSION *SSL_get_session(SSL *ssl ) ;
SSL_CTX *SSL_get_SSL_CTX(SSL *ssl ) ;
void SSL_set_info_callback(SSL *ssl , void (*cb)() ) ;
void (*SSL_get_info_callback(SSL *ssl ))(void) ;
int SSL_state(SSL *ssl ) ;
void SSL_set_verify_result(SSL *ssl , long arg ) ;
long SSL_get_verify_result(SSL *ssl ) ;
int SSL_set_ex_data(SSL *s , int idx , void *arg ) ;
void *SSL_get_ex_data(SSL *s , int idx ) ;
int SSL_get_ex_new_index(long argl , void *argp , CRYPTO_EX_new *new_func , CRYPTO_EX_dup *dup_func ,
                         CRYPTO_EX_free *free_func ) ;
int SSL_CTX_set_ex_data(SSL_CTX *s , int idx , void *arg ) ;
void *SSL_CTX_get_ex_data(SSL_CTX *s , int idx ) ;
int SSL_CTX_get_ex_new_index(long argl , void *argp , CRYPTO_EX_new *new_func , CRYPTO_EX_dup *dup_func ,
                             CRYPTO_EX_free *free_func ) ;
extern int SSL_get_ex_data_X509_STORE_CTX_idx(void) ;
void SSL_CTX_set_tmp_rsa_callback(SSL_CTX *ctx , RSA *(*cb)(SSL *ssl , int is_export ,
                                                            int keylength ) ) ;
void SSL_set_tmp_rsa_callback(SSL *ssl , RSA *(*cb)(SSL *ssl , int is_export , int keylength ) ) ;
void SSL_CTX_set_tmp_dh_callback(SSL_CTX *ctx , DH *(*dh)(SSL *ssl , int is_export ,
                                                          int keylength ) ) ;
void SSL_set_tmp_dh_callback(SSL *ssl , DH *(*dh)(SSL *ssl , int is_export , int keylength ) ) ;
SSL3_ENC_METHOD ssl3_undef_enc_method ;
SSL_METHOD *ssl_bad_method(int ver ) ;
void ssl_clear_cipher_ctx(SSL *s ) ;
extern int ssl_clear_bad_session(SSL *s ) ;
extern CERT *ssl_cert_new(void) ;
extern CERT *ssl_cert_dup(CERT *cert ) ;
extern void ssl_cert_free(CERT *c ) ;
int ssl_cipher_id_cmp(SSL_CIPHER const *a , SSL_CIPHER const *b ) ;
int ssl_cipher_ptr_id_cmp(SSL_CIPHER const * const *ap , SSL_CIPHER const * const *bp ) ;
STACK *ssl_bytes_to_cipher_list(SSL *s , unsigned char *p , int num , STACK **skp ) ;
int ssl_cipher_list_to_bytes(SSL *s , STACK *sk , unsigned char *p ) ;
extern STACK *ssl_create_cipher_list(SSL_METHOD const *meth , STACK **pref , STACK **sorted ,
                                     char const *rule_str ) ;
void ssl_update_cache(SSL *s , int mode ) ;
int ssl_undefined_function(SSL *s ) ;
X509 *ssl_get_server_send_cert(SSL *s ) ;
EVP_PKEY *ssl_get_sign_pkey(SSL *s , SSL_CIPHER *cipher ) ;
void ssl_set_cert_masks(CERT *c , SSL_CIPHER *cipher ) ;
STACK *ssl_get_ciphers_by_id(SSL *s ) ;
int ssl_init_wbio_buffer(SSL *s , int push ) ;
void ssl_free_wbio_buffer(SSL *s ) ;
int ssl_ok(SSL *s ) ;
extern STACK *SSL_COMP_get_compression_methods(void) ;
char const *SSL_version_str = (char const *)"OpenSSL 0.9.6c 21 dec 2001";
static STACK *ssl_meth = (STACK *)((void *)0);
static STACK *ssl_ctx_meth = (STACK *)((void *)0);
static int ssl_meth_num = 0;
static int ssl_ctx_meth_num = 0;

/*
SSL3_ENC_METHOD ssl3_undef_enc_method = {(int (*)(SSL * , int ))(& ssl_undefined_function), (int (*)(SSL * , unsigned char * ,
                                                                 int ))(& ssl_undefined_function),
    & ssl_undefined_function, (int (*)(SSL * , unsigned char * , unsigned char * ,
                                       int ))(& ssl_undefined_function), (int (*)(SSL * ,
                                                                                   int ))(& ssl_undefined_function),
    (int (*)(SSL * , EVP_MD_CTX * , EVP_MD_CTX * , char const * , int , unsigned char * ))(& ssl_undefined_function),
    0, (int (*)(SSL * , EVP_MD_CTX * , unsigned char * ))0, (char const *)0, 0,
    (char const *)0, 0, (int (*)(int ))0};
*/

int SSL_clear(SSL *s )
{ int state ;
  int tmp ;
  int tmp___0 ;
  int tmp___1 ;
  {
  if ((unsigned long )s->method == (unsigned long )((void *)0)) {
    ERR_put_error(20, 164, 188, (char const *)"ssl_lib.c", 92);
    return (0);
  }
  s->error = 0;
  s->hit = 0;
  s->shutdown = 0;
  if (s->new_session) {
    ERR_put_error(20, 164, 157, (char const *)"ssl_lib.c", 108);
    return (0);
  }
  state = s->state;
  s->type = 0;
  if (s->server) { tmp = 8192;
  } else {
    tmp = 4096;
  }
  s->state = 16384 | tmp;
  s->version = (s->method)->version;
  s->client_version = s->version;
  s->rwstate = 1;
  s->rstate = 240;
  if ((unsigned long )s->init_buf != (unsigned long )((void *)0)) {
    BUF_MEM_free(s->init_buf);
    s->init_buf = (BUF_MEM *)((void *)0);
  }
  ssl_clear_cipher_ctx(s);
  tmp___0 = ssl_clear_bad_session(s); if (tmp___0) {
    SSL_SESSION_free(s->session);
    s->session = (SSL_SESSION *)((void *)0);
  }
  s->first_packet = 0;
  if (s->in_handshake) {
    ((*((s->method)->ssl_clear)))(s);
  } else {
    if ((unsigned long )s->session == (unsigned long )((void *)0)) { if ((unsigned long )s->method != (unsigned long )(s->ctx)->method) {
        ((*((s->method)->ssl_free)))(s);
        s->method = (s->ctx)->method;
        tmp___1 = ((*((s->method)->ssl_new)))(s); if (! tmp___1) { return (0);
        }
      } else {
        ((*((s->method)->ssl_clear)))(s);
      }
    } else {
      ((*((s->method)->ssl_clear)))(s);
    }
  } return (1);
}
}int SSL_CTX_set_ssl_version(SSL_CTX *ctx , SSL_METHOD *meth )
{ STACK *sk ;
  int tmp ;
  {
  ctx->method = meth;
  sk = ssl_create_cipher_list((SSL_METHOD const *)ctx->method, & ctx->cipher_list,
                              & ctx->cipher_list_by_id, (char const *)"ALL:!ADH:RC4+RSA:+SSLv2:@STRENGTH");
  if ((unsigned long )sk == (unsigned long )((void *)0)) {
    ERR_put_error(20, 170, 230, (char const *)"ssl_lib.c", 169);
    return (0);
  } else {
    tmp = sk_num((STACK const *)sk); if (tmp <= 0) {
      ERR_put_error(20, 170, 230, (char const *)"ssl_lib.c", 169);
      return (0);
    }
  } return (1);
}
}SSL *SSL_new(SSL_CTX *ctx )
{ SSL *s ;
  int tmp___0 ;
  {
  if ((unsigned long )ctx == (unsigned long )((void *)0)) {
    ERR_put_error(20, 186, 195, (char const *)"ssl_lib.c", 181);
    return ((SSL *)((void *)0));
  }
  if ((unsigned long )ctx->method == (unsigned long )((void *)0)) {
    ERR_put_error(20, 186, 228, (char const *)"ssl_lib.c", 186);
    return ((SSL *)((void *)0));
  }
  s = (SSL *)CRYPTO_malloc((int )sizeof(SSL ), (char const *)"ssl_lib.c", 190);
  if ((unsigned long )s == (unsigned long )((void *)0)) {
    goto err;
  }
  memset((void *)s, 0, sizeof(SSL ));
  if ((unsigned long )ctx->cert != (unsigned long )((void *)0)) {
    s->cert = ssl_cert_dup(ctx->cert);
    if ((unsigned long )s->cert == (unsigned long )((void *)0)) {
      goto err;
    }
  } else { s->cert = (struct cert_st *)((void *)0);
  }
  s->sid_ctx_length = ctx->sid_ctx_length;
  memcpy((void * )(& s->sid_ctx), (void const * )(& ctx->sid_ctx),
         sizeof(s->sid_ctx)); s->verify_mode = ctx->verify_mode;
  s->verify_depth = ctx->verify_depth;
  s->verify_callback = ctx->default_verify_callback;
  s->purpose = ctx->purpose;
  s->trust = ctx->trust;
  CRYPTO_add_lock(& ctx->references, 1, 12, (char const *)"ssl_lib.c", 219);
  s->ctx = ctx;
  s->verify_result = 0L;
  s->method = ctx->method;
  tmp___0 = ((*((s->method)->ssl_new)))(s); if (! tmp___0) {
    goto err;
  } s->quiet_shutdown = ctx->quiet_shutdown;
  s->references = 1;
  if ((unsigned long )(ctx->method)->ssl_accept == (unsigned long )(& ssl_undefined_function)) { s->server = 0;
  } else {
    s->server = 1;
  } s->options = ctx->options;
  s->mode = ctx->mode;
  s->read_ahead = ctx->read_ahead;
  SSL_clear(s);
  CRYPTO_new_ex_data(ssl_meth, (void *)s, & s->ex_data);
  return (s);
  err:
  if ((unsigned long )s != (unsigned long )((void *)0)) {
    if ((unsigned long )s->cert != (unsigned long )((void *)0)) { ssl_cert_free(s->cert);
    }
    if ((unsigned long )s->ctx != (unsigned long )((void *)0)) { SSL_CTX_free(s->ctx);
    }
    CRYPTO_free((void *)s);
  }
  ERR_put_error(20, 186, 33, (char const *)"ssl_lib.c", 249);
  return ((SSL *)((void *)0));
}
}int SSL_CTX_set_session_id_context(SSL_CTX *ctx , unsigned char const *sid_ctx ,
                                   unsigned int sid_ctx_len )
{
  {
  if (sid_ctx_len > 32U) {
    ERR_put_error(20, 219, 273, (char const *)"ssl_lib.c", 258);
    return (0);
  }
  ctx->sid_ctx_length = sid_ctx_len;
  memcpy((void * )(ctx->sid_ctx), (void const * )sid_ctx,
         sid_ctx_len); return (1);
}
}int SSL_set_session_id_context(SSL *ssl , unsigned char const *sid_ctx , unsigned int sid_ctx_len )
{
  { if (sid_ctx_len > 32U) {
    ERR_put_error(20, 218, 273, (char const *)"ssl_lib.c", 272);
    return (0);
  }
  ssl->sid_ctx_length = sid_ctx_len;
  memcpy((void * )(ssl->sid_ctx), (void const * )sid_ctx,
         sid_ctx_len); return (1);
}
}int SSL_CTX_set_purpose(SSL_CTX *s , int purpose )
{ int tmp ;
  {
  tmp = X509_PURPOSE_get_by_id(purpose); if (tmp == -1) {
    ERR_put_error(20, 226, 278, (char const *)"ssl_lib.c", 284);
    return (0);
  }
  s->purpose = purpose;
  return (1);
}
}int SSL_set_purpose(SSL *s , int purpose )
{ int tmp ;
  {
  tmp = X509_PURPOSE_get_by_id(purpose); if (tmp == -1) {
    ERR_put_error(20, 227, 278, (char const *)"ssl_lib.c", 294);
    return (0);
  }
  s->purpose = purpose;
  return (1);
}
}int SSL_CTX_set_trust(SSL_CTX *s , int trust )
{ int tmp ;
  {
  tmp = X509_TRUST_get_by_id(trust); if (tmp == -1) {
    ERR_put_error(20, 229, 279, (char const *)"ssl_lib.c", 304);
    return (0);
  }
  s->trust = trust;
  return (1);
}
}int SSL_set_trust(SSL *s , int trust )
{ int tmp ;
  {
  tmp = X509_TRUST_get_by_id(trust); if (tmp == -1) {
    ERR_put_error(20, 228, 279, (char const *)"ssl_lib.c", 314);
    return (0);
  }
  s->trust = trust;
  return (1);
}
}void SSL_free(SSL *s )
{ int i ;
  { if ((unsigned long )s == (unsigned long )((void *)0)) { return;
  }
  i = CRYPTO_add_lock(& s->references, -1, 16, (char const *)"ssl_lib.c", 328);
  if (i > 0) { return;
  } CRYPTO_free_ex_data(ssl_meth, (void *)((char *)s), & s->ex_data);
  if ((unsigned long )s->bbio != (unsigned long )((void *)0)) {
    if ((unsigned long )s->bbio == (unsigned long )s->wbio) {
      s->wbio = BIO_pop(s->wbio);
    }
    BIO_free(s->bbio);
    s->bbio = (BIO *)((void *)0);
  }
  if ((unsigned long )s->rbio != (unsigned long )((void *)0)) { BIO_free_all(s->rbio);
  }
  if ((unsigned long )s->wbio != (unsigned long )((void *)0)) { if ((unsigned long )s->wbio != (unsigned long )s->rbio) { BIO_free_all(s->wbio);
    }
  } if ((unsigned long )s->init_buf != (unsigned long )((void *)0)) { BUF_MEM_free(s->init_buf);
  } if ((unsigned long )s->cipher_list != (unsigned long )((void *)0)) { sk_free(s->cipher_list);
  } if ((unsigned long )s->cipher_list_by_id != (unsigned long )((void *)0)) { sk_free(s->cipher_list_by_id);
  } if ((unsigned long )s->session != (unsigned long )((void *)0)) {
    ssl_clear_bad_session(s);
    SSL_SESSION_free(s->session);
  }
  ssl_clear_cipher_ctx(s);
  if ((unsigned long )s->cert != (unsigned long )((void *)0)) { ssl_cert_free(s->cert);
  } if (s->ctx) { SSL_CTX_free(s->ctx);
  } if ((unsigned long )s->client_CA != (unsigned long )((void *)0)) { sk_pop_free(s->client_CA, (void (*)(void * ))(& X509_NAME_free));
  }
  if ((unsigned long )s->method != (unsigned long )((void *)0)) { ((*((s->method)->ssl_free)))(s);
  } CRYPTO_free((void *)s); return;
}
}void SSL_set_bio(SSL *s , BIO *rbio , BIO *wbio )
{
  {
  if ((unsigned long )s->bbio != (unsigned long )((void *)0)) {
    if ((unsigned long )s->wbio == (unsigned long )s->bbio) {
      s->wbio = (s->wbio)->next_bio;
      (s->bbio)->next_bio = (struct bio_st *)((void *)0);
    }
  }
  if ((unsigned long )s->rbio != (unsigned long )((void *)0)) { if ((unsigned long )s->rbio != (unsigned long )rbio) { BIO_free_all(s->rbio);
    }
  } if ((unsigned long )s->wbio != (unsigned long )((void *)0)) { if ((unsigned long )s->wbio != (unsigned long )wbio) { if ((unsigned long )s->rbio != (unsigned long )s->wbio) { BIO_free_all(s->wbio);
      }
    }
  }
  s->rbio = rbio;
  s->wbio = wbio; return;
}
}BIO *SSL_get_rbio(SSL *s )
{
  {
  return (s->rbio);
}
}
BIO *SSL_get_wbio(SSL *s )
{
  {
  return (s->wbio);
}
}
int SSL_get_fd(SSL *s )
{ int tmp ;
  {
  tmp = SSL_get_rfd(s); return (tmp);
}
}int SSL_get_rfd(SSL *s )
{ int ret ;
  BIO *b ;
  BIO *r ;
  {
  ret = -1;
  b = SSL_get_rbio(s);
  r = BIO_find_type(b, 256);
  if ((unsigned long )r != (unsigned long )((void *)0)) { BIO_ctrl(r, 105, 0L, (void *)((char *)(& ret)));
  }
  return (ret);
}
}int SSL_get_wfd(SSL *s )
{ int ret ;
  BIO *b ;
  BIO *r ;
  {
  ret = -1;
  b = SSL_get_wbio(s);
  r = BIO_find_type(b, 256);
  if ((unsigned long )r != (unsigned long )((void *)0)) { BIO_ctrl(r, 105, 0L, (void *)((char *)(& ret)));
  }
  return (ret);
}
}int SSL_set_fd(SSL *s , int fd )
{ int ret ;
  BIO *bio ;
  BIO_METHOD *tmp ;
  {
  ret = 0;
  bio = (BIO *)((void *)0);
  tmp = BIO_s_socket(); bio = BIO_new(tmp);
  if ((unsigned long )bio == (unsigned long )((void *)0)) {
    ERR_put_error(20, 192, 7, (char const *)"ssl_lib.c", 451);
    goto err;
  }
  BIO_int_ctrl(bio, 104, 0L, fd);
  SSL_set_bio(s, bio, bio);
  ret = 1;
  err:
  return (ret);
}
}int SSL_set_wfd(SSL *s , int fd )
{ int ret ;
  BIO *bio ;
  BIO_METHOD *tmp ;
  BIO *tmp___0 ;
  BIO *tmp___1 ;
  BIO *tmp___2 ;
  long tmp___3 ;
  {
  ret = 0;
  bio = (BIO *)((void *)0);
  if ((unsigned long )s->rbio == (unsigned long )((void *)0)) {
    goto _L;
  } else {
    if (((s->rbio)->method)->type != 1285) {
      goto _L;
    } else {
      tmp___3 = BIO_ctrl(s->rbio, 105, 0L, (void *)((char *)((void *)0))); if ((int )tmp___3 != fd) {
        _L:
        tmp = BIO_s_socket(); bio = BIO_new(tmp);
        if ((unsigned long )bio == (unsigned long )((void *)0)) {
          ERR_put_error(20, 196, 7, (char const *)"ssl_lib.c", 472);
          goto err;
        }
        BIO_int_ctrl(bio, 104, 0L, fd);
        tmp___0 = SSL_get_rbio(s); SSL_set_bio(s, tmp___0, bio);
      } else {
        tmp___1 = SSL_get_rbio(s); tmp___2 = SSL_get_rbio(s); SSL_set_bio(s, tmp___2, tmp___1);
      }
    }
  }
  ret = 1;
  err:
  return (ret);
}
}int SSL_set_rfd(SSL *s , int fd )
{ int ret ;
  BIO *bio ;
  BIO_METHOD *tmp ;
  BIO *tmp___0 ;
  BIO *tmp___1 ;
  BIO *tmp___2 ;
  long tmp___3 ;
  {
  ret = 0;
  bio = (BIO *)((void *)0);
  if ((unsigned long )s->wbio == (unsigned long )((void *)0)) {
    goto _L;
  } else {
    if (((s->wbio)->method)->type != 1285) {
      goto _L;
    } else {
      tmp___3 = BIO_ctrl(s->wbio, 105, 0L, (void *)((char *)((void *)0))); if ((int )tmp___3 != fd) {
        _L:
        tmp = BIO_s_socket(); bio = BIO_new(tmp);
        if ((unsigned long )bio == (unsigned long )((void *)0)) {
          ERR_put_error(20, 194, 7, (char const *)"ssl_lib.c", 495);
          goto err;
        }
        BIO_int_ctrl(bio, 104, 0L, fd);
        tmp___0 = SSL_get_wbio(s); SSL_set_bio(s, bio, tmp___0);
      } else {
        tmp___1 = SSL_get_wbio(s); tmp___2 = SSL_get_wbio(s); SSL_set_bio(s, tmp___2, tmp___1);
      }
    }
  }
  ret = 1;
  err:
  return (ret);
}
}size_t SSL_get_finished(SSL *s , void *buf , size_t count )
{ size_t ret ;
  {
  ret = (size_t )0;
  if ((unsigned long )s->s3 != (unsigned long )((void *)0)) {
    ret = (unsigned int )(s->s3)->tmp.finish_md_len;
    if (count > ret) { count = ret;
    }
    memcpy((void * )buf, (void const * )((s->s3)->tmp.finish_md),
           count);
  } return (ret);
}
}size_t SSL_get_peer_finished(SSL *s , void *buf , size_t count )
{ size_t ret ;
  {
  ret = (size_t )0;
  if ((unsigned long )s->s3 != (unsigned long )((void *)0)) {
    ret = (unsigned int )(s->s3)->tmp.peer_finish_md_len;
    if (count > ret) { count = ret;
    }
    memcpy((void * )buf, (void const * )((s->s3)->tmp.peer_finish_md),
           count);
  } return (ret);
}
}int SSL_get_verify_mode(SSL *s )
{
  {
  return (s->verify_mode);
}
}int SSL_get_verify_depth(SSL *s )
{
  {
  return (s->verify_depth);
}
}int (*SSL_get_verify_callback(SSL *s ))
/* (int , X509_STORE_CTX * ) */
{
  {
  return (s->verify_callback);
}
}int SSL_CTX_get_verify_mode(SSL_CTX *ctx )
{
  {
  return (ctx->verify_mode);
}
}int SSL_CTX_get_verify_depth(SSL_CTX *ctx )
{
  {
  return (ctx->verify_depth);
}
}int (*SSL_CTX_get_verify_callback(SSL_CTX *ctx ))
/* (int , X509_STORE_CTX * ) */
{
  {
  return (ctx->default_verify_callback);
}
}void SSL_set_verify(SSL *s , int mode , int (*callback)(int ok , X509_STORE_CTX *ctx ) )
{
  { s->verify_mode = mode;
  if ((unsigned long )callback != (unsigned long )((void *)0)) { s->verify_callback = callback;
  }
  return;
}
}
void SSL_set_verify_depth(SSL *s , int depth )
{
  {
  s->verify_depth = depth; return;
}
}void SSL_set_read_ahead(SSL *s , int yes )
{
  {
  s->read_ahead = yes; return;
}
}int SSL_get_read_ahead(SSL *s )
{
  {
  return (s->read_ahead);
}
}int SSL_pending(SSL *s )
{ int tmp ;
  {
  tmp = ((*((s->method)->ssl_pending)))(s); return (tmp);
}
}X509 *SSL_get_peer_certificate(SSL *s )
{ X509 *r ;
  { if ((unsigned long )s == (unsigned long )((void *)0)) { r = (X509 *)((void *)0);
  } else {
    if ((unsigned long )s->session == (unsigned long )((void *)0)) { r = (X509 *)((void *)0);
    } else {
      r = (s->session)->peer;
    }
  } if ((unsigned long )r == (unsigned long )((void *)0)) { return (r);
  } CRYPTO_add_lock(& r->references, 1, 3, (char const *)"ssl_lib.c", 610);
  return (r);
}
}STACK *SSL_get_peer_cert_chain(SSL *s )
{ STACK *r ;
  { if ((unsigned long )s == (unsigned long )((void *)0)) { r = (STACK *)((void *)0);
  } else {
    if ((unsigned long )s->session == (unsigned long )((void *)0)) { r = (STACK *)((void *)0);
    } else {
      if ((unsigned long )(s->session)->sess_cert == (unsigned long )((void *)0)) { r = (STACK *)((void *)0);
      } else {
        r = ((s->session)->sess_cert)->cert_chain;
      }
    }
  }
  return (r);
}
}void SSL_copy_session_id(SSL *t , SSL *f )
{ CERT *tmp ;
  SSL_SESSION *tmp___0 ;
  {
  tmp___0 = SSL_get_session(f); SSL_set_session(t, tmp___0);
  if ((unsigned long )t->method != (unsigned long )f->method) {
    ((*((t->method)->ssl_free)))(t);
    t->method = f->method;
    ((*((t->method)->ssl_new)))(t);
  }
  tmp = t->cert;
  if ((unsigned long )f->cert != (unsigned long )((void *)0)) {
    CRYPTO_add_lock(& (f->cert)->references, 1, 13, (char const *)"ssl_lib.c", 651);
    t->cert = f->cert;
  } else {
    t->cert = (struct cert_st *)((void *)0);
  }
  if ((unsigned long )tmp != (unsigned long )((void *)0)) { ssl_cert_free(tmp);
  } SSL_set_session_id_context(t, (unsigned char const *)(f->sid_ctx), f->sid_ctx_length); return;
}
}int SSL_CTX_check_private_key(SSL_CTX *ctx )
{ int tmp ;
  {
  if ((unsigned long )ctx == (unsigned long )((void *)0)) {
    ERR_put_error(20, 168, 177, (char const *)"ssl_lib.c", 667);
    return (0);
  } else {
    if ((unsigned long )ctx->cert == (unsigned long )((void *)0)) {
      ERR_put_error(20, 168, 177, (char const *)"ssl_lib.c", 667);
      return (0);
    } else {
      if ((unsigned long )((ctx->cert)->key)->x509 == (unsigned long )((void *)0)) {
        ERR_put_error(20, 168, 177, (char const *)"ssl_lib.c", 667);
        return (0);
      }
    }
  }
  if ((unsigned long )((ctx->cert)->key)->privatekey == (unsigned long )((void *)0)) {
    ERR_put_error(20, 168, 190, (char const *)"ssl_lib.c", 672);
    return (0);
  }
  tmp = X509_check_private_key(((ctx->cert)->key)->x509, ((ctx->cert)->key)->privatekey); return (tmp);
}
}int SSL_check_private_key(SSL *ssl )
{ int tmp ;
  {
  if ((unsigned long )ssl == (unsigned long )((void *)0)) {
    ERR_put_error(20, 163, 35, (char const *)"ssl_lib.c", 683);
    return (0);
  }
  if ((unsigned long )ssl->cert == (unsigned long )((void *)0)) {
    ERR_put_error(20, 163, 177, (char const *)"ssl_lib.c", 688);
    return (0);
  }
  if ((unsigned long )((ssl->cert)->key)->x509 == (unsigned long )((void *)0)) {
    ERR_put_error(20, 163, 177, (char const *)"ssl_lib.c", 693);
    return (0);
  }
  if ((unsigned long )((ssl->cert)->key)->privatekey == (unsigned long )((void *)0)) {
    ERR_put_error(20, 163, 190, (char const *)"ssl_lib.c", 698);
    return (0);
  }
  tmp = X509_check_private_key(((ssl->cert)->key)->x509, ((ssl->cert)->key)->privatekey); return (tmp);
}
}
int SSL_accept(SSL *s )
{ int tmp ;
  {
  if ((unsigned long )s->handshake_func == (unsigned long )((int (*)())0)) { SSL_set_accept_state(s);
  }
  tmp = ((*((s->method)->ssl_accept)))(s); return (tmp);
}
}int SSL_connect(SSL *s )
{ int tmp ;
  {
  if ((unsigned long )s->handshake_func == (unsigned long )((int (*)())0)) { SSL_set_connect_state(s);
  }
  tmp = ((*((s->method)->ssl_connect)))(s); return (tmp);
}
}long SSL_get_default_timeout(SSL *s )
{ long tmp ;
  {
  tmp = ((*((s->method)->get_timeout)))(); return (tmp);
}
}int SSL_read(SSL *s , void *buf , int num )
{ int tmp ;
  {
  if ((unsigned long )s->handshake_func == (unsigned long )((int (*)())0)) {
    ERR_put_error(20, 223, 276, (char const *)"ssl_lib.c", 732);
    return (-1);
  }
  if (s->shutdown & 2) {
    s->rwstate = 1;
    return (0);
  }
  tmp = ((*((s->method)->ssl_read)))(s, buf, num); return (tmp);
}
}int SSL_peek(SSL *s , void *buf , int num )
{ int tmp ;
  {
  if ((unsigned long )s->handshake_func == (unsigned long )((int (*)())0)) {
    ERR_put_error(20, 223, 276, (char const *)"ssl_lib.c", 748);
    return (-1);
  }
  if (s->shutdown & 2) {
    return (0);
  }
  tmp = ((*((s->method)->ssl_peek)))(s, buf, num); return (tmp);
}
}int SSL_write(SSL *s , void const *buf , int num )
{ int tmp ;
  {
  if ((unsigned long )s->handshake_func == (unsigned long )((int (*)())0)) {
    ERR_put_error(20, 208, 276, (char const *)"ssl_lib.c", 763);
    return (-1);
  }
  if (s->shutdown & 1) {
    s->rwstate = 1;
    ERR_put_error(20, 208, 207, (char const *)"ssl_lib.c", 770);
    return (-1);
  }
  tmp = ((*((s->method)->ssl_write)))(s, buf, num); return (tmp);
}
}int SSL_shutdown(SSL *s )
{ int tmp ;
  int tmp___0 ;
  {
  if ((unsigned long )s->handshake_func == (unsigned long )((int (*)())0)) {
    ERR_put_error(20, 224, 276, (char const *)"ssl_lib.c", 786);
    return (-1);
  }
  if ((unsigned long )s != (unsigned long )((void *)0)) { tmp___0 = SSL_state(s); if (tmp___0 & 12288) {
      return (1);
    } else {
      tmp = ((*((s->method)->ssl_shutdown)))(s); return (tmp);
    }
  } else { return (1);
  }
}
}int SSL_renegotiate(SSL *s )
{ int tmp ;
  {
  s->new_session = 1;
  tmp = ((*((s->method)->ssl_renegotiate)))(s); return (tmp);
}
}long SSL_ctrl(SSL *s , int cmd , long larg , char *parg )
{ long l ;
  long tmp ;
  {
  switch (cmd) {
  case 40: ;
  return ((long )s->read_ahead);
  case 41:
  l = (long )s->read_ahead;
  s->read_ahead = (int )larg;
  return (l);
  case 32:
  s->options |= (unsigned long )larg; return ((long )s->options);
  case 33:
  s->mode |= (unsigned long )larg; return ((long )s->mode);
  default:
  tmp = ((*((s->method)->ssl_ctrl)))(s, cmd, larg, parg); return (tmp);
  }
  return (0L);
}
}
long SSL_callback_ctrl(SSL *s , int cmd , void (*fp)() )
{ long tmp ;
  {
  switch (cmd) {
  default:
  tmp = ((*((s->method)->ssl_callback_ctrl)))(s, cmd, fp); return (tmp);
  }
  return (0L);
}
}
struct lhash_st *SSL_CTX_sessions(SSL_CTX *ctx )
{
  {
  return (ctx->sessions);
}
}long SSL_CTX_ctrl(SSL_CTX *ctx , int cmd , long larg , char *parg )
{ long l ;
  long tmp ;
  {
  switch (cmd) {
  case 40: ;
  return ((long )ctx->read_ahead);
  case 41:
  l = (long )ctx->read_ahead;
  ctx->read_ahead = (int )larg;
  return (l);
  case 42:
  l = (long )ctx->session_cache_size;
  ctx->session_cache_size = (unsigned long )larg;
  return (l);
  case 43: ;
  return ((long )ctx->session_cache_size);
  case 44:
  l = (long )ctx->session_cache_mode;
  ctx->session_cache_mode = (int )larg;
  return (l);
  case 45: ;
  return ((long )ctx->session_cache_mode);
  case 20: ;
  return ((long )(ctx->sessions)->num_items);
  case 21: ;
  return ((long )ctx->stats.sess_connect);
  case 22: ;
  return ((long )ctx->stats.sess_connect_good);
  case 23: ;
  return ((long )ctx->stats.sess_connect_renegotiate);
  case 24: ;
  return ((long )ctx->stats.sess_accept);
  case 25: ;
  return ((long )ctx->stats.sess_accept_good);
  case 26: ;
  return ((long )ctx->stats.sess_accept_renegotiate);
  case 27: ;
  return ((long )ctx->stats.sess_hit);
  case 28: ;
  return ((long )ctx->stats.sess_cb_hit);
  case 29: ;
  return ((long )ctx->stats.sess_miss);
  case 30: ;
  return ((long )ctx->stats.sess_timeout);
  case 31: ;
  return ((long )ctx->stats.sess_cache_full);
  case 32:
  ctx->options |= (unsigned long )larg; return ((long )ctx->options);
  case 33:
  ctx->mode |= (unsigned long )larg; return ((long )ctx->mode);
  default:
  tmp = ((*((ctx->method)->ssl_ctx_ctrl)))(ctx, cmd, larg, parg); return (tmp);
  }
  return (0L);
}
}
long SSL_CTX_callback_ctrl(SSL_CTX *ctx , int cmd , void (*fp)() )
{ long tmp ;
  {
  switch (cmd) {
  default:
  tmp = ((*((ctx->method)->ssl_ctx_callback_ctrl)))(ctx, cmd, fp); return (tmp);
  }
  return (0L);
}
}
int ssl_cipher_id_cmp(SSL_CIPHER const *a , SSL_CIPHER const *b )
{ long l ;
  int tmp ;
  {
  l = (long )(a->id - b->id);
  if (l == 0L) { return (0);
  } else {
    if (l > 0L) { tmp = 1;
    } else {
      tmp = -1;
    }
    return (tmp);
  }
}
}int ssl_cipher_ptr_id_cmp(SSL_CIPHER const * const *ap , SSL_CIPHER const * const *bp )
{ long l ;
  int tmp ;
  { l = (long )(((*ap))->id - ((*bp))->id);
  if (l == 0L) { return (0);
  } else {
    if (l > 0L) { tmp = 1;
    } else {
      tmp = -1;
    }
    return (tmp);
  }
}
}STACK *SSL_get_ciphers(SSL *s )
{
  {
  if ((unsigned long )s != (unsigned long )((void *)0)) { if ((unsigned long )s->cipher_list != (unsigned long )((void *)0)) {
      return (s->cipher_list);
    } else {
      goto _L;
    }
  } else {
    _L:
    if ((unsigned long )s->ctx != (unsigned long )((void *)0)) { if ((unsigned long )(s->ctx)->cipher_list != (unsigned long )((void *)0)) {
        return ((s->ctx)->cipher_list);
      }
    }
  }
  return ((STACK *)((void *)0));
}
}STACK *ssl_get_ciphers_by_id(SSL *s )
{
  {
  if ((unsigned long )s != (unsigned long )((void *)0)) { if ((unsigned long )s->cipher_list_by_id != (unsigned long )((void *)0)) {
      return (s->cipher_list_by_id);
    } else {
      goto _L;
    }
  } else {
    _L:
    if ((unsigned long )s != (unsigned long )((void *)0)) { if ((unsigned long )s->ctx != (unsigned long )((void *)0)) { if ((unsigned long )(s->ctx)->cipher_list_by_id != (unsigned long )((void *)0)) {
          return ((s->ctx)->cipher_list_by_id);
        }
      }
    }
  }
  return ((STACK *)((void *)0));
}
}char const *SSL_get_cipher_list(SSL *s , int n )
{ SSL_CIPHER *c ;
  STACK *sk ;
  int tmp ;
  {
  if ((unsigned long )s == (unsigned long )((void *)0)) { return ((char const *)((void *)0));
  } sk = SSL_get_ciphers(s);
  if ((unsigned long )sk == (unsigned long )((void *)0)) { return ((char const *)((void *)0));
  } else {
    tmp = sk_num((STACK const *)sk); if (tmp <= n) { return ((char const *)((void *)0));
    }
  } c = (SSL_CIPHER *)sk_value((STACK const *)sk, n);
  if ((unsigned long )c == (unsigned long )((void *)0)) { return ((char const *)((void *)0));
  } return (c->name);
}
}int SSL_CTX_set_cipher_list(SSL_CTX *ctx , char const *str )
{ STACK *sk ;
  int tmp ;
  {
  sk = ssl_create_cipher_list((SSL_METHOD const *)ctx->method, & ctx->cipher_list,
                              & ctx->cipher_list_by_id, str);
  if ((unsigned long )sk == (unsigned long )((void *)0)) { tmp = 0;
  } else {
    tmp = 1;
  }
  return (tmp);
}
}int SSL_set_cipher_list(SSL *s , char const *str )
{ STACK *sk ;
  int tmp ;
  {
  sk = ssl_create_cipher_list((SSL_METHOD const *)(s->ctx)->method, & s->cipher_list,
                              & s->cipher_list_by_id, str);
  if ((unsigned long )sk == (unsigned long )((void *)0)) { tmp = 0;
  } else {
    tmp = 1;
  }
  return (tmp);
}
}char *SSL_get_shared_ciphers(SSL *s , char *buf , int len )
{ char *p ;
  char const *cp ;
  STACK *sk ;
  SSL_CIPHER *c ;
  int i ;
  char *tmp___0 ;
  char const *tmp___1 ;
  int tmp___2 ;
  char *tmp___3 ;
  int tmp___4 ;
  {
  if ((unsigned long )s->session == (unsigned long )((void *)0)) {
    return ((char *)((void *)0));
  } else {
    if ((unsigned long )(s->session)->ciphers == (unsigned long )((void *)0)) {
      return ((char *)((void *)0));
    } else {
      if (len < 2) {
        return ((char *)((void *)0));
      }
    }
  }
  p = buf;
  sk = (s->session)->ciphers;
  i = 0; while (1) { tmp___4 = sk_num((STACK const *)sk); if (! (i < tmp___4)) { break;
    }
    len --;
    c = (SSL_CIPHER *)sk_value((STACK const *)sk, i);
    cp = c->name; while ((*cp)) {
      tmp___2 = len; len --; if (tmp___2 == 0) {
        (*p) = '\0';
        return (buf);
      } else {
        tmp___0 = p; p ++; tmp___1 = cp; cp ++; (*tmp___0) = (*tmp___1);
      }
    }
    tmp___3 = p; p ++; (*tmp___3) = ':';
    i ++;
  }
  (*(p + -1)) = '\0';
  return (buf);
}
}int ssl_cipher_list_to_bytes(SSL *s , STACK *sk , unsigned char *p )
{ int i ;
  int j ;
  SSL_CIPHER *c ;
  unsigned char *q ;
  int tmp___0 ;
  {
  j = 0;
  if ((unsigned long )sk == (unsigned long )((void *)0)) { return (0);
  } q = p;
  i = 0; while (1) { tmp___0 = sk_num((STACK const *)sk); if (! (i < tmp___0)) { break;
    }
    c = (SSL_CIPHER *)sk_value((STACK const *)sk, i);
    j = ((*((s->method)->put_cipher_by_char)))((SSL_CIPHER const *)c, p);
    p += j;
    i ++;
  }
  return (p - q);
}
}STACK *ssl_bytes_to_cipher_list(SSL *s , unsigned char *p , int num , STACK **skp )
{ SSL_CIPHER *c ;
  STACK *sk ;
  int i ;
  int n ;
  int tmp ;
  {
  n = ((*((s->method)->put_cipher_by_char)))((SSL_CIPHER const *)((void *)0), (unsigned char *)((void *)0));
  if (num % n != 0) {
    ERR_put_error(20, 161, 151, (char const *)"ssl_lib.c", 1061);
    return ((STACK *)((void *)0));
  }
  if ((unsigned long )skp == (unsigned long )((void *)0)) { sk = sk_new_null();
  } else {
    if ((unsigned long )(*skp) == (unsigned long )((void *)0)) { sk = sk_new_null();
    } else {
      sk = (*skp);
      sk_zero(sk);
    }
  } i = 0; while (i < num) {
    c = ((*((s->method)->get_cipher_by_char)))((unsigned char const *)p);
    p += n;
    if ((unsigned long )c != (unsigned long )((void *)0)) {
      tmp = sk_push(sk, (char *)c); if (! tmp) {
        ERR_put_error(20, 161, 33, (char const *)"ssl_lib.c", 1080);
        goto err;
      }
    }
    i += n;
  }
  if ((unsigned long )skp != (unsigned long )((void *)0)) { (*skp) = sk;
  }
  return (sk);
  err:
  if ((unsigned long )skp == (unsigned long )((void *)0)) { sk_free(sk);
  } else {
    if ((unsigned long )(*skp) == (unsigned long )((void *)0)) { sk_free(sk);
    }
  } return ((STACK *)((void *)0));
}
}unsigned long SSL_SESSION_hash(SSL_SESSION *a )
{ unsigned long l ;
  { l = (((unsigned long )((unsigned int )a->session_id[0]) | (unsigned long )((unsigned int )a->session_id[1] <<
                                                                             8L)) |
       ((unsigned long )a->session_id[2] << 16L)) | ((unsigned long )a->session_id[3] <<
                                                     24L);
  return (l);
}
}int SSL_SESSION_cmp(SSL_SESSION *a , SSL_SESSION *b )
{ int tmp ;
  {
  if (a->ssl_version != b->ssl_version) { return (1);
  }
  if (a->session_id_length != b->session_id_length) { return (1);
  }
  tmp = memcmp((void const *)(a->session_id), (void const *)(b->session_id), a->session_id_length); return (tmp);
}
}SSL_CTX *SSL_CTX_new(SSL_METHOD *meth )
{ SSL_CTX *ret ;
  int tmp ;
  int tmp___1 ;
  {
  ret = (SSL_CTX *)((void *)0);
  if ((unsigned long )meth == (unsigned long )((void *)0)) {
    ERR_put_error(20, 169, 196, (char const *)"ssl_lib.c", 1122);
    return ((SSL_CTX *)((void *)0));
  }
  tmp = SSL_get_ex_data_X509_STORE_CTX_idx(); if (tmp < 0) {
    ERR_put_error(20, 169, 269, (char const *)"ssl_lib.c", 1128);
    goto err;
  }
  ret = (SSL_CTX *)CRYPTO_malloc((int )sizeof(SSL_CTX ), (char const *)"ssl_lib.c",
                                 1131); if ((unsigned long )ret == (unsigned long )((void *)0)) {
    goto err;
  } memset((void *)ret, 0, sizeof(SSL_CTX ));
  ret->method = meth;
  ret->cert_store = (struct x509_store_st *)((void *)0);
  ret->session_cache_mode = 2;
  ret->session_cache_size = 20480UL;
  ret->session_cache_head = (struct ssl_session_st *)((void *)0);
  ret->session_cache_tail = (struct ssl_session_st *)((void *)0);
  ret->session_timeout = ((*(meth->get_timeout)))();
  ret->new_session_cb = (int (*)(struct ssl_st *ssl , SSL_SESSION *sess ))((void *)0);
  ret->remove_session_cb = (void (*)(struct ssl_ctx_st *ctx , SSL_SESSION *sess ))((void *)0);
  ret->get_session_cb = (SSL_SESSION *(*)(struct ssl_st *ssl , unsigned char *data ,
                                          int len , int *copy ))((void *)0); memset((void *)((char *)(& ret->stats)), 0, sizeof(ret->stats));
  ret->references = 1;
  ret->quiet_shutdown = 0;
  ret->info_callback = (void (*)())((void *)0);
  ret->app_verify_callback = (int (*)())((void *)0);
  ret->app_verify_arg = (char *)((void *)0);
  ret->read_ahead = 0;
  ret->verify_mode = 0;
  ret->verify_depth = -1;
  ret->default_verify_callback = (int (*)(int ok , X509_STORE_CTX *ctx ))((void *)0);
  ret->cert = ssl_cert_new(); if ((unsigned long )ret->cert == (unsigned long )((void *)0)) {
    goto err;
  } ret->default_passwd_callback = (pem_password_cb *)((void *)0);
  ret->default_passwd_callback_userdata = (void *)0;
  ret->client_cert_cb = (int (*)())((void *)0);
  ret->sessions = lh_new((unsigned long (*)())(& SSL_SESSION_hash), (int (*)())(& SSL_SESSION_cmp));
  if ((unsigned long )ret->sessions == (unsigned long )((void *)0)) {
    goto err;
  }
  ret->cert_store = X509_STORE_new();
  if ((unsigned long )ret->cert_store == (unsigned long )((void *)0)) {
    goto err;
  }
  ssl_create_cipher_list((SSL_METHOD const *)ret->method, & ret->cipher_list, & ret->cipher_list_by_id,
                         (char const *)"ALL:!ADH:RC4+RSA:+SSLv2:@STRENGTH");
  if ((unsigned long )ret->cipher_list == (unsigned long )((void *)0)) {
    ERR_put_error(20, 169, 161, (char const *)"ssl_lib.c", 1190);
    goto err2;
  } else {
    tmp___1 = sk_num((STACK const *)ret->cipher_list); if (tmp___1 <= 0) {
      ERR_put_error(20, 169, 161, (char const *)"ssl_lib.c", 1190);
      goto err2;
    }
  } ret->rsa_md5 = EVP_get_digestbyname((char const *)"ssl2-md5"); if ((unsigned long )ret->rsa_md5 == (unsigned long )((void *)0)) {
    ERR_put_error(20, 169, 241, (char const *)"ssl_lib.c", 1196);
    goto err2;
  }
  ret->md5 = EVP_get_digestbyname((char const *)"ssl3-md5"); if ((unsigned long )ret->md5 == (unsigned long )((void *)0)) {
    ERR_put_error(20, 169, 242, (char const *)"ssl_lib.c", 1201);
    goto err2;
  }
  ret->sha1 = EVP_get_digestbyname((char const *)"ssl3-sha1"); if ((unsigned long )ret->sha1 == (unsigned long )((void *)0)) {
    ERR_put_error(20, 169, 243, (char const *)"ssl_lib.c", 1206);
    goto err2;
  }
  ret->client_CA = sk_new_null(); if ((unsigned long )ret->client_CA == (unsigned long )((void *)0)) {
    goto err;
  } CRYPTO_new_ex_data(ssl_ctx_meth, (void *)((char *)ret), & ret->ex_data);
  ret->extra_certs = (STACK *)((void *)0);
  ret->comp_methods = SSL_COMP_get_compression_methods();
  return (ret);
  err:
  ERR_put_error(20, 169, 33, (char const *)"ssl_lib.c", 1220);
  err2:
  if ((unsigned long )ret != (unsigned long )((void *)0)) { SSL_CTX_free(ret);
  } return ((SSL_CTX *)((void *)0));
}
}static void SSL_COMP_free(SSL_COMP *comp )
{
  {
  CRYPTO_free((void *)comp); return;
}
}
void SSL_CTX_free(SSL_CTX *a )
{ int i ;
  { if ((unsigned long )a == (unsigned long )((void *)0)) { return;
  } i = CRYPTO_add_lock(& a->references, -1, 12, (char const *)"ssl_lib.c", 1235);
  if (i > 0) { return;
  } CRYPTO_free_ex_data(ssl_ctx_meth, (void *)((char *)a), & a->ex_data);
  if ((unsigned long )a->sessions != (unsigned long )((void *)0)) {
    SSL_CTX_flush_sessions(a, 0L);
    lh_free(a->sessions);
  }
  if ((unsigned long )a->cert_store != (unsigned long )((void *)0)) { X509_STORE_free(a->cert_store);
  }
  if ((unsigned long )a->cipher_list != (unsigned long )((void *)0)) { sk_free(a->cipher_list);
  }
  if ((unsigned long )a->cipher_list_by_id != (unsigned long )((void *)0)) { sk_free(a->cipher_list_by_id);
  }
  if ((unsigned long )a->cert != (unsigned long )((void *)0)) { ssl_cert_free(a->cert);
  }
  if ((unsigned long )a->client_CA != (unsigned long )((void *)0)) { sk_pop_free(a->client_CA, (void (*)(void * ))(& X509_NAME_free));
  }
  if ((unsigned long )a->extra_certs != (unsigned long )((void *)0)) { sk_pop_free(a->extra_certs, (void (*)(void * ))(& X509_free));
  }
  if ((unsigned long )a->comp_methods != (unsigned long )((void *)0)) { sk_pop_free(a->comp_methods, (void (*)(void * ))(& SSL_COMP_free));
  }
  CRYPTO_free((void *)a); return;
}
}void SSL_CTX_set_default_passwd_cb(SSL_CTX *ctx , pem_password_cb *cb )
{
  {
  ctx->default_passwd_callback = cb; return;
}
}void SSL_CTX_set_default_passwd_cb_userdata(SSL_CTX *ctx , void *u )
{
  {
  ctx->default_passwd_callback_userdata = u; return;
}
}void SSL_CTX_set_cert_verify_callback(SSL_CTX *ctx , int (*cb)() , char *arg )
{
  {
  ctx->app_verify_callback = cb;
  ctx->app_verify_arg = arg; return;
}
}void SSL_CTX_set_verify(SSL_CTX *ctx , int mode , int (*cb)(int , X509_STORE_CTX * ) )
{
  {
  ctx->verify_mode = mode;
  ctx->default_verify_callback = cb; return;
}
}void SSL_CTX_set_verify_depth(SSL_CTX *ctx , int depth )
{
  {
  ctx->verify_depth = depth; return;
}
}void ssl_set_cert_masks(CERT *c , SSL_CIPHER *cipher )
{ CERT_PKEY *cpk ;
  int rsa_enc ;
  int rsa_tmp ;
  int rsa_sign ;
  int dh_tmp ;
  int dh_rsa ;
  int dh_dsa ;
  int dsa_sign ;
  int rsa_enc_export ;
  int dh_rsa_export ;
  int dh_dsa_export ;
  int rsa_tmp_export ;
  int dh_tmp_export ;
  int kl ;
  unsigned long mask ;
  unsigned long emask ;
  int tmp ;
  int tmp___0 ;
  int tmp___1 ;
  int tmp___2 ;
  int tmp___3 ;
  int tmp___4 ;
  int tmp___5 ;
  int tmp___6 ;
  int tmp___7 ;
  int tmp___8 ;
  int tmp___9 ;
  int tmp___10 ;
  int tmp___11 ;
  int tmp___12 ;
  int tmp___13 ;
  int tmp___14 ;
  int tmp___15 ;
  {
  if ((unsigned long )c == (unsigned long )((void *)0)) { return;
  } if (cipher->algo_strength & 4UL) { kl = 512;
  } else {
    kl = 1024;
  } if ((unsigned long )c->rsa_tmp != (unsigned long )((void *)0)) { tmp = 1;
  } else {
    if ((unsigned long )c->rsa_tmp_cb != (unsigned long )((void *)0)) { tmp = 1;
    } else {
      tmp = 0;
    }
  }
  rsa_tmp = tmp;
  if ((unsigned long )c->rsa_tmp_cb != (unsigned long )((void *)0)) { tmp___1 = 1;
  } else {
    if (rsa_tmp) { tmp___0 = RSA_size(c->rsa_tmp); if (tmp___0 * 8 <= kl) { tmp___1 = 1;
      } else {
        tmp___1 = 0;
      }
    } else {
      tmp___1 = 0;
    }
  }
  rsa_tmp_export = tmp___1;
  if ((unsigned long )c->dh_tmp != (unsigned long )((void *)0)) { tmp___2 = 1;
  } else {
    if ((unsigned long )c->dh_tmp_cb != (unsigned long )((void *)0)) { tmp___2 = 1;
    } else {
      tmp___2 = 0;
    }
  }
  dh_tmp = tmp___2;
  if ((unsigned long )c->dh_tmp_cb != (unsigned long )((void *)0)) { tmp___4 = 1;
  } else {
    if (dh_tmp) { tmp___3 = DH_size(c->dh_tmp); if (tmp___3 * 8 <= kl) { tmp___4 = 1;
      } else {
        tmp___4 = 0;
      }
    } else {
      tmp___4 = 0;
    }
  }
  dh_tmp_export = tmp___4;
  cpk = & c->pkeys[0];
  if ((unsigned long )cpk->x509 != (unsigned long )((void *)0)) { if ((unsigned long )cpk->privatekey != (unsigned long )((void *)0)) { tmp___5 = 1;
    } else {
      tmp___5 = 0;
    }
  } else {
    tmp___5 = 0;
  }
  rsa_enc = tmp___5;
  if (rsa_enc) { tmp___6 = EVP_PKEY_size(cpk->privatekey); if (tmp___6 * 8 <= kl) { tmp___7 = 1;
    } else {
      tmp___7 = 0;
    }
  } else {
    tmp___7 = 0;
  }
  rsa_enc_export = tmp___7;
  cpk = & c->pkeys[1];
  if ((unsigned long )cpk->x509 != (unsigned long )((void *)0)) { if ((unsigned long )cpk->privatekey != (unsigned long )((void *)0)) { tmp___8 = 1;
    } else {
      tmp___8 = 0;
    }
  } else {
    tmp___8 = 0;
  }
  rsa_sign = tmp___8;
  cpk = & c->pkeys[2];
  if ((unsigned long )cpk->x509 != (unsigned long )((void *)0)) { if ((unsigned long )cpk->privatekey != (unsigned long )((void *)0)) { tmp___9 = 1;
    } else {
      tmp___9 = 0;
    }
  } else {
    tmp___9 = 0;
  }
  dsa_sign = tmp___9;
  cpk = & c->pkeys[3];
  if ((unsigned long )cpk->x509 != (unsigned long )((void *)0)) { if ((unsigned long )cpk->privatekey != (unsigned long )((void *)0)) { tmp___10 = 1;
    } else {
      tmp___10 = 0;
    }
  } else {
    tmp___10 = 0;
  }
  dh_rsa = tmp___10;
  if (dh_rsa) { tmp___11 = EVP_PKEY_size(cpk->privatekey); if (tmp___11 * 8 <= kl) { tmp___12 = 1;
    } else {
      tmp___12 = 0;
    }
  } else {
    tmp___12 = 0;
  }
  dh_rsa_export = tmp___12;
  cpk = & c->pkeys[4];
  if ((unsigned long )cpk->x509 != (unsigned long )((void *)0)) { if ((unsigned long )cpk->privatekey != (unsigned long )((void *)0)) { tmp___13 = 1;
    } else {
      tmp___13 = 0;
    }
  } else {
    tmp___13 = 0;
  }
  dh_dsa = tmp___13;
  if (dh_dsa) { tmp___14 = EVP_PKEY_size(cpk->privatekey); if (tmp___14 * 8 <= kl) { tmp___15 = 1;
    } else {
      tmp___15 = 0;
    }
  } else {
    tmp___15 = 0;
  }
  dh_dsa_export = tmp___15;
  mask = 0UL;
  emask = 0UL;
  if (rsa_enc) { mask |= 1UL;
  } else {
    if (rsa_tmp) { if (rsa_sign) { mask |= 1UL;
      }
    }
  }
  if (rsa_enc_export) { emask |= 1UL;
  } else {
    if (rsa_tmp_export) { if (rsa_sign) { emask |= 1UL;
      } else {
        if (rsa_enc) { emask |= 1UL;
        }
      }
    }
  }
  if (dh_tmp_export) { emask |= 16UL;
  }
  if (dh_tmp) { mask |= 16UL;
  }
  if (dh_rsa) { mask |= 2UL;
  } if (dh_rsa_export) { emask |= 2UL;
  } if (dh_dsa) { mask |= 4UL;
  } if (dh_dsa_export) { emask |= 4UL;
  } if (rsa_enc) {
    mask |= 32UL;
    emask |= 32UL;
  } else {
    if (rsa_sign) {
      mask |= 32UL;
      emask |= 32UL;
    }
  } if (dsa_sign) {
    mask |= 64UL;
    emask |= 64UL;
  }
  mask |= 256UL;
  emask |= 256UL;
  c->mask = mask;
  c->export_mask = emask;
  c->valid = 1; return;
}
}X509 *ssl_get_server_send_cert(SSL *s )
{ unsigned long alg ;
  unsigned long mask ;
  unsigned long kalg ;
  CERT *c ;
  int i ;
  int is_export ;
  {
  c = s->cert;
  ssl_set_cert_masks(c, (s->s3)->tmp.new_cipher);
  alg = ((s->s3)->tmp.new_cipher)->algorithms;
  is_export = (int )(((s->s3)->tmp.new_cipher)->algo_strength & 2UL);
  if (is_export) { mask = c->export_mask;
  } else {
    mask = c->mask;
  } kalg = alg & 1023UL;
  if (kalg & 2UL) { i = 3;
  } else {
    if (kalg & 4UL) { i = 4;
    } else {
      if (kalg & 64UL) { i = 2;
      } else {
        if (kalg & 32UL) {
          if ((unsigned long )c->pkeys[0].x509 == (unsigned long )((void *)0)) { i = 1;
          } else {
            i = 0;
          }
        } else {
          ERR_put_error(20, 182, 157, (char const *)"ssl_lib.c", 1430);
          return ((X509 *)((void *)0));
        }
      }
    }
  }
  if ((unsigned long )c->pkeys[i].x509 == (unsigned long )((void *)0)) { return ((X509 *)((void *)0));
  } return (c->pkeys[i].x509);
}
}EVP_PKEY *ssl_get_sign_pkey(SSL *s , SSL_CIPHER *cipher )
{ unsigned long alg ;
  CERT *c ;
  { alg = cipher->algorithms;
  c = s->cert;
  if (alg & 64UL) { if ((unsigned long )c->pkeys[2].privatekey != (unsigned long )((void *)0)) {
      return (c->pkeys[2].privatekey);
    } else {
      goto _L;
    }
  } else {
    _L:
    if (alg & 32UL) {
      if ((unsigned long )c->pkeys[1].privatekey != (unsigned long )((void *)0)) { return (c->pkeys[1].privatekey);
      } else {
        if ((unsigned long )c->pkeys[0].privatekey != (unsigned long )((void *)0)) { return (c->pkeys[0].privatekey);
        } else {
          return ((EVP_PKEY *)((void *)0));
        }
      }
    } else {
      ERR_put_error(20, 183, 157, (char const *)"ssl_lib.c", 1459);
      return ((EVP_PKEY *)((void *)0));
    }
  }
}
}
void ssl_update_cache(SSL *s , int mode )
{ int i ;
  int tmp ;
  int tmp___0 ;
  long tmp___1 ;
  int tmp___2 ;
  {
  if ((s->session)->session_id_length == 0U) { return;
  } if ((s->ctx)->session_cache_mode & mode) { if (! s->hit) { tmp___0 = SSL_CTX_add_session(s->ctx, s->session); if (tmp___0) { if ((unsigned long )(s->ctx)->new_session_cb != (unsigned long )((void *)0)) {
          CRYPTO_add_lock(& (s->session)->references, 1, 14, (char const *)"ssl_lib.c",
                          1477); tmp = ((*((s->ctx)->new_session_cb)))(s, s->session); if (! tmp) { SSL_SESSION_free(s->session);
          }
        }
      }
    }
  }
  i = (s->ctx)->session_cache_mode;
  if (! (i & 128)) { if ((i & mode) == mode) {
      if (mode & 1) { tmp___2 = (s->ctx)->stats.sess_connect_good;
      } else {
        tmp___2 = (s->ctx)->stats.sess_accept_good;
      }
      if ((tmp___2 & 255) == 255) {
        tmp___1 = time((time_t *)((void *)0)); SSL_CTX_flush_sessions(s->ctx, tmp___1);
      }
    }
  }
  return;
}
}
SSL_METHOD *SSL_get_ssl_method(SSL *s )
{
  {
  return (s->method);
}
}int SSL_set_ssl_method(SSL *s , SSL_METHOD *meth )
{ int conn ;
  int ret ;
  {
  conn = -1;
  ret = 1;
  if ((unsigned long )s->method != (unsigned long )meth) {
    if ((unsigned long )s->handshake_func != (unsigned long )((void *)0)) { conn = (unsigned long )s->handshake_func == (unsigned long )(s->method)->ssl_connect;
    }
    if ((s->method)->version == meth->version) { s->method = meth;
    } else {
      ((*((s->method)->ssl_free)))(s);
      s->method = meth;
      ret = ((*((s->method)->ssl_new)))(s);
    }
    if (conn == 1) { s->handshake_func = (int (*)())meth->ssl_connect;
    } else {
      if (conn == 0) { s->handshake_func = (int (*)())meth->ssl_accept;
      }
    }
  } return (ret);
}
}int SSL_get_error(SSL *s , int i )
{ int reason ;
  unsigned long l ;
  BIO *bio ;
  int tmp ;
  int tmp___0 ;
  int tmp___1 ;
  {
  if (i > 0) { return (0);
  } l = ERR_peek_error(); if (l != 0UL) {
    if ((int )((l >> 24L) & 255UL) == 2) { return (5);
    } else {
      return (1);
    }
  }
  if (i < 0) { tmp = SSL_want(s); if (tmp == 3) {
      bio = SSL_get_rbio(s);
      if (bio->flags & 1) { return (2);
      } else {
        if (bio->flags & 2) { return (3);
        } else {
          if (bio->flags & 4) {
            reason = BIO_get_retry_reason(bio);
            if (reason == 2) { return (7);
            } else {
              return (5);
            }
          }
        }
      }
    }
  }
  if (i < 0) { tmp___0 = SSL_want(s); if (tmp___0 == 2) {
      bio = SSL_get_wbio(s);
      if (bio->flags & 2) { return (3);
      } else {
        if (bio->flags & 1) { return (2);
        } else {
          if (bio->flags & 4) {
            reason = BIO_get_retry_reason(bio);
            if (reason == 2) { return (7);
            } else {
              return (5);
            }
          }
        }
      }
    }
  }
  if (i < 0) { tmp___1 = SSL_want(s); if (tmp___1 == 4) {
      return (4);
    }
  } if (i == 0) {
    if (s->version == 2) {
      return (6);
    } else {
      if (s->shutdown & 2) { if ((s->s3)->warn_alert == 0) {
          return (6);
        }
      }
    }
  } return (5);
}
}int SSL_do_handshake(SSL *s )
{ int ret ;
  int tmp ;
  int tmp___0 ;
  {
  ret = 1;
  if ((unsigned long )s->handshake_func == (unsigned long )((void *)0)) {
    ERR_put_error(20, 180, 144, (char const *)"ssl_lib.c", 1617);
    return (-1);
  }
  ((*((s->method)->ssl_renegotiate_check)))(s);
  tmp = SSL_state(s); if (tmp & 12288) {
    ret = ((*(s->handshake_func)))(s);
  } else {
    tmp___0 = SSL_state(s); if (tmp___0 & 16384) {
      ret = ((*(s->handshake_func)))(s);
    }
  } return (ret);
}
}void SSL_set_accept_state(SSL *s )
{
  {
  s->server = 1;
  s->shutdown = 0;
  s->state = 24576;
  s->handshake_func = (int (*)())(s->method)->ssl_accept;
  ssl_clear_cipher_ctx(s); return;
}
}void SSL_set_connect_state(SSL *s )
{
  {
  s->server = 0;
  s->shutdown = 0;
  s->state = 20480;
  s->handshake_func = (int (*)())(s->method)->ssl_connect;
  ssl_clear_cipher_ctx(s); return;
}
}int ssl_undefined_function(SSL *s )
{
  {
  ERR_put_error(20, 197, 34, (char const *)"ssl_lib.c", 1654);
  return (0);
}
}SSL_METHOD *ssl_bad_method(int ver )
{
  {
  ERR_put_error(20, 160, 34, (char const *)"ssl_lib.c", 1660);
  return ((SSL_METHOD *)((void *)0));
}
}char const *SSL_get_version(SSL *s )
{
  {
  if (s->version == 769) { return ((char const *)"TLSv1");
  } else {
    if (s->version == 768) { return ((char const *)"SSLv3");
    } else {
      if (s->version == 2) { return ((char const *)"SSLv2");
      } else {
        return ((char const *)"unknown");
      }
    }
  }
}
}
SSL *SSL_dup(SSL *s )
{ STACK *sk ;
  X509_NAME *xn ;
  SSL *ret ;
  int i ;
  SSL_CTX *tmp ;
  int tmp___0 ;
  int (*tmp___1)(int ok , X509_STORE_CTX *ctx ) ;
  int tmp___2 ;
  int tmp___3 ;
  void (*tmp___4)() ;
  int tmp___5 ;
  long tmp___6 ;
  long tmp___7 ;
  char *tmp___9 ;
  char *tmp___10 ;
  int tmp___11 ;
  {
  tmp = SSL_get_SSL_CTX(s); ret = SSL_new(tmp); if ((unsigned long )ret == (unsigned long )((void *)0)) { return ((SSL *)((void *)0));
  }
  if ((unsigned long )s->session != (unsigned long )((void *)0)) {
    SSL_copy_session_id(ret, s);
  } else {
    ret->method = s->method;
    ((*((ret->method)->ssl_new)))(ret);
    if ((unsigned long )s->cert != (unsigned long )((void *)0)) {
      if ((unsigned long )ret->cert != (unsigned long )((void *)0)) {
        ssl_cert_free(ret->cert);
      }
      ret->cert = ssl_cert_dup(s->cert);
      if ((unsigned long )ret->cert == (unsigned long )((void *)0)) {
        goto err;
      }
    } SSL_set_session_id_context(ret, (unsigned char const *)(s->sid_ctx), s->sid_ctx_length);
  }
  tmp___0 = SSL_get_read_ahead(s); SSL_set_read_ahead(ret, tmp___0);
  tmp___1 = SSL_get_verify_callback(s); tmp___2 = SSL_get_verify_mode(s); SSL_set_verify(ret, tmp___2, tmp___1);
  tmp___3 = SSL_get_verify_depth(s); SSL_set_verify_depth(ret, tmp___3);
  tmp___4 = SSL_get_info_callback(s); SSL_set_info_callback(ret, tmp___4);
  ret->debug = s->debug;
  ret->options = s->options;
  tmp___5 = CRYPTO_dup_ex_data(ssl_meth, & ret->ex_data, & s->ex_data); if (! tmp___5) {
    goto err;
  } if ((unsigned long )s->rbio != (unsigned long )((void *)0)) {
    tmp___6 = BIO_ctrl(s->rbio, 12, 0L, (void *)((char *)(& ret->rbio))); if (! tmp___6) {
      goto err;
    }
  } if ((unsigned long )s->wbio != (unsigned long )((void *)0)) {
    if ((unsigned long )s->wbio != (unsigned long )s->rbio) {
      tmp___7 = BIO_ctrl(s->wbio, 12, 0L, (void *)((char *)(& ret->wbio))); if (! tmp___7) {
        goto err;
      }
    } else { ret->wbio = ret->rbio;
    }
  }
  if ((unsigned long )s->cipher_list != (unsigned long )((void *)0)) {
    ret->cipher_list = sk_dup(s->cipher_list); if ((unsigned long )ret->cipher_list == (unsigned long )((void *)0)) {
      goto err;
    }
  } if ((unsigned long )s->cipher_list_by_id != (unsigned long )((void *)0)) { ret->cipher_list_by_id = sk_dup(s->cipher_list_by_id); if ((unsigned long )ret->cipher_list_by_id == (unsigned long )((void *)0)) {
      goto err;
    }
  }
  if ((unsigned long )s->client_CA != (unsigned long )((void *)0)) {
    sk = sk_dup(s->client_CA); if ((unsigned long )sk == (unsigned long )((void *)0)) {
      goto err;
    }
    ret->client_CA = sk;
    i = 0; while (1) { tmp___11 = sk_num((STACK const *)sk); if (! (i < tmp___11)) { break;
      }
      xn = (X509_NAME *)sk_value((STACK const *)sk, i);
      tmp___9 = (char *)X509_NAME_dup(xn); tmp___10 = sk_set(sk, i, tmp___9); if ((unsigned long )((X509_NAME *)tmp___10) == (unsigned long )((void *)0)) {
        X509_NAME_free(xn);
        goto err;
      }
      i ++;
    }
  }
  ret->shutdown = s->shutdown;
  ret->state = s->state;
  ret->handshake_func = s->handshake_func;
  ret->server = s->server;
  if (0) {
    err:
    if ((unsigned long )ret != (unsigned long )((void *)0)) { SSL_free(ret);
    } ret = (SSL *)((void *)0);
  }
  return (ret);
}
}void ssl_clear_cipher_ctx(SSL *s )
{
  {
  if ((unsigned long )s->enc_read_ctx != (unsigned long )((void *)0)) {
    EVP_CIPHER_CTX_cleanup(s->enc_read_ctx);
    CRYPTO_free((void *)s->enc_read_ctx);
    s->enc_read_ctx = (EVP_CIPHER_CTX *)((void *)0);
  }
  if ((unsigned long )s->enc_write_ctx != (unsigned long )((void *)0)) {
    EVP_CIPHER_CTX_cleanup(s->enc_write_ctx);
    CRYPTO_free((void *)s->enc_write_ctx);
    s->enc_write_ctx = (EVP_CIPHER_CTX *)((void *)0);
  }
  if ((unsigned long )s->expand != (unsigned long )((void *)0)) {
    COMP_CTX_free(s->expand);
    s->expand = (COMP_CTX *)((void *)0);
  }
  if ((unsigned long )s->compress != (unsigned long )((void *)0)) {
    COMP_CTX_free(s->compress);
    s->compress = (COMP_CTX *)((void *)0);
  }
  return;
}
}
X509 *SSL_get_certificate(SSL *s )
{
  {
  if ((unsigned long )s->cert != (unsigned long )((void *)0)) { return (((s->cert)->key)->x509);
  } else {
    return ((X509 *)((void *)0));
  }
}
}struct evp_pkey_st *SSL_get_privatekey(SSL *s )
{
  {
  if ((unsigned long )s->cert != (unsigned long )((void *)0)) { return (((s->cert)->key)->privatekey);
  } else {
    return ((struct evp_pkey_st *)((void *)0));
  }
}
}SSL_CIPHER *SSL_get_current_cipher(SSL *s )
{
  {
  if ((unsigned long )s->session != (unsigned long )((void *)0)) { if ((unsigned long )(s->session)->cipher != (unsigned long )((void *)0)) { return ((s->session)->cipher);
    }
  } return ((SSL_CIPHER *)((void *)0));
}
}int ssl_init_wbio_buffer(SSL *s , int push )
{ BIO *bbio ;
  BIO_METHOD *tmp ;
  long tmp___0 ;
  {
  if ((unsigned long )s->bbio == (unsigned long )((void *)0)) {
    tmp = BIO_f_buffer(); bbio = BIO_new(tmp);
    if ((unsigned long )bbio == (unsigned long )((void *)0)) { return (0);
    } s->bbio = bbio;
  } else {
    bbio = s->bbio;
    if ((unsigned long )s->bbio == (unsigned long )s->wbio) { s->wbio = BIO_pop(s->wbio);
    }
  }
  BIO_ctrl(bbio, 1, 0L, (void *)0);
  tmp___0 = BIO_int_ctrl(bbio, 117, 1L, 0); if (! tmp___0) {
    ERR_put_error(20, 184, 7, (char const *)"ssl_lib.c", 1859);
    return (0);
  }
  if (push) {
    if ((unsigned long )s->wbio != (unsigned long )bbio) { s->wbio = BIO_push(bbio, s->wbio);
    }
  } else {
    if ((unsigned long )s->wbio == (unsigned long )bbio) { s->wbio = BIO_pop(bbio);
    }
  }
  return (1);
}
}void ssl_free_wbio_buffer(SSL *s )
{
  {
  if ((unsigned long )s->bbio == (unsigned long )((void *)0)) { return;
  } if ((unsigned long )s->bbio == (unsigned long )s->wbio) {
    s->wbio = BIO_pop(s->wbio);
  }
  BIO_free(s->bbio);
  s->bbio = (BIO *)((void *)0); return;
}
}void SSL_CTX_set_quiet_shutdown(SSL_CTX *ctx , int mode )
{
  {
  ctx->quiet_shutdown = mode; return;
}
}int SSL_CTX_get_quiet_shutdown(SSL_CTX *ctx )
{
  {
  return (ctx->quiet_shutdown);
}
}void SSL_set_quiet_shutdown(SSL *s , int mode )
{
  {
  s->quiet_shutdown = mode; return;
}
}int SSL_get_quiet_shutdown(SSL *s )
{
  {
  return (s->quiet_shutdown);
}
}void SSL_set_shutdown(SSL *s , int mode )
{
  {
  s->shutdown = mode; return;
}
}int SSL_get_shutdown(SSL *s )
{
  {
  return (s->shutdown);
}
}int SSL_version(SSL *s )
{
  {
  return (s->version);
}
}SSL_CTX *SSL_get_SSL_CTX(SSL *ssl )
{
  {
  return (ssl->ctx);
}
}int SSL_CTX_set_default_verify_paths(SSL_CTX *ctx )
{ int tmp ;
  {
  tmp = X509_STORE_set_default_paths(ctx->cert_store); return (tmp);
}
}int SSL_CTX_load_verify_locations(SSL_CTX *ctx , char const *CAfile , char const *CApath )
{ int tmp ;
  { tmp = X509_STORE_load_locations(ctx->cert_store, CAfile, CApath); return (tmp);
}
}void SSL_set_info_callback(SSL *ssl , void (*cb)() )
{
  {
  ssl->info_callback = cb; return;
}
}void (*SSL_get_info_callback(SSL *ssl ))
/* (void) */
{
  {
  return (ssl->info_callback);
}
}int SSL_state(SSL *ssl )
{
  {
  return (ssl->state);
}
}void SSL_set_verify_result(SSL *ssl , long arg )
{
  {
  ssl->verify_result = arg; return;
}
}long SSL_get_verify_result(SSL *ssl )
{
  {
  return (ssl->verify_result);
}
}int SSL_get_ex_new_index(long argl , void *argp , CRYPTO_EX_new *new_func , CRYPTO_EX_dup *dup_func ,
                         CRYPTO_EX_free *free_func )
{ int tmp ;
  {
  ssl_meth_num ++;
  tmp = CRYPTO_get_ex_new_index(ssl_meth_num - 1, & ssl_meth, argl, argp, new_func,
                                dup_func, free_func);
  return (tmp);
}
}
int SSL_set_ex_data(SSL *s , int idx , void *arg )
{ int tmp ;
  {
  tmp = CRYPTO_set_ex_data(& s->ex_data, idx, arg); return (tmp);
}
}void *SSL_get_ex_data(SSL *s , int idx )
{ void *tmp ;
  {
  tmp = CRYPTO_get_ex_data(& s->ex_data, idx); return (tmp);
}
}int SSL_CTX_get_ex_new_index(long argl , void *argp , CRYPTO_EX_new *new_func , CRYPTO_EX_dup *dup_func ,
                             CRYPTO_EX_free *free_func )
{ int tmp ;
  {
  ssl_ctx_meth_num ++;
  tmp = CRYPTO_get_ex_new_index(ssl_ctx_meth_num - 1, & ssl_ctx_meth, argl, argp,
                                new_func, dup_func, free_func);
  return (tmp);
}
}
int SSL_CTX_set_ex_data(SSL_CTX *s , int idx , void *arg )
{ int tmp ;
  {
  tmp = CRYPTO_set_ex_data(& s->ex_data, idx, arg); return (tmp);
}
}void *SSL_CTX_get_ex_data(SSL_CTX *s , int idx )
{ void *tmp ;
  {
  tmp = CRYPTO_get_ex_data(& s->ex_data, idx); return (tmp);
}
}int ssl_ok(SSL *s )
{
  {
  return (1);
}
}X509_STORE *SSL_CTX_get_cert_store(SSL_CTX *ctx )
{
  {
  return (ctx->cert_store);
}
}void SSL_CTX_set_cert_store(SSL_CTX *ctx , X509_STORE *store )
{
  {
  if ((unsigned long )ctx->cert_store != (unsigned long )((void *)0)) { X509_STORE_free(ctx->cert_store);
  }
  ctx->cert_store = store; return;
}
}int SSL_want(SSL *s )
{
  {
  return (s->rwstate);
}
}void SSL_CTX_set_tmp_rsa_callback(SSL_CTX *ctx , RSA *(*cb)(SSL *ssl , int is_export ,
                                                            int keylength ) )
{
  { SSL_CTX_callback_ctrl(ctx, 4, (void (*)())cb); return;
}
}void SSL_set_tmp_rsa_callback(SSL *ssl , RSA *(*cb)(SSL *ssl , int is_export , int keylength ) )
{
  {
  SSL_callback_ctrl(ssl, 4, (void (*)())cb); return;
}
}void SSL_CTX_set_tmp_dh_callback(SSL_CTX *ctx , DH *(*dh)(SSL *ssl , int is_export ,
                                                          int keylength ) )
{
  {
  SSL_CTX_callback_ctrl(ctx, 5, (void (*)())dh); return;
}
}void SSL_set_tmp_dh_callback(SSL *ssl , DH *(*dh)(SSL *ssl , int is_export , int keylength ) )
{
  { SSL_callback_ctrl(ssl, 5, (void (*)())dh); return;
}
}
