//*******************************************************************//
//SSL_library_init
//*******************************************************************//

cproc SSL_library_init {
    action call EVP_des_cbc with (1) = EpsilonSpec;
    action call EVP_des_ede3_cbc with (1) = EpsilonSpec;
    action call EVP_idea_cbc with (1) = EpsilonSpec;
    action call EVP_rc4 with (1) = EpsilonSpec;
    action call EVP_rc2_cbc with (1) = EpsilonSpec;
    action call EVP_add_cipher with (1) = EpsilonSpec;
    
    action call EVP_md2 with (1) = EpsilonSpec;
    action call EVP_md5 with (1) = EpsilonSpec;
    action call EVP_sha1 with (1) = EpsilonSpec;
    action call EVP_dss1 with (1) = EpsilonSpec;
    action call EVP_add_digest with (1) = EpsilonSpec;

    action call OBJ_NAME_add with (1) = EpsilonSpec;
}

SSL_Library_Init = ( return {$0 == 1} -> STOP ).

property ssl_library_init = SSL_Library_Init simulates SSL_library_init with (1);

//*******************************************************************//
//SSL_CTX_new
//*******************************************************************//

cproc SSL_CTX_new {
    action call ERR_put_error with (1) = EpsilonSpec;
    action call memset with (1) = EpsilonSpec;
    action call meth->get_timeout with (meth != 0) = EpsilonSpec;
    action call CRYPTO_new_ex_data with (1) = EpsilonSpec;
    action call SSL_COMP_get_compression_methods with (1) = EpsilonSpec;

    action call ssl_cert_new with (1) = SslCertNew;
    action call SSL_get_ex_data_X509_STORE_CTX_idx with (ret == 0) = SslGetExData;
    action call CRYPTO_malloc with (1) = CryptoMalloc;
    action call lh_new with (1) = LhNew;
    action call X509_STORE_new with (1) = X509_STORE_new;
    action call ssl_create_cipher_list with (1) = SslCreateCipherList;
    action call sk_num with ($1 != 0) = SkNum;
    action call EVP_get_digestbyname with (1) = EvpGetDigestByName;
    action call sk_new_null with (1) = SkNewNull;
    action call SSL_CTX_free with ($1 != 0) = SslCtxFree;
}

SslGetExData = ( error -> return {$0 < 0} -> STOP | return {$0 >= 0} -> STOP ).

SslCtxFree = ( dealloc -> STOP ).

SkNewNull = ( return {$0 != 0} -> STOP | error -> return {$0 == 0} -> STOP ).

EvpGetDigestByName = ( return {$0 != 0} -> STOP | error -> return {$0 == 0} -> STOP ).

SkNum = ( return {$0 > 0} -> STOP | error -> return {$0 <= 0} -> STOP ).

SslCreateCipherList = ( return {*$2 != 0} -> STOP | error -> return {*$2 == 0} -> STOP ).

LhNew = ( error -> return {$0 == 0} -> STOP | return {$0 != 0} -> STOP ).

X509_STORE_new = ( error -> return {$0 == 0} -> STOP | return {$0 != 0} -> STOP ).

CryptoMalloc = ( error -> return {$0 == 0} -> STOP | alloc -> return {$0 != 0} -> STOP ).

SslCertNew = ( error -> return {$0 == 0} -> STOP | return {$0 != 0} -> STOP ).

SSL_CTX_New = ( error -> return {$0 == 0} -> STOP | return {$0 == 0} -> STOP | alloc -> S1),
S1 = ( error -> dealloc -> return {$0 == 0} -> STOP | return {$0 != 0} -> STOP ).

property ssl_ctx_new = SSL_CTX_New simulates SSL_CTX_new with (1);

//*******************************************************************//
//SSL_new
//*******************************************************************//

cproc SSL_new {
    action call ERR_put_error with (1) = EpsilonSpec;
    action call memset with ($1 != 0) = EpsilonSpec;
    action call memcpy with (1) = EpsilonSpec;
    action call CRYPTO_add_lock with (1) = EpsilonSpec;
    action call SSL_clear with ($1 != 0) = EpsilonSpec;
    action call CRYPTO_new_ex_data with (1) = EpsilonSpec;
    action call SSL_CTX_free with (1) = EpsilonSpec;

    action call CRYPTO_malloc with (1) = CryptoMalloc;
    action call ssl_cert_dup with ($1 != 0) = SslCertDup;
    action call ssl_cert_free with ($1 != 0) = SslCertFree;
    action call s->method->ssl_new with ($1 != 0) = SMethodSslNew;
    action call CRYPTO_free with ($1 != 0) = CryptoFree;
}

CryptoFree = ( dealloc -> STOP ).

SMethodSslNew = ( error -> return {$0 == 0} -> STOP | return {$0 != 0} -> STOP ).

SslCertFree = ( dealloc_cert -> STOP ).

SslCertDup = ( error -> return {$0 == 0} -> STOP | alloc_cert -> return {$0 != 0} -> STOP ).

SslNew = ( error -> return {$0 == 0} -> STOP | return {$0 == 0} -> STOP | alloc -> S1 ),
S1 = ( error -> dealloc -> return {$0 == 0} -> STOP | alloc_cert -> S2 | epsilon -> S3 ),
S2 = ( error -> dealloc_cert -> dealloc -> return {$0 == 0} -> STOP | return {$0 != 0} -> STOP ),
S3 = ( error -> dealloc -> return {$0 == 0} -> STOP | return {$0 != 0} -> STOP ).

property ssl_new = SslNew simulates SSL_new with (1);

//*******************************************************************//
//THE END
//*******************************************************************//

