//*******************************************************************//
//ssl3_accept
//*******************************************************************//

cprog ssl3_accept = ssl3_accept {
    abstract ssl3_accept_1,{$1->state == (0x110|0x2000)},Ssl3Accept;
    abstract ssl3_accept_2,{$1->state == (0x120|0x2000)},Ssl3Accept;
    abstract ssl3_accept_3,{$1->state == (0x130|0x2000)},Ssl3Accept;
    abstract ssl3_accept_4,{$1->state == (0x170|0x2000)},Ssl3Accept;
}

cproc ssl3_send_hello_request {
    abstract {ssl3_send_hello_request_abs,1,SendHelloRequest};
}

cproc ssl3_get_client_hello {
    abstract {ssl3_get_client_hello_abs,1,GetClientHello};
}

cproc ssl3_send_server_hello {
    abstract {ssl3_send_server_hello_abs,1,SendServerHello};
}

cproc ssl3_send_server_certificate {
    abstract {ssl3_send_server_certificate_abs,1,SendServerCertificate};
}

cproc ssl3_send_server_key_exchange {
    abstract {ssl3_send_server_key_exchange_abs,1,SendServerKeyExchange};
}

cproc ssl3_send_certificate_request {
    abstract {ssl3_send_certificate_request_abs,1,SendCertificateRequest};
}

cproc ssl3_send_server_done {
    abstract {ssl3_send_server_done_abs,1,SendServerDone};
}

cproc ssl3_check_client_hello {
    abstract {ssl3_check_client_hello_abs,1,CheckClientHello};
}

cproc ssl3_get_client_certificate {
    abstract {ssl3_get_client_certificate_abs,1,GetClientCertificate};
}

cproc ssl3_get_client_key_exchange {
    abstract {ssl3_get_client_key_exchange_abs,1,GetClientKeyExchange};
}

cproc ssl3_get_cert_verify {
    abstract {ssl3_get_cert_verify_abs,1,GetCertVerify};
}

cproc ssl3_get_finished {
    abstract {ssl3_get_finished_abs,1,GetFinished};
}

cproc ssl3_send_change_cipher_spec {
    abstract {ssl3_send_change_cipher_spec_abs,1,SendChangeCipherSpec};
}

cproc ssl3_send_finished {
    abstract {ssl3_send_finished_abs,1,SendFinished};
}

cproc ssl3_accept {
    predicate (ret == 1),(ret <= 0);
    auxiliary (((s->s3)->tmp.new_cipher)->algorithms & 256);
    //predicate (state == s->state);
    //predicate (num1 <= 0),(num1 > 0);

    //case SSL_ST_RENEGOTIATE: 12292
    //predicate (s->state == (0x04|(0x1000|0x2000)));
    //case SSL_ST_BEFORE: 16384
    //predicate (s->state == 0x4000);
    //case SSL_ST_ACCEPT: 8192
    //predicate (s->state == 0x2000);
    //case SSL_ST_BEFORE|SSL_ST_ACCEPT: 24576
    //predicate (s->state == (0x4000|0x2000));
    //case SSL_ST_OK|SSL_ST_ACCEPT: 8195
    //predicate (s->state == (0x03|0x2000));
    //case SSL3_ST_SW_HELLO_REQ_A: 8480
    predicate (s->state == 8480);
    //case SSL3_ST_SW_HELLO_REQ_B: 8481
    //predicate (s->state == (0x121|0x2000));
    //case SSL3_ST_SW_HELLO_REQ_C: 8482
    predicate (s->state == 8482);
    //case SSL3_ST_SR_CLNT_HELLO_A: 8464
    predicate (s->state == 8464);
    //case SSL3_ST_SR_CLNT_HELLO_B: 8465
    //predicate (s->state == (0x111|0x2000));
    //case SSL3_ST_SR_CLNT_HELLO_C: 8466
    predicate (s->state == 8466);
    //case SSL3_ST_SW_SRVR_HELLO_A: 8496
    predicate (s->state == 8496);
    //case SSL3_ST_SW_SRVR_HELLO_B: 8497
    //predicate (s->state == (0x131|0x2000));
    //case SSL3_ST_SW_CERT_A: 8512
    predicate (s->state == 8512);
    //case SSL3_ST_SW_CERT_B: 8513
    //predicate (s->state == (0x141|0x2000));
    //case SSL3_ST_SW_KEY_EXCH_A: 8528
    predicate (s->state == 8528);
    //case SSL3_ST_SW_KEY_EXCH_B: 8529
    //predicate (s->state == (0x151|0x2000));
    //case SSL3_ST_SW_CERT_REQ_A: 8544
    predicate (s->state == 8544);
    //case SSL3_ST_SW_CERT_REQ_B: 8545
    //predicate (s->state == (0x161|0x2000));
    //case SSL3_ST_SW_SRVR_DONE_A: 8560
    predicate (s->state == 8560);
    //case SSL3_ST_SW_SRVR_DONE_B: 8561		
    //predicate (s->state == (0x171|0x2000));
    //case SSL3_ST_SW_FLUSH: 8448
    predicate (s->state == 8448);
    //case SSL3_ST_SR_CERT_A: 8576
    predicate (s->state == 8576);
    //case SSL3_ST_SR_CERT_B: 8577
    //predicate (s->state == (0x181|0x2000));
    //case SSL3_ST_SR_KEY_EXCH_A: 8592
    predicate (s->state == 8592);
    //case SSL3_ST_SR_KEY_EXCH_B: 8593
    //predicate (s->state == (0x191|0x2000));
    //case SSL3_ST_SR_CERT_VRFY_A: 8608
    predicate (s->state == 8608);
    //case SSL3_ST_SR_CERT_VRFY_B: 8609
    //predicate (s->state == (0x1A1|0x2000));
    //case SSL3_ST_SR_FINISHED_A: 8640
    predicate (s->state == 8640);
    //case SSL3_ST_SR_FINISHED_B: 8641
    //predicate (s->state == (0x1C1|0x2000));
    //case SSL3_ST_SW_CHANGE_A: 8656
    predicate (s->state == 8656);
    //case SSL3_ST_SW_CHANGE_B: 8657
    //predicate (s->state == (0x1D1|0x2000));
    //case SSL3_ST_SW_FINISHED_A: 8672
    predicate (s->state == 8672);
    //case SSL3_ST_SW_FINISHED_B: 8673
    //predicate (s->state == (0x1E1|0x2000));
    //case SSL_ST_OK: 3
    predicate (s->state == 3);

    abstract {ssl3_accept_1,($1->state == (0x110|0x2000)),Ssl3Accept};
    abstract {ssl3_accept_2,($1->state == (0x120|0x2000)),Ssl3Accept};
    abstract {ssl3_accept_3,($1->state == (0x130|0x2000)),Ssl3Accept};
    abstract {ssl3_accept_4,($1->state == (0x170|0x2000)),Ssl3Accept};
}

SendHelloRequest = ( send_hello_request -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP ).
GetClientHello = ( get_client_hello -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP ).
SendServerHello = ( send_server_hello -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP ).
SendServerCertificate = ( send_server_certificate -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP ).
SendChangeCipherSpec = ( send_change_cipher_spec -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP ).
GetClientKeyExchange = ( get_client_key_exchange -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP ).
SendServerKeyExchange = ( send_server_key_exchange -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP ).
SendFinished = ( send_finished -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP ).
SendCertificateRequest = ( send_certificate_request -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP ).
CheckClientHello = ( check_client_hello -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP ).
GetClientCertificate = ( get_client_certificate -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP ).
GetFinished = ( get_finished -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP ).
GetCertVerify = ( get_cert_verify -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP ).
SendServerDone = ( send_server_done -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP ).

Ssl3Accept = ( epsilon -> SrClntHelloA | epsilon -> SwHelloReqA ),

SrClntHelloA = ( get_client_hello -> SwSrvrHelloA | return {$0 == -1} -> STOP ),

SwHelloReqA = ( send_hello_request -> SwFlushSwHelloReqC | return {$0 == -1} -> STOP ),

SwFlushSwHelloReqC = ( epsilon -> SwHelloReqC | return {$0 == -1} -> STOP ),

SwHelloReqC = ( epsilon -> Ok | return {$0 == -1} -> STOP ),

Ok = ( return {$0 == 1} -> STOP ),

SwSrvrHelloA = ( send_server_hello -> SwSrvrHelloA1 | return {$0 == -1} -> STOP ),
SwSrvrHelloA1 = ( epsilon -> SwChangeA | epsilon -> SwCertA | return {$0 == -1} -> STOP ),

SwChangeA = ( send_change_cipher_spec -> SwChangeA1 | return {$0 == -1} -> STOP ),
SwChangeA1 = ( epsilon -> SwFinishedA | return {$0 == -1} -> STOP ),

SwCertA = ( send_server_certificate -> SwCertA1 | epsilon -> SwCertA1 | return {$0 == -1} -> STOP ),
SwCertA1 = ( epsilon -> SwKeyExchA | return {$0 == -1} -> STOP ),

SwKeyExchA = ( send_server_key_exchange -> SwKeyExchA1 | epsilon -> SwKeyExchA1 | return {$0 == -1} -> STOP ),
SwKeyExchA1 = ( epsilon -> SwCertReqA | return {$0 == -1} -> STOP ),

SwFinishedA = ( send_finished -> SwFinishedA1 | return {$0 == -1} -> STOP ),
SwFinishedA1 = ( epsilon -> SwFlushSrFinishedA | epsilon -> SwFlushOk | return {$0 == -1} -> STOP ),

SwFlushSrFinishedA = ( epsilon -> SrFinishedA | return {$0 == -1} -> STOP ),

SwFlushOk = ( epsilon -> Ok | return {$0 == -1} -> STOP ),

SwCertReqA = ( epsilon -> SwSrvrDoneA | send_certificate_request -> SwFlushSrCertA | return {$0 == -1} -> STOP ),

SwFlushSrCertA = ( epsilon -> SrCertA | return {$0 == -1} -> STOP ),

SrCertA = ( check_client_hello -> SrCertA1 | return {$0 == -1} -> STOP ),
SrCertA1 = ( epsilon -> SrClntHelloC | get_client_certificate -> SrKeyExchA | get_client_certificate -> return {$0 == -1} -> STOP | return {$0 == -1} -> STOP ),

SrFinishedA = ( get_finished -> SrFinishedA1 | return {$0 == -1} -> STOP ),
SrFinishedA1 = ( epsilon -> Ok | epsilon -> SwChangeA | return {$0 == -1} -> STOP ),

SrClntHelloC = ( epsilon -> SrClntHelloA ),

SrKeyExchA = ( get_client_key_exchange -> SrCertVrfyA | get_client_key_exchange -> return {$0 == -1} -> STOP | return {$0 == -1} -> STOP ),

SrCertVrfyA = ( get_cert_verify -> SrFinishedA | get_cert_verify -> return {$0 == -1} -> STOP | return {$0 == -1} -> STOP ),

SwSrvrDoneA = ( send_server_done -> SwFlushSrCertA | return {$0 == -1} -> STOP ).

//*******************************************************************//
//THE END
//*******************************************************************//

