//*******************************************************************//
//ssl3_connect
//*******************************************************************//

cprog ssl3_connect = ssl3_connect {
    abstract ssl3_connect_1,{$1->state == (0x04|(0x1000|0x2000))},Ssl3Connect;
    abstract ssl3_connect_2,{$1->state == (0x120|0x1000)},Ssl3Connect;
}

cproc ssl3_client_hello {
    abstract {ssl3_client_hello_abs,1,Ssl3ClientHello};
}

cproc ssl3_get_server_hello {
    abstract {ssl3_get_server_hello_abs,1,Ssl3GetServerHello};
}

cproc ssl3_get_finished {
    abstract {ssl3_get_finished_abs,1,Ssl3GetFinished};
}

cproc ssl3_get_server_certificate {
    abstract {ssl3_get_server_certificate_abs,1,Ssl3GetServerCertificate};
}

cproc ssl3_send_change_cipher_spec {
    abstract {ssl3_send_change_cipher_spec_abs,1,Ssl3SendChangeCipherSpec};
}

cproc ssl3_get_key_exchange {
    abstract {ssl3_get_key_exchange_abs,1,Ssl3GetKeyExchange};
}

cproc ssl3_send_finished {
    abstract {ssl3_send_finished_abs,1,Ssl3SendFinished};
}

cproc ssl3_get_certificate_request {
    abstract {ssl3_get_certificate_request_abs,1,Ssl3GetCertificateRequest};
}

cproc ssl3_get_server_done {
    abstract {ssl3_get_server_done_abs,1,Ssl3GetServerDone};
}

cproc ssl3_send_client_certificate {
    abstract {ssl3_send_client_certificate_abs,1,Ssl3SendClientCertificate};
}

cproc ssl3_send_client_key_exchange {
    abstract {ssl3_send_client_key_exchange_abs,1,Ssl3SendClientKeyExchange};
}

cproc ssl3_send_client_verify {
    abstract {ssl3_send_client_verify_abs,1,Ssl3SendClientVerify};
}

cproc ssl3_connect {
    predicate (ret == 1),(ret <= 0);
    //predicate (state == s->state);

    //case SSL_ST_RENEGOTIATE
    predicate (s->state == (0x04|(0x1000|0x2000)));
    //case SSL_ST_BEFORE
    //predicate (s->state == 0x4000);
    //case SSL_ST_CONNECT
    predicate (s->state == 0x1000);
    //case SSL_ST_BEFORE|SSL_ST_CONNECT
    //predicate (s->state == (0x4000|0x1000));
    //case SSL_ST_OK|SSL_ST_CONNECT
    //predicate (s->state == (0x03|0x1000));
    //case SSL3_ST_CW_CLNT_HELLO_A
    predicate (s->state == (0x110|0x1000));
    //case SSL3_ST_CW_CLNT_HELLO_B
    //predicate (s->state == (0x111|0x1000));
    //case SSL3_ST_CR_SRVR_HELLO_A
    predicate (s->state == (0x120|0x1000));
    //case SSL3_ST_CR_SRVR_HELLO_B
    //predicate (s->state == (0x121|0x1000));
    //case SSL3_ST_CR_CERT_A
    predicate (s->state == (0x130|0x1000));
    //case SSL3_ST_CR_CERT_B
    //predicate (s->state == (0x131|0x1000));
    //case SSL3_ST_CR_KEY_EXCH_A
    predicate (s->state == (0x140|0x1000));
    //case SSL3_ST_CR_KEY_EXCH_B
    //predicate (s->state == (0x141|0x1000));
    //case SSL3_ST_CR_CERT_REQ_A
    predicate (s->state == (0x150|0x1000));
    //case SSL3_ST_CR_CERT_REQ_B
    //predicate (s->state == (0x151|0x1000));
    //case SSL3_ST_CR_SRVR_DONE_A
    predicate (s->state == (0x160|0x1000));
    //case SSL3_ST_CR_SRVR_DONE_B
    //predicate (s->state == (0x161|0x1000));
    //case SSL3_ST_CW_CERT_A
    predicate (s->state == (0x170|0x1000));
    //case SSL3_ST_CW_CERT_B
    //predicate (s->state == (0x171|0x1000));
    //case SSL3_ST_CW_CERT_C
    //predicate (s->state == (0x172|0x1000));
    //case SSL3_ST_CW_CERT_D
    //predicate (s->state == (0x173|0x1000));
    //case SSL3_ST_CW_KEY_EXCH_A
    predicate (s->state == (0x180|0x1000));
    //case SSL3_ST_CW_KEY_EXCH_B
    //predicate (s->state == (0x181|0x1000));
    //case SSL3_ST_CW_CERT_VRFY_A
    predicate (s->state == (0x190|0x1000));
    //case SSL3_ST_CW_CERT_VRFY_B
    //predicate (s->state == (0x191|0x1000));
    //case SSL3_ST_CW_CHANGE_A
    predicate (s->state == (0x1A0|0x1000));
    //case SSL3_ST_CW_CHANGE_B
    //predicate (s->state == (0x1A1|0x1000));
    //case SSL3_ST_CW_FINISHED_A
    predicate (s->state == (0x1B0|0x1000));
    //case SSL3_ST_CW_FINISHED_B
    //predicate (s->state == (0x1B1|0x1000));
    //case SSL3_ST_CR_FINISHED_A
    predicate (s->state == (0x1D0|0x1000));
    //case SSL3_ST_CR_FINISHED_B
    //predicate (s->state == (0x1D1|0x1000));
    //case SSL3_ST_CW_FLUSH
    predicate (s->state == (0x100|0x1000));
    //case SSL_ST_OK
    predicate (s->state == 0x03);

    abstract {ssl3_connect_1,($1->state == (0x04|(0x1000|0x2000))),Ssl3Connect};
    abstract {ssl3_connect_2,($1->state == (0x120|0x1000)),Ssl3Connect};
}

Ssl3ClientHello = (ssl3_client_hello -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP).
Ssl3GetServerHello = (ssl3_get_server_hello -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP).
Ssl3GetFinished = (ssl3_get_finished -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP).
Ssl3GetServerCertificate = (ssl3_get_server_certificate -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP).
Ssl3SendChangeCipherSpec = (ssl3_send_change_cipher_spec -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP).
Ssl3GetKeyExchange = (ssl3_get_key_exchange -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP).
Ssl3SendFinished = (ssl3_send_finished -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP).
Ssl3GetCertificateRequest = (ssl3_get_certificate_request -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP).
Ssl3GetServerDone = (ssl3_get_server_done -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP).
Ssl3SendClientCertificate = (ssl3_send_client_certificate -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP).
Ssl3SendClientKeyExchange = (ssl3_send_client_key_exchange -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP).
Ssl3SendClientVerify = (ssl3_send_client_verify -> return {$0 == 1} -> STOP | return {$0 == -1} -> STOP).

Ssl3Connect = (epsilon -> StRenegotiate).
StRenegotiate = (epsilon -> StConnect | return {$0 == -1} -> STOP).
StConnect = (epsilon -> StCwClntHelloA | return {$0 == -1} -> STOP).
StCwClntHelloA = (ssl3_client_hello -> StCwClntHelloA1 | return {$0 == -1} -> STOP),
StCwClntHelloA1 = (epsilon -> StCrSrvrHelloA | return {$0 == -1} -> STOP).
StCrSrvrHelloA = (ssl3_get_server_hello -> StCrSrvrHelloA1 | return {$0 == -1} -> STOP),
StCrSrvrHelloA1 = (epsilon -> StCrFinishedA | epsilon -> StCrCertA | return {$0 == -1} -> STOP).
StCrFinishedA = (ssl3_get_finished -> StCrFinishedA1 | return {$0 == -1} -> STOP),
StCrFinishedA1 = (epsilon -> StCwChangeA | epsilon -> Ok | return {$0 == -1} -> STOP).
StCrCertA = (ssl3_get_server_certificate -> StCrCertA1 | epsilon -> StCrCertA1 | return {$0 == -1} -> STOP),
StCrCertA1 = (epsilon -> StCrKeyExchA | return {$0 == -1} -> STOP).
StCwChangeA = (ssl3_send_change_cipher_spec -> StCwChangeA1 | return {$0 == -1} -> STOP),
StCwChangeA1 = (return {$0 == -1} -> STOP | epsilon -> StCwFinishedA).
Ok = (return {$0 == 1} -> STOP).
StCrKeyExchA = (ssl3_get_key_exchange -> StCrKeyExchA1 | return {$0 == -1} -> STOP),
StCrKeyExchA1 = (return {$0 == -1} -> STOP | epsilon -> StCrCertReqA).
StCwFinishedA = (ssl3_send_finished -> StCwFinishedA1 | return {$0 == -1} -> STOP),
StCwFinishedA1 = (return {$0 == -1} -> STOP | epsilon -> Ok | epsilon -> StCrFinishedA).
StCrCertReqA = (ssl3_get_certificate_request -> StCrCertReqA1 | return {$0 == -1} -> STOP),
StCrCertReqA1 = (return {$0 == -1} -> STOP | epsilon -> StCrSrvrDoneA).
StCrSrvrDoneA = (ssl3_get_server_done -> StCrSrvrDoneA1 | return {$0 == -1} -> STOP),
StCrSrvrDoneA1 = (return {$0 == -1} -> STOP | epsilon -> StCwCertA | epsilon -> StCwKeyExchA).
StCwCertA = (ssl3_send_client_certificate -> StCwCertA1 | return {$0 == -1} -> STOP),
StCwCertA1 = (return {$0 == -1} -> STOP | epsilon -> StCwKeyExchA).
StCwKeyExchA = (ssl3_send_client_key_exchange -> StCwKeyExchA1 | return {$0 == -1} -> STOP),
StCwKeyExchA1 = (return {$0 == -1} -> STOP | epsilon -> StCwCertVrfyA | epsilon -> StCwChangeA).
StCwCertVrfyA = (ssl3_send_client_verify -> StCwCertVrfyA1 | return {$0 == -1} -> STOP),
StCwCertVrfyA1 = (return {$0 == -1} -> STOP | epsilon -> StCwChangeA).

//*******************************************************************//
//THE END
//*******************************************************************//

