typedef unsigned int size_t;
struct _pthread_fastlock {
   long __status ;
   int __spinlock ;
};
struct _pthread_descr_struct;typedef struct _pthread_descr_struct *_pthread_descr;
struct __anonstruct_pthread_cond_t_3 {
   struct _pthread_fastlock __c_lock ;
   _pthread_descr __c_waiting ;
};
typedef struct __anonstruct_pthread_cond_t_3 pthread_cond_t;
struct __anonstruct_pthread_mutex_t_5 {
   int __m_reserved ;
   int __m_count ;
   _pthread_descr __m_owner ;
   int __m_kind ;
   struct _pthread_fastlock __m_lock ;
};
typedef struct __anonstruct_pthread_mutex_t_5 pthread_mutex_t;
struct __anonstruct_pthread_mutexattr_t_6 {
   int __mutexkind ;
};
typedef struct __anonstruct_pthread_mutexattr_t_6 pthread_mutexattr_t;
typedef int pthread_once_t;
typedef unsigned long pthread_t;
struct sched_param {
   int __sched_priority ;
};
struct __anonstruct___sigset_t_7 {
   unsigned long __val[(int )(1024U / (8U * sizeof(unsigned long )))] ;
};
typedef struct __anonstruct___sigset_t_7 __sigset_t;
typedef __sigset_t sigset_t;
struct _pthread_cleanup_buffer {
   void (*__routine)(void * ) ;
   void *__arg ;
   int __canceltype ;
   struct _pthread_cleanup_buffer *__prev ;
};
typedef int __jmp_buf[6];
struct __jmp_buf_tag {
   __jmp_buf __jmpbuf ;
   int __mask_was_saved ;
   __sigset_t __saved_mask ;
};
typedef struct __jmp_buf_tag jmp_buf[1];
typedef jmp_buf sigjmp_buf;
struct pthread_start_args {
   void *(*start_routine)(void * ) ;
   void *arg ;
   sigset_t mask ;
   int schedpolicy ;
   struct sched_param schedparam ;
};
typedef struct _pthread_descr_struct *pthread_descr;
struct _pthread_descr_struct {
   pthread_descr p_nextlive ;
   pthread_descr p_prevlive ;
   pthread_descr p_nextwaiting ;
   pthread_descr p_nextlock ;
   pthread_t p_tid ;
   int p_pid ;
   int p_priority ;
   struct _pthread_fastlock *p_lock ;
   int p_signal ;
   sigjmp_buf *p_signal_jmp ;
   sigjmp_buf *p_cancel_jmp ;
   char p_terminated ;
   char p_detached ;
   char p_exited ;
   void *p_retval ;
   int p_retcode ;
   pthread_descr p_joining ;
   struct _pthread_cleanup_buffer *p_cleanup ;
   char p_cancelstate ;
   char p_canceltype ;
   char p_canceled ;
   int *p_errnop ;
   int p_errno ;
   int *p_h_errnop ;
   int p_h_errno ;
   char *p_in_sighandler ;
   char p_sigwaiting ;
   struct pthread_start_args p_start_args ;
   void **p_specific[32] ;
   void *p_libc_specific[2] ;
   int p_userstack ;
   void *p_guardaddr ;
   size_t p_guardsize ;
   pthread_descr p_self ;
   int p_nr ;
} __attribute__((__aligned__(32))) ;
int __pthread_mutex_init(pthread_mutex_t *mutex , pthread_mutexattr_t const *mutex_attr ) ;
int __pthread_mutex_destroy(pthread_mutex_t *mutex ) ;
int __pthread_mutex_trylock(pthread_mutex_t *mutex ) ;
int __pthread_mutex_lock(pthread_mutex_t *mutex ) ;
extern int pthread_mutex_lock(pthread_mutex_t *__mutex ) ;
int __pthread_mutex_unlock(pthread_mutex_t *mutex ) ;
extern int pthread_mutex_unlock(pthread_mutex_t *__mutex ) ;
int __pthread_mutexattr_init(pthread_mutexattr_t *attr ) ;
int __pthread_mutexattr_destroy(pthread_mutexattr_t *attr ) ;
extern int pthread_cond_broadcast(pthread_cond_t *__cond ) ;
extern int pthread_cond_wait(pthread_cond_t *__cond , pthread_mutex_t *__mutex ) ;
int __pthread_once(pthread_once_t *once_control , void (*init_routine)(void) ) ;
register char *stack_pointer __asm__("%esp") ;
__inline static int __compare_and_swap__extinline(long *p , long oldval , long newval )
{ char ret ;
  long readval ;
  {
  __asm__ volatile ("lock; cmpxchgl %3, %1; sete %0": "=q" (ret), "=m" ((*p)),
                       "=a" (readval): "r" (newval), "m" ((*p)), "a" (oldval): "memory");
  return ((int )ret);
}
}
extern struct _pthread_descr_struct __pthread_initial_thread ;
extern struct _pthread_descr_struct __pthread_manager_thread ;
extern char *__pthread_initial_thread_bos ;
extern int __pthread_nonstandard_stacks ;
extern char *__pthread_manager_thread_bos ;
extern char *__pthread_manager_thread_tos ;
extern pthread_descr __pthread_find_self(void) __attribute__((__const__)) ;
__inline static pthread_descr thread_self(void) __attribute__((__const__)) ;
__inline static pthread_descr thread_self(void) __attribute__((__const__)) ;__inline static pthread_descr thread_self(void)
{ char *sp ;
  pthread_descr tmp ;
  {
  sp = stack_pointer;
  if ((unsigned long )sp >= (unsigned long )__pthread_initial_thread_bos) { return (& __pthread_initial_thread);
  } else {
    if ((unsigned long )sp >= (unsigned long )__pthread_manager_thread_bos) { if ((unsigned long )sp < (unsigned long )__pthread_manager_thread_tos) {
        return (& __pthread_manager_thread);
      } else {
        goto _L;
      }
    } else {
      _L:
      if (__pthread_nonstandard_stacks) { tmp = __pthread_find_self(); return (tmp);
      } else {
        return ((struct _pthread_descr_struct *)(((unsigned long )sp | 2097151UL) +
                                                 1UL) - 1);
      }
    }
  }
}
}
int __pthread_mutexattr_gettype(pthread_mutexattr_t const *attr , int *kind ) ;
extern int __pthread_has_cas ;
extern int __pthread_compare_and_swap(long *ptr , long oldval , long newval , int *spinlock ) ;
extern int ( __builtin_expect)() ;
__inline static int compare_and_swap(long *ptr , long oldval , long newval , int *spinlock )
{ int tmp ;
  int tmp___0 ;
  int tmp___1 ;
  {
  tmp___1 = __builtin_expect(__pthread_has_cas, 1); if (tmp___1) { tmp = __compare_and_swap__extinline(ptr, oldval, newval); return (tmp);
  } else {
    tmp___0 = __pthread_compare_and_swap(ptr, oldval, newval, spinlock); return (tmp___0);
  }
}
}extern void __pthread_lock(struct _pthread_fastlock *lock , pthread_descr self ) ;
extern void __pthread_unlock(struct _pthread_fastlock *lock ) ;
__inline static void __pthread_init_lock(struct _pthread_fastlock *lock )
{
  {
  lock->__status = 0L;
  lock->__spinlock = 0; return;
}
}__inline static int __pthread_trylock(struct _pthread_fastlock *lock )
{ long oldstatus ;
  int tmp ;
  {
  while (1) {
    oldstatus = lock->__status;
    if (oldstatus != 0L) { return (16);
    }
    tmp = compare_and_swap(& lock->__status, 0L, 1L, & lock->__spinlock); if (tmp) { break;
    }
  }
  return (0);
}
}
int __pthread_mutex_init(pthread_mutex_t *mutex , pthread_mutexattr_t const *mutex_attr )
{
  { __pthread_init_lock(& mutex->__m_lock);
  if ((unsigned long )mutex_attr == (unsigned long )((void *)0)) { mutex->__m_kind = 0;
  } else {
    mutex->__m_kind = mutex_attr->__mutexkind;
  }
  mutex->__m_count = 0;
  mutex->__m_owner = (struct _pthread_descr_struct *)((void *)0);
  return (0);
}
}
int __pthread_mutex_destroy(pthread_mutex_t *mutex )
{
  {
  if (mutex->__m_lock.__status != 0L) { return (16);
  } return (0);
}
}
int __pthread_mutex_trylock(pthread_mutex_t *mutex )
{ pthread_descr self ;
  int retcode ;
  { switch (mutex->__m_kind) {
  case 0:
  retcode = __pthread_trylock(& mutex->__m_lock);
  return (retcode);
  case 1:
  self = thread_self();
  if ((unsigned long )mutex->__m_owner == (unsigned long )self) {
    mutex->__m_count ++;
    return (0);
  }
  retcode = __pthread_trylock(& mutex->__m_lock);
  if (retcode == 0) {
    mutex->__m_owner = self;
    mutex->__m_count = 0;
  }
  return (retcode);
  case 2:
  retcode = __pthread_trylock(& mutex->__m_lock);
  if (retcode == 0) {
    mutex->__m_owner = thread_self();
  }
  return (retcode);
  default: ;
  return (22);
  }
  return (0);
}
}
int __pthread_mutex_lock(pthread_mutex_t *mutex )
{ pthread_descr self ;
  { switch (mutex->__m_kind) {
  case 0:
  __pthread_lock(& mutex->__m_lock, (struct _pthread_descr_struct *)((void *)0));
  return (0);
  case 1:
  self = thread_self();
  if ((unsigned long )mutex->__m_owner == (unsigned long )self) {
    mutex->__m_count ++;
    return (0);
  }
  __pthread_lock(& mutex->__m_lock, self);
  mutex->__m_owner = self;
  mutex->__m_count = 0;
  return (0);
  case 2:
  self = thread_self();
  if ((unsigned long )mutex->__m_owner == (unsigned long )self) { return (35);
  }
  mutex->__m_owner = self;
  return (0);
  default: ;
  return (22);
  }
  return (0);
}
}
int __pthread_mutex_unlock(pthread_mutex_t *mutex )
{ pthread_descr tmp ;
  {
  switch (mutex->__m_kind) {
  case 0:
  __pthread_unlock(& mutex->__m_lock);
  return (0);
  case 1: ;
  if (mutex->__m_count > 0) {
    mutex->__m_count --;
    return (0);
  }
  mutex->__m_owner = (struct _pthread_descr_struct *)((void *)0);
  __pthread_unlock(& mutex->__m_lock);
  return (0);
  case 2:
  tmp = thread_self(); if ((unsigned long )mutex->__m_owner != (unsigned long )tmp) { return (0);
  } else {
    if (mutex->__m_lock.__status == 0L) { return (0);
    }
  }
  mutex->__m_owner = (struct _pthread_descr_struct *)((void *)0);
  __pthread_unlock(& mutex->__m_lock);
  return (0);
  default: ;
  return (22);
  }
  return (0);
}
}
int __pthread_mutexattr_init(pthread_mutexattr_t *attr )
{
  {
  attr->__mutexkind = 0;
  return (0);
}
}
int __pthread_mutexattr_destroy(pthread_mutexattr_t *attr )
{
  {
  return (0);
}
}
int __pthread_mutexattr_settype(pthread_mutexattr_t *attr , int kind )
{
  {
  if (kind != 0) { if (kind != 1) { if (kind != 2) {
        return (22);
      }
    }
  }
  attr->__mutexkind = kind;
  return (0);
}
}
int __pthread_mutexattr_gettype(pthread_mutexattr_t const *attr , int *kind )
{
  {
  (*kind) = attr->__mutexkind;
  return (0);
}
}
static pthread_mutex_t once_masterlock = {0, 0, (_pthread_descr )0, 0, {0L, 0}};
static pthread_cond_t once_finished = {{0L, 0}, (_pthread_descr )0};
int __pthread_once(pthread_once_t *once_control , void (*init_routine)(void) )
{
  {
  if ((*once_control) == 2) { return (0);
  } pthread_mutex_lock(& once_masterlock);
  while ((*once_control) == 1) {
    pthread_cond_wait(& once_finished, & once_masterlock);
  }
  if ((*once_control) == 0) {
    (*once_control) = 1;
    pthread_mutex_unlock(& once_masterlock);
    ((*init_routine))();
    pthread_mutex_lock(& once_masterlock);
    (*once_control) = 2;
    pthread_cond_broadcast(& once_finished);
  }
  pthread_mutex_unlock(& once_masterlock);
  return (0);
}
}
