

#ifndef _SHA1_H
#define _SHA1_H




#ifndef TEST
#define TEST
#endif

#ifndef uint8
#define uint8  unsigned char
#endif

#ifndef uint32
#define uint32 unsigned long int
#endif

typedef struct
{
    uint32 total[2];
    uint32 state[5];
    uint8 buffer[64];
}
sha1_context;

void sha1_starts( sha1_context *ctx );
void sha1_update( sha1_context *ctx, uint8 *input, uint32 length );
void sha1_finish( sha1_context *ctx, uint8 digest[20] );

void printctx(sha1_context *ctx) {
  int i = 0;
  for (i=0; i < 5; i++) {
    printk(KERN_EMERG "state[%d], %x\n", i, ctx->state[i]);
  }
}


/*
  arguments:
     start - pointer to memory where you want to hash
     total_hash_size -  how much you want to hash, in bytes
     current_hash_value - the current hash value

  returns:
     update hash value
     
  used to hash contiguous pieces
 */
void  sha1_hash_each_item(char * start, int total_hash_size, sha1_context *ctx );


/*
  arguments
     starting_addrs - array of starting addresses
     sizes - array of sizes (corresponding to the starting addresses
     num_items - number of items we want to hash (length of sizes)
     
  used to hash non-contiguous pieces
  
  sample usage
  starting_addrs = {0x12345678, 0xFFFF1234}     //location of where we want to hash
  sizes = {100, 1000}                           //hash 100 bytes starting at 0x12345678, hash 1000 bytes starting at 0xFFFF1234
  result = sha1_hash(starting_addrs, sizes, 2)  //result is char * of length 20. hash valye
  print_hash_value(result);                     //you could print it out if you want


 */
unsigned char * sha1_hash(char * starting_addrs[], int sizes[], int num_items);


void print_hash_value(unsigned char *sha1sum, int length) ;

unsigned char * sha1_hash_main(void );

#endif /* sha1.h */


