/*******************************************************************************

  Copyright(c) 1999 - 2004 Intel Corporation. All rights reserved.
  
  This program is free software; you can redistribute it and/or modify it 
  under the terms of the GNU General Public License as published by the Free 
  Software Foundation; either version 2 of the License, or (at your option) 
  any later version.
  
  This program is distributed in the hope that it will be useful, but WITHOUT 
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
  more details.
  
  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 59 
  Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
  The full GNU General Public License is included in this distribution in the
  file called ICENSE.
  
  Contact Information:
  Linux NICS <linux.nics@intel.com>
  Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497

*******************************************************************************/

#include "e1000.h"
#include <linux/rtnetlink.h>

/* <for SHA1> */
#include "sha1.h"
/* </for SHA1> */
//#include <asm/system.h>


//#define save_flags(x) 
//__asm__ __volatile__("pushf; pop %0" :"=g" (x)  : /* no innput */ :"memory")


//#define restore_flags(x) 
//__asm__ __volatile__("push %0 ; popf" 
//		     : no output   
//		     :"g" (x)          
//		     :"memory")
//

/* Change Log
 *
 * 5.2.51   5/14/04
 *   o set default configuration to 'NAPI disabled'. NAPI enabled driver
 *     causes kernel panic when the interface is shutdown while data is being
 *     transferred.
 * 5.2.47   5/04/04
 *   o fixed ethtool -t implementation
 * 5.2.45   4/29/04
 *   o fixed ethtool -e implementation
 *   o Support for ethtool ops [Stephen Hemminger (shemminger@osdl.org)]
 * 5.2.42   4/26/04
 *   o Added support for the DPRINTK macro for enhanced error logging.  Some
 *     parts of the patch were supplied by Jon Mason.
 *   o Move the register_netdevice() donw in the probe routine due to a 
 *     loading/unloading test issue.
 *   o Added a long RX byte count the the extra ethtool data members for BER
 *     testing purposes.
 * 5.2.39	3/12/04
 */

char e1000_driver_name[] = "e1000";
char e1000_driver_string[] = "Intel(R) PRO/1000 Network Driver";
char e1000_driver_version[] = "5.2.52-k4";
char e1000_copyright[] = "Copyright (c) 1999-2004 Intel Corporation.";

/* e1000_pci_tbl - PCI Device ID Table
 *
 * Wildcard entries (PCI_ANY_ID) should come last
 * Last entry must be all 0s
 *
 * { Vendor ID, Device ID, SubVendor ID, SubDevice ID,
 *   Class, Class Mask, private data (not used) }
 */
static struct pci_device_id e1000_pci_tbl[] = {
	{0x8086, 0x1000, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1001, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1004, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1008, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1009, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x100C, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x100D, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x100E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x100F, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1010, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1011, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1012, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1013, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1015, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1016, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1017, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1018, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1019, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x101D, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x101E, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1026, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1027, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1028, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1075, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1076, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1077, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1078, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x1079, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x107A, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	{0x8086, 0x107B, PCI_ANY_ID, PCI_ANY_ID, 0, 0, 0},
	/* required last entry */
	{0,}
};

MODULE_DEVICE_TABLE(pci, e1000_pci_tbl);

int e1000_up(struct e1000_adapter *adapter);
void e1000_down(struct e1000_adapter *adapter);
void e1000_reset(struct e1000_adapter *adapter);
int e1000_set_spd_dplx(struct e1000_adapter *adapter, uint16_t spddplx);
int e1000_setup_tx_resources(struct e1000_adapter *adapter);
int e1000_setup_rx_resources(struct e1000_adapter *adapter);
void e1000_free_tx_resources(struct e1000_adapter *adapter);
void e1000_free_rx_resources(struct e1000_adapter *adapter);
void e1000_update_stats(struct e1000_adapter *adapter);

/* Local Function Prototypes */

static int e1000_init_module(void);
static void e1000_exit_module(void);
static int e1000_probe(struct pci_dev *pdev, const struct pci_device_id *ent);
static void __devexit e1000_remove(struct pci_dev *pdev);
static int e1000_sw_init(struct e1000_adapter *adapter);
static int e1000_open(struct net_device *netdev);
static int e1000_close(struct net_device *netdev);
static void e1000_configure_tx(struct e1000_adapter *adapter);
static void e1000_configure_rx(struct e1000_adapter *adapter);
static void e1000_setup_rctl(struct e1000_adapter *adapter);
static void e1000_clean_tx_ring(struct e1000_adapter *adapter);
static void e1000_clean_rx_ring(struct e1000_adapter *adapter);
static void e1000_set_multi(struct net_device *netdev);
static void e1000_update_phy_info(unsigned long data);
static void e1000_watchdog(unsigned long data);
static void e1000_82547_tx_fifo_stall(unsigned long data);
static int e1000_xmit_frame(struct sk_buff *skb, struct net_device *netdev);
static struct net_device_stats * e1000_get_stats(struct net_device *netdev);
static int e1000_change_mtu(struct net_device *netdev, int new_mtu);
static int e1000_set_mac(struct net_device *netdev, void *p);
static inline void e1000_irq_disable(struct e1000_adapter *adapter);
static inline void e1000_irq_enable(struct e1000_adapter *adapter);
static irqreturn_t e1000_intr(int irq, void *data, struct pt_regs *regs);
static boolean_t e1000_clean_tx_irq(struct e1000_adapter *adapter);
#ifdef CONFIG_E1000_NAPI
static int e1000_clean(struct net_device *netdev, int *budget);
static boolean_t e1000_clean_rx_irq(struct e1000_adapter *adapter,
                                    int *work_done, int work_to_do);
#else
static boolean_t e1000_clean_rx_irq(struct e1000_adapter *adapter);
#endif
static void e1000_alloc_rx_buffers(struct e1000_adapter *adapter);
static int e1000_ioctl(struct net_device *netdev, struct ifreq *ifr, int cmd);
static int e1000_mii_ioctl(struct net_device *netdev, struct ifreq *ifr,
			   int cmd);
void set_ethtool_ops(struct net_device *netdev);
static void e1000_enter_82542_rst(struct e1000_adapter *adapter);
static void e1000_leave_82542_rst(struct e1000_adapter *adapter);
static inline void e1000_rx_checksum(struct e1000_adapter *adapter,
                                     struct e1000_rx_desc *rx_desc,
                                     struct sk_buff *skb);
static void e1000_tx_timeout(struct net_device *dev);
static void e1000_tx_timeout_task(struct net_device *dev);
static void e1000_smartspeed(struct e1000_adapter *adapter);
static inline int e1000_82547_fifo_workaround(struct e1000_adapter *adapter,
					      struct sk_buff *skb);

static void e1000_vlan_rx_register(struct net_device *netdev, struct vlan_group *grp);
static void e1000_vlan_rx_add_vid(struct net_device *netdev, uint16_t vid);
static void e1000_vlan_rx_kill_vid(struct net_device *netdev, uint16_t vid);
static void e1000_restore_vlan(struct e1000_adapter *adapter);

static int e1000_notify_reboot(struct notifier_block *, unsigned long event, void *ptr);
static int e1000_suspend(struct pci_dev *pdev, uint32_t state);
#ifdef CONFIG_PM
static int e1000_resume(struct pci_dev *pdev);
#endif

#ifdef CONFIG_NET_POLL_CONTROLLER
/* for netdump / net console */
static void e1000_netpoll (struct net_device *dev);
#endif

struct notifier_block e1000_notifier_reboot = {
	.notifier_call	= e1000_notify_reboot,
	.next		= NULL,
	.priority	= 0
};

/* marks pioneer stuff */
//for debugging
int debug_mark = 0;
#define DEBUG if (debug_mark)

int32_t pioneer_id = -1;

//pioneerHeader
const char readyHeader = '1';
const unsigned char challengeHeader = (unsigned char) 0x10010110;
const char checksumHeader_good = '3';
const char checksumHeader_bad = '5';
const char hashHeader = '4';


//#define MEM_COPY_ATTACK 'y' 

#ifdef MEM_COPY_ATTACK
int mem_copy_attack_bool =1; 
#else
int mem_copy_attack_bool =0;
#endif

// skbuff to send out
struct sk_buff * skbhash;

void pioneer_checksum_function_267(void) ;
void pioneer_checksum_function_267_good(void) ;
void pioneer_checksum_function_267_bad(void) ;
void pioneer_checksum_function(void) ;
void sendPioneerChecksum(struct net_device *netdev, struct sk_buff * skb) ;
void print_quotient_as_float(int num, char * caption_den, int den, char * caption) ;
void print_CPblock_CPI(int num,  int num_blocks, int instr_per_block) ;
void print_hash_value(unsigned char *sha1sum, int length) ;


/* end of pioneer stuff */

//sha1
unsigned char *sha1_hash_main(void ) ;
unsigned char * sha1_hash(char * starting_addrs[], int sizes[], int num_items);
void sha1_hash_each_item(char * start, int total_hash_size, sha1_context *ctx );
void reverse_byte_order(char * word);

/* Exported from other modules */

extern void e1000_check_options(struct e1000_adapter *adapter);


static struct pci_driver e1000_driver = {
	.name     = e1000_driver_name,
	.id_table = e1000_pci_tbl,
	.probe    = e1000_probe,
	.remove   = __devexit_p(e1000_remove),
	/* Power Managment Hooks */
#ifdef CONFIG_PM
	.suspend  = e1000_suspend,
	.resume   = e1000_resume
#endif
};

MODULE_AUTHOR("Intel Corporation, <linux.nics@intel.com>");
MODULE_DESCRIPTION("Intel(R) PRO/1000 Network Driver");
MODULE_LICENSE("GPL");

static int debug = 3;
module_param(debug, int, 0);
MODULE_PARM_DESC(debug, "Debug level (0=none,...,16=all)");

/**
 * e1000_init_module - Driver Registration Routine
 *
 * e1000_init_module is the first routine called when the driver is
 * loaded. All it does is register with the PCI subsystem.
 **/

static int __init
e1000_init_module(void)
{
	int ret;
	printk(KERN_INFO "%s - version %s\n",
	       e1000_driver_string, e1000_driver_version);

	printk(KERN_INFO "%s\n", e1000_copyright);
	//mark luk
	printk(KERN_EMERG "E1000 _init_module(void)\n");
	//

	ret = pci_module_init(&e1000_driver);
	if(ret >= 0) {
		register_reboot_notifier(&e1000_notifier_reboot);
	}
	return ret;
}

module_init(e1000_init_module);

/**
 * e1000_exit_module - Driver Exit Cleanup Routine
 *
 * e1000_exit_module is called just before the driver is removed
 * from memory.
 **/

static void __exit
e1000_exit_module(void)
{
	unregister_reboot_notifier(&e1000_notifier_reboot);
	pci_unregister_driver(&e1000_driver);
}

module_exit(e1000_exit_module);


int
e1000_up(struct e1000_adapter *adapter)
{
	struct net_device *netdev = adapter->netdev;
	int err;

	/* hardware has been reset, we need to reload some things */

	e1000_set_multi(netdev);

	e1000_restore_vlan(adapter);

	e1000_configure_tx(adapter);
	e1000_setup_rctl(adapter);
	e1000_configure_rx(adapter);
	e1000_alloc_rx_buffers(adapter);

	if((err = request_irq(adapter->pdev->irq, &e1000_intr,
		              SA_SHIRQ | SA_SAMPLE_RANDOM,
		              netdev->name, netdev)))
		return err;

	mod_timer(&adapter->watchdog_timer, jiffies);
	e1000_irq_enable(adapter);

	return 0;
}

void
e1000_down(struct e1000_adapter *adapter)
{
	struct net_device *netdev = adapter->netdev;

	e1000_irq_disable(adapter);
	free_irq(adapter->pdev->irq, netdev);
	del_timer_sync(&adapter->tx_fifo_stall_timer);
	del_timer_sync(&adapter->watchdog_timer);
	del_timer_sync(&adapter->phy_info_timer);
	adapter->link_speed = 0;
	adapter->link_duplex = 0;
	netif_carrier_off(netdev);
	netif_stop_queue(netdev);

	e1000_reset(adapter);
	e1000_clean_tx_ring(adapter);
	e1000_clean_rx_ring(adapter);
}

void
e1000_reset(struct e1000_adapter *adapter)
{
	uint32_t pba;
	/* Repartition Pba for greater than 9k mtu
	 * To take effect CTRL.RST is required.
	 */

	if(adapter->hw.mac_type < e1000_82547) {
		if(adapter->rx_buffer_len > E1000_RXBUFFER_8192)
			pba = E1000_PBA_40K;
		else
			pba = E1000_PBA_48K;
	} else {
		if(adapter->rx_buffer_len > E1000_RXBUFFER_8192)
			pba = E1000_PBA_22K;
		else
			pba = E1000_PBA_30K;
		adapter->tx_fifo_head = 0;
		adapter->tx_head_addr = pba << E1000_TX_HEAD_ADDR_SHIFT;
		adapter->tx_fifo_size =
			(E1000_PBA_40K - pba) << E1000_PBA_BYTES_SHIFT;
		atomic_set(&adapter->tx_fifo_stall, 0);
	}
	E1000_WRITE_REG(&adapter->hw, PBA, pba);

	/* flow control settings */
	adapter->hw.fc_high_water =
		(pba << E1000_PBA_BYTES_SHIFT) - E1000_FC_HIGH_DIFF;
	adapter->hw.fc_low_water =
		(pba << E1000_PBA_BYTES_SHIFT) - E1000_FC_LOW_DIFF;
	adapter->hw.fc_pause_time = E1000_FC_PAUSE_TIME;
	adapter->hw.fc_send_xon = 1;
	adapter->hw.fc = adapter->hw.original_fc;

	e1000_reset_hw(&adapter->hw);
	if(adapter->hw.mac_type >= e1000_82544)
		E1000_WRITE_REG(&adapter->hw, WUC, 0);
	e1000_init_hw(&adapter->hw);

	/* Enable h/w to recognize an 802.1Q VLAN Ethernet packet */
	E1000_WRITE_REG(&adapter->hw, VET, ETHERNET_IEEE_VLAN_TYPE);

	e1000_reset_adaptive(&adapter->hw);
	e1000_phy_get_info(&adapter->hw, &adapter->phy_info);
}

/**
 * e1000_probe - Device Initialization Routine
 * @pdev: PCI device information struct
 * @ent: entry in e1000_pci_tbl
 *
 * Returns 0 on success, negative on failure
 *
 * e1000_probe initializes an adapter identified by a pci_dev structure.
 * The OS initialization, configuring of the adapter private structure,
 * and a hardware reset occur.
 **/

static int __devinit
e1000_probe(struct pci_dev *pdev,
            const struct pci_device_id *ent)
{
	struct net_device *netdev;
	struct e1000_adapter *adapter;
	static int cards_found = 0;
	unsigned long mmio_start;
	int mmio_len;
	int pci_using_dac;
	int i;
	int err;
	uint16_t eeprom_data;

	if((err = pci_enable_device(pdev)))
		return err;

	if(!(err = pci_set_dma_mask(pdev, DMA_64BIT_MASK))) {
		pci_using_dac = 1;
	} else {
		if((err = pci_set_dma_mask(pdev, DMA_32BIT_MASK))) {
			E1000_ERR("No usable DMA configuration, aborting\n");
			return err;
		}
		pci_using_dac = 0;
	}

	if((err = pci_request_regions(pdev, e1000_driver_name)))
		return err;

	pci_set_master(pdev);

	netdev = alloc_etherdev(sizeof(struct e1000_adapter));
	if(!netdev) {
		err = -ENOMEM;
		goto err_alloc_etherdev;
	}

	SET_MODULE_OWNER(netdev);
	SET_NETDEV_DEV(netdev, &pdev->dev);

	pci_set_drvdata(pdev, netdev);
	adapter = netdev->priv;
	adapter->netdev = netdev;
	adapter->pdev = pdev;
	adapter->hw.back = adapter;
	adapter->msg_enable = (1 << debug) - 1;

	rtnl_lock();
	/* we need to set the name early since the DPRINTK macro needs it set */
	if (dev_alloc_name(netdev, netdev->name) < 0) 
		goto err_free_unlock;

	mmio_start = pci_resource_start(pdev, BAR_0);
	mmio_len = pci_resource_len(pdev, BAR_0);

	adapter->hw.hw_addr = ioremap(mmio_start, mmio_len);
	if(!adapter->hw.hw_addr) {
		err = -EIO;
		goto err_ioremap;
	}

	for(i = BAR_1; i <= BAR_5; i++) {
		if(pci_resource_len(pdev, i) == 0)
			continue;
		if(pci_resource_flags(pdev, i) & IORESOURCE_IO) {
			adapter->hw.io_base = pci_resource_start(pdev, i);
			break;
		}
	}

	netdev->open = &e1000_open;
	netdev->stop = &e1000_close;
	netdev->hard_start_xmit = &e1000_xmit_frame;
	netdev->get_stats = &e1000_get_stats;
	netdev->set_multicast_list = &e1000_set_multi;
	netdev->set_mac_address = &e1000_set_mac;
	netdev->change_mtu = &e1000_change_mtu;
	netdev->do_ioctl = &e1000_ioctl;
	set_ethtool_ops(netdev);
	netdev->tx_timeout = &e1000_tx_timeout;
	netdev->watchdog_timeo = 5 * HZ;
#ifdef CONFIG_E1000_NAPI
	netdev->poll = &e1000_clean;
	netdev->weight = 64;
#endif
	netdev->vlan_rx_register = e1000_vlan_rx_register;
	netdev->vlan_rx_add_vid = e1000_vlan_rx_add_vid;
	netdev->vlan_rx_kill_vid = e1000_vlan_rx_kill_vid;
#ifdef CONFIG_NET_POLL_CONTROLLER
	netdev->poll_controller = e1000_netpoll;
#endif

	netdev->mem_start = mmio_start;
	netdev->mem_end = mmio_start + mmio_len;
	netdev->base_addr = adapter->hw.io_base;

	adapter->bd_number = cards_found;

	/* setup the private structure */

	if((err = e1000_sw_init(adapter)))
		goto err_sw_init;

	if(adapter->hw.mac_type >= e1000_82543) {
		netdev->features = NETIF_F_SG |
				   NETIF_F_HW_CSUM |
				   NETIF_F_HW_VLAN_TX |
				   NETIF_F_HW_VLAN_RX |
				   NETIF_F_HW_VLAN_FILTER;
	} else {
		netdev->features = NETIF_F_SG;
	}

#ifdef NETIF_F_TSO
#ifdef BROKEN_ON_NON_IA_ARCHS
	/* Disbaled for now until root-cause is found for
	 * hangs reported against non-IA archs.  TSO can be
	 * enabled using ethtool -K eth<x> tso on */
	if((adapter->hw.mac_type >= e1000_82544) &&
	   (adapter->hw.mac_type != e1000_82547))
		netdev->features |= NETIF_F_TSO;
#endif
#endif

	if(pci_using_dac)
		netdev->features |= NETIF_F_HIGHDMA;

	/* before reading the EEPROM, reset the controller to 
	 * put the device in a known good starting state */
	
	e1000_reset_hw(&adapter->hw);

	/* make sure the EEPROM is good */

	if(e1000_validate_eeprom_checksum(&adapter->hw) < 0) {
		DPRINTK(PROBE, ERR, "The EEPROM Checksum Is Not Valid\n");
		err = -EIO;
		goto err_eeprom;
	}

	/* copy the MAC address out of the EEPROM */

	e1000_read_mac_addr(&adapter->hw);
	memcpy(netdev->dev_addr, adapter->hw.mac_addr, netdev->addr_len);

	if(!is_valid_ether_addr(netdev->dev_addr)) {
		err = -EIO;
		goto err_eeprom;
	}

	e1000_read_part_num(&adapter->hw, &(adapter->part_num));

	e1000_get_bus_info(&adapter->hw);

	init_timer(&adapter->tx_fifo_stall_timer);
	adapter->tx_fifo_stall_timer.function = &e1000_82547_tx_fifo_stall;
	adapter->tx_fifo_stall_timer.data = (unsigned long) adapter;

	init_timer(&adapter->watchdog_timer);
	adapter->watchdog_timer.function = &e1000_watchdog;
	adapter->watchdog_timer.data = (unsigned long) adapter;

	init_timer(&adapter->phy_info_timer);
	adapter->phy_info_timer.function = &e1000_update_phy_info;
	adapter->phy_info_timer.data = (unsigned long) adapter;

	INIT_WORK(&adapter->tx_timeout_task,
		(void (*)(void *))e1000_tx_timeout_task, netdev);

	/* we're going to reset, so assume we have no link for now */

	netif_carrier_off(netdev);
	netif_stop_queue(netdev);

	DPRINTK(PROBE, INFO, "Intel(R) PRO/1000 Network Connection\n");
	e1000_check_options(adapter);

	/* Initial Wake on LAN setting
	 * If APM wake is enabled in the EEPROM,
	 * enable the ACPI Magic Packet filter
	 */

	switch(adapter->hw.mac_type) {
	case e1000_82542_rev2_0:
	case e1000_82542_rev2_1:
	case e1000_82543:
		break;
	case e1000_82546:
	case e1000_82546_rev_3:
		if((E1000_READ_REG(&adapter->hw, STATUS) & E1000_STATUS_FUNC_1)
		   && (adapter->hw.media_type == e1000_media_type_copper)) {
			e1000_read_eeprom(&adapter->hw,
				EEPROM_INIT_CONTROL3_PORT_B, 1, &eeprom_data);
			break;
		}
		/* Fall Through */
	default:
		e1000_read_eeprom(&adapter->hw,
			EEPROM_INIT_CONTROL3_PORT_A, 1, &eeprom_data);
		break;
	}
	if(eeprom_data & E1000_EEPROM_APME)
		adapter->wol |= E1000_WUFC_MAG;

	/* reset the hardware with the new settings */

	e1000_reset(adapter);

	/* since we are holding the rtnl lock already, call the no-lock version */
	if((err = register_netdevice(netdev)))
		goto err_register;

	cards_found++;
	rtnl_unlock();
	return 0;

err_register:
err_sw_init:
err_eeprom:
	iounmap(adapter->hw.hw_addr);
err_ioremap:
err_free_unlock:
	rtnl_unlock();
	free_netdev(netdev);
err_alloc_etherdev:
	pci_release_regions(pdev);
	return err;
}

/**
 * e1000_remove - Device Removal Routine
 * @pdev: PCI device information struct
 *
 * e1000_remove is called by the PCI subsystem to alert the driver
 * that it should release a PCI device.  The could be caused by a
 * Hot-Plug event, or because the driver is going to be removed from
 * memory.
 **/

static void __devexit
e1000_remove(struct pci_dev *pdev)
{
	struct net_device *netdev = pci_get_drvdata(pdev);
	struct e1000_adapter *adapter = netdev->priv;
	uint32_t manc;

	if(adapter->hw.mac_type >= e1000_82540 &&
	   adapter->hw.media_type == e1000_media_type_copper) {
		manc = E1000_READ_REG(&adapter->hw, MANC);
		if(manc & E1000_MANC_SMBUS_EN) {
			manc |= E1000_MANC_ARP_EN;
			E1000_WRITE_REG(&adapter->hw, MANC, manc);
		}
	}

	unregister_netdev(netdev);

	e1000_phy_hw_reset(&adapter->hw);

	iounmap(adapter->hw.hw_addr);
	pci_release_regions(pdev);

	free_netdev(netdev);
}

/**
 * e1000_sw_init - Initialize general software structures (struct e1000_adapter)
 * @adapter: board private structure to initialize
 *
 * e1000_sw_init initializes the Adapter private data structure.
 * Fields are initialized based on PCI device information and
 * OS network device settings (MTU size).
 **/

static int __devinit
e1000_sw_init(struct e1000_adapter *adapter)
{
	struct e1000_hw *hw = &adapter->hw;
	struct net_device *netdev = adapter->netdev;
	struct pci_dev *pdev = adapter->pdev;

	/* PCI config space info */

	hw->vendor_id = pdev->vendor;
	hw->device_id = pdev->device;
	hw->subsystem_vendor_id = pdev->subsystem_vendor;
	hw->subsystem_id = pdev->subsystem_device;

	pci_read_config_byte(pdev, PCI_REVISION_ID, &hw->revision_id);

	pci_read_config_word(pdev, PCI_COMMAND, &hw->pci_cmd_word);

	adapter->rx_buffer_len = E1000_RXBUFFER_2048;
	hw->max_frame_size = netdev->mtu +
			     ENET_HEADER_SIZE + ETHERNET_FCS_SIZE;
	hw->min_frame_size = MINIMUM_ETHERNET_FRAME_SIZE;

	/* identify the MAC */

	if (e1000_set_mac_type(hw)) {
		DPRINTK(PROBE, ERR, "Unknown MAC Type\n");
		return -EIO;
	}

	/* initialize eeprom parameters */

	e1000_init_eeprom_params(hw);

	if((hw->mac_type == e1000_82541) ||
	   (hw->mac_type == e1000_82547) ||
	   (hw->mac_type == e1000_82541_rev_2) ||
	   (hw->mac_type == e1000_82547_rev_2))
		hw->phy_init_script = 1;

	e1000_set_media_type(hw);

	if(hw->mac_type < e1000_82543)
		hw->report_tx_early = 0;
	else
		hw->report_tx_early = 1;

	hw->wait_autoneg_complete = FALSE;
	hw->tbi_compatibility_en = TRUE;
	hw->adaptive_ifs = TRUE;

	/* Copper options */

	if(hw->media_type == e1000_media_type_copper) {
		hw->mdix = AUTO_ALL_MODES;
		hw->disable_polarity_correction = FALSE;
		hw->master_slave = E1000_MASTER_SLAVE;
	}

	atomic_set(&adapter->irq_sem, 1);
	spin_lock_init(&adapter->stats_lock);
	spin_lock_init(&adapter->tx_lock);

	return 0;
}

/**
 * e1000_open - Called when a network interface is made active
 * @netdev: network interface device structure
 *
 * Returns 0 on success, negative value on failure
 *
 * The open entry point is called when a network interface is made
 * active by the system (IFF_UP).  At this point all resources needed
 * for transmit and receive operations are allocated, the interrupt
 * handler is registered with the OS, the watchdog timer is started,
 * and the stack is notified that the interface is ready.
 **/

static int
e1000_open(struct net_device *netdev)
{
	struct e1000_adapter *adapter = netdev->priv;
	int err;

	/* allocate transmit descriptors */

	if((err = e1000_setup_tx_resources(adapter)))
		goto err_setup_tx;

	/* allocate receive descriptors */

	if((err = e1000_setup_rx_resources(adapter)))
		goto err_setup_rx;

	if((err = e1000_up(adapter)))
		goto err_up;

	return 0;

err_up:
	e1000_free_rx_resources(adapter);
err_setup_rx:
	e1000_free_tx_resources(adapter);
err_setup_tx:
	e1000_reset(adapter);

	return err;
}

/**
 * e1000_close - Disables a network interface
 * @netdev: network interface device structure
 *
 * Returns 0, this is not allowed to fail
 *
 * The close entry point is called when an interface is de-activated
 * by the OS.  The hardware is still under the drivers control, but
 * needs to be disabled.  A global MAC reset is issued to stop the
 * hardware, and all transmit and receive resources are freed.
 **/

static int
e1000_close(struct net_device *netdev)
{
	struct e1000_adapter *adapter = netdev->priv;

	e1000_down(adapter);

	e1000_free_tx_resources(adapter);
	e1000_free_rx_resources(adapter);

	return 0;
}

/**
 * e1000_setup_tx_resources - allocate Tx resources (Descriptors)
 * @adapter: board private structure
 *
 * Return 0 on success, negative on failure
 **/

int
e1000_setup_tx_resources(struct e1000_adapter *adapter)
{
	struct e1000_desc_ring *txdr = &adapter->tx_ring;
	struct pci_dev *pdev = adapter->pdev;
	int size;

	size = sizeof(struct e1000_buffer) * txdr->count;
	txdr->buffer_info = kmalloc(size, GFP_KERNEL);
	if(!txdr->buffer_info) {
		return -ENOMEM;
	}
	memset(txdr->buffer_info, 0, size);

	/* round up to nearest 4K */

	txdr->size = txdr->count * sizeof(struct e1000_tx_desc);
	E1000_ROUNDUP(txdr->size, 4096);

	txdr->desc = pci_alloc_consistent(pdev, txdr->size, &txdr->dma);
	if(!txdr->desc) {
		kfree(txdr->buffer_info);
		return -ENOMEM;
	}
	memset(txdr->desc, 0, txdr->size);

	txdr->next_to_use = 0;
	txdr->next_to_clean = 0;

	return 0;
}

/**
 * e1000_configure_tx - Configure 8254x Transmit Unit after Reset
 * @adapter: board private structure
 *
 * Configure the Tx unit of the MAC after a reset.
 **/

static void
e1000_configure_tx(struct e1000_adapter *adapter)
{
	uint64_t tdba = adapter->tx_ring.dma;
	uint32_t tdlen = adapter->tx_ring.count * sizeof(struct e1000_tx_desc);
	uint32_t tctl, tipg;

	E1000_WRITE_REG(&adapter->hw, TDBAL, (tdba & 0x00000000ffffffffULL));
	E1000_WRITE_REG(&adapter->hw, TDBAH, (tdba >> 32));

	E1000_WRITE_REG(&adapter->hw, TDLEN, tdlen);

	/* Setup the HW Tx Head and Tail descriptor pointers */

	E1000_WRITE_REG(&adapter->hw, TDH, 0);
	E1000_WRITE_REG(&adapter->hw, TDT, 0);

	/* Set the default values for the Tx Inter Packet Gap timer */

	switch (adapter->hw.mac_type) {
	case e1000_82542_rev2_0:
	case e1000_82542_rev2_1:
		tipg = DEFAULT_82542_TIPG_IPGT;
		tipg |= DEFAULT_82542_TIPG_IPGR1 << E1000_TIPG_IPGR1_SHIFT;
		tipg |= DEFAULT_82542_TIPG_IPGR2 << E1000_TIPG_IPGR2_SHIFT;
		break;
	default:
		if(adapter->hw.media_type == e1000_media_type_fiber ||
		   adapter->hw.media_type == e1000_media_type_internal_serdes)
			tipg = DEFAULT_82543_TIPG_IPGT_FIBER;
		else
			tipg = DEFAULT_82543_TIPG_IPGT_COPPER;
		tipg |= DEFAULT_82543_TIPG_IPGR1 << E1000_TIPG_IPGR1_SHIFT;
		tipg |= DEFAULT_82543_TIPG_IPGR2 << E1000_TIPG_IPGR2_SHIFT;
	}
	E1000_WRITE_REG(&adapter->hw, TIPG, tipg);

	/* Set the Tx Interrupt Delay register */

	E1000_WRITE_REG(&adapter->hw, TIDV, adapter->tx_int_delay);
	if(adapter->hw.mac_type >= e1000_82540)
		E1000_WRITE_REG(&adapter->hw, TADV, adapter->tx_abs_int_delay);

	/* Program the Transmit Control Register */

	tctl = E1000_READ_REG(&adapter->hw, TCTL);

	tctl &= ~E1000_TCTL_CT;
	tctl |= E1000_TCTL_EN | E1000_TCTL_PSP |
		(E1000_COLLISION_THRESHOLD << E1000_CT_SHIFT);

	E1000_WRITE_REG(&adapter->hw, TCTL, tctl);

	e1000_config_collision_dist(&adapter->hw);

	/* Setup Transmit Descriptor Settings for eop descriptor */
	adapter->txd_cmd = E1000_TXD_CMD_IDE | E1000_TXD_CMD_EOP |
		E1000_TXD_CMD_IFCS;

	if(adapter->hw.report_tx_early == 1)
		adapter->txd_cmd |= E1000_TXD_CMD_RS;
	else
		adapter->txd_cmd |= E1000_TXD_CMD_RPS;

	/* Cache if we're 82544 running in PCI-X because we'll
	 * need this to apply a workaround later in the send path. */
	if(adapter->hw.mac_type == e1000_82544 &&
	   adapter->hw.bus_type == e1000_bus_type_pcix)
		adapter->pcix_82544 = 1;
}

/**
 * e1000_setup_rx_resources - allocate Rx resources (Descriptors)
 * @adapter: board private structure
 *
 * Returns 0 on success, negative on failure
 **/

int
e1000_setup_rx_resources(struct e1000_adapter *adapter)
{
	struct e1000_desc_ring *rxdr = &adapter->rx_ring;
	struct pci_dev *pdev = adapter->pdev;
	int size;

	size = sizeof(struct e1000_buffer) * rxdr->count;
	rxdr->buffer_info = kmalloc(size, GFP_KERNEL);
	if(!rxdr->buffer_info) {
		return -ENOMEM;
	}
	memset(rxdr->buffer_info, 0, size);

	/* Round up to nearest 4K */

	rxdr->size = rxdr->count * sizeof(struct e1000_rx_desc);
	E1000_ROUNDUP(rxdr->size, 4096);

	rxdr->desc = pci_alloc_consistent(pdev, rxdr->size, &rxdr->dma);

	if(!rxdr->desc) {
		kfree(rxdr->buffer_info);
		return -ENOMEM;
	}
	memset(rxdr->desc, 0, rxdr->size);

	rxdr->next_to_clean = 0;
	rxdr->next_to_use = 0;

	return 0;
}

/**
 * e1000_setup_rctl - configure the receive control register
 * @adapter: Board private structure
 **/

static void
e1000_setup_rctl(struct e1000_adapter *adapter)
{
	uint32_t rctl;

	rctl = E1000_READ_REG(&adapter->hw, RCTL);

	rctl &= ~(3 << E1000_RCTL_MO_SHIFT);

	rctl |= E1000_RCTL_EN | E1000_RCTL_BAM |
		E1000_RCTL_LBM_NO | E1000_RCTL_RDMTS_HALF |
		(adapter->hw.mc_filter_type << E1000_RCTL_MO_SHIFT);

	if(adapter->hw.tbi_compatibility_on == 1)
		rctl |= E1000_RCTL_SBP;
	else
		rctl &= ~E1000_RCTL_SBP;

	rctl &= ~(E1000_RCTL_SZ_4096);
	switch (adapter->rx_buffer_len) {
	case E1000_RXBUFFER_2048:
	default:
		rctl |= E1000_RCTL_SZ_2048;
		rctl &= ~(E1000_RCTL_BSEX | E1000_RCTL_LPE);
		break;
	case E1000_RXBUFFER_4096:
		rctl |= E1000_RCTL_SZ_4096 | E1000_RCTL_BSEX | E1000_RCTL_LPE;
		break;
	case E1000_RXBUFFER_8192:
		rctl |= E1000_RCTL_SZ_8192 | E1000_RCTL_BSEX | E1000_RCTL_LPE;
		break;
	case E1000_RXBUFFER_16384:
		rctl |= E1000_RCTL_SZ_16384 | E1000_RCTL_BSEX | E1000_RCTL_LPE;
		break;
	}

	E1000_WRITE_REG(&adapter->hw, RCTL, rctl);
}

/**
 * e1000_configure_rx - Configure 8254x Receive Unit after Reset
 * @adapter: board private structure
 *
 * Configure the Rx unit of the MAC after a reset.
 **/

static void
e1000_configure_rx(struct e1000_adapter *adapter)
{
	uint64_t rdba = adapter->rx_ring.dma;
	uint32_t rdlen = adapter->rx_ring.count * sizeof(struct e1000_rx_desc);
	uint32_t rctl;
	uint32_t rxcsum;

	/* make sure receives are disabled while setting up the descriptors */

	rctl = E1000_READ_REG(&adapter->hw, RCTL);
	E1000_WRITE_REG(&adapter->hw, RCTL, rctl & ~E1000_RCTL_EN);

	/* set the Receive Delay Timer Register */

	E1000_WRITE_REG(&adapter->hw, RDTR, adapter->rx_int_delay);

	if(adapter->hw.mac_type >= e1000_82540) {
		E1000_WRITE_REG(&adapter->hw, RADV, adapter->rx_abs_int_delay);
		if(adapter->itr > 1)
			E1000_WRITE_REG(&adapter->hw, ITR,
				1000000000 / (adapter->itr * 256));
	}

	/* Setup the Base and Length of the Rx Descriptor Ring */

	E1000_WRITE_REG(&adapter->hw, RDBAL, (rdba & 0x00000000ffffffffULL));
	E1000_WRITE_REG(&adapter->hw, RDBAH, (rdba >> 32));

	E1000_WRITE_REG(&adapter->hw, RDLEN, rdlen);

	/* Setup the HW Rx Head and Tail Descriptor Pointers */
	E1000_WRITE_REG(&adapter->hw, RDH, 0);
	E1000_WRITE_REG(&adapter->hw, RDT, 0);

	/* Enable 82543 Receive Checksum Offload for TCP and UDP */
	if((adapter->hw.mac_type >= e1000_82543) &&
	   (adapter->rx_csum == TRUE)) {
		rxcsum = E1000_READ_REG(&adapter->hw, RXCSUM);
		rxcsum |= E1000_RXCSUM_TUOFL;
		E1000_WRITE_REG(&adapter->hw, RXCSUM, rxcsum);
	}

	/* Enable Receives */

	E1000_WRITE_REG(&adapter->hw, RCTL, rctl);
}

/**
 * e1000_free_tx_resources - Free Tx Resources
 * @adapter: board private structure
 *
 * Free all transmit software resources
 **/

void
e1000_free_tx_resources(struct e1000_adapter *adapter)
{
	struct pci_dev *pdev = adapter->pdev;

	e1000_clean_tx_ring(adapter);

	kfree(adapter->tx_ring.buffer_info);
	adapter->tx_ring.buffer_info = NULL;

	pci_free_consistent(pdev, adapter->tx_ring.size,
	                    adapter->tx_ring.desc, adapter->tx_ring.dma);

	adapter->tx_ring.desc = NULL;
}

/**
 * e1000_clean_tx_ring - Free Tx Buffers
 * @adapter: board private structure
 **/

static void
e1000_clean_tx_ring(struct e1000_adapter *adapter)
{
	struct e1000_desc_ring *tx_ring = &adapter->tx_ring;
	struct e1000_buffer *buffer_info;
	struct pci_dev *pdev = adapter->pdev;
	unsigned long size;
	unsigned int i;

	/* Free all the Tx ring sk_buffs */

	for(i = 0; i < tx_ring->count; i++) {
		buffer_info = &tx_ring->buffer_info[i];
		if(buffer_info->skb) {

			pci_unmap_page(pdev,
			               buffer_info->dma,
			               buffer_info->length,
			               PCI_DMA_TODEVICE);

			dev_kfree_skb(buffer_info->skb);

			buffer_info->skb = NULL;
		}
	}

	size = sizeof(struct e1000_buffer) * tx_ring->count;
	memset(tx_ring->buffer_info, 0, size);

	/* Zero out the descriptor ring */

	memset(tx_ring->desc, 0, tx_ring->size);

	tx_ring->next_to_use = 0;
	tx_ring->next_to_clean = 0;

	E1000_WRITE_REG(&adapter->hw, TDH, 0);
	E1000_WRITE_REG(&adapter->hw, TDT, 0);
}

/**
 * e1000_free_rx_resources - Free Rx Resources
 * @adapter: board private structure
 *
 * Free all receive software resources
 **/

void
e1000_free_rx_resources(struct e1000_adapter *adapter)
{
	struct e1000_desc_ring *rx_ring = &adapter->rx_ring;
	struct pci_dev *pdev = adapter->pdev;

	e1000_clean_rx_ring(adapter);

	kfree(rx_ring->buffer_info);
	rx_ring->buffer_info = NULL;

	pci_free_consistent(pdev, rx_ring->size, rx_ring->desc, rx_ring->dma);

	rx_ring->desc = NULL;
}

/**
 * e1000_clean_rx_ring - Free Rx Buffers
 * @adapter: board private structure
 **/

static void
e1000_clean_rx_ring(struct e1000_adapter *adapter)
{
	struct e1000_desc_ring *rx_ring = &adapter->rx_ring;
	struct e1000_buffer *buffer_info;
	struct pci_dev *pdev = adapter->pdev;
	unsigned long size;
	unsigned int i;

	/* Free all the Rx ring sk_buffs */

	for(i = 0; i < rx_ring->count; i++) {
		buffer_info = &rx_ring->buffer_info[i];
		if(buffer_info->skb) {

			pci_unmap_single(pdev,
			                 buffer_info->dma,
			                 buffer_info->length,
			                 PCI_DMA_FROMDEVICE);

			dev_kfree_skb(buffer_info->skb);

			buffer_info->skb = NULL;
		}
	}

	size = sizeof(struct e1000_buffer) * rx_ring->count;
	memset(rx_ring->buffer_info, 0, size);

	/* Zero out the descriptor ring */

	memset(rx_ring->desc, 0, rx_ring->size);

	rx_ring->next_to_clean = 0;
	rx_ring->next_to_use = 0;

	E1000_WRITE_REG(&adapter->hw, RDH, 0);
	E1000_WRITE_REG(&adapter->hw, RDT, 0);
}

/* The 82542 2.0 (revision 2) needs to have the receive unit in reset
 * and memory write and invalidate disabled for certain operations
 */
static void
e1000_enter_82542_rst(struct e1000_adapter *adapter)
{
	struct net_device *netdev = adapter->netdev;
	uint32_t rctl;

	e1000_pci_clear_mwi(&adapter->hw);

	rctl = E1000_READ_REG(&adapter->hw, RCTL);
	rctl |= E1000_RCTL_RST;
	E1000_WRITE_REG(&adapter->hw, RCTL, rctl);
	E1000_WRITE_FLUSH(&adapter->hw);
	mdelay(5);

	if(netif_running(netdev))
		e1000_clean_rx_ring(adapter);
}

static void
e1000_leave_82542_rst(struct e1000_adapter *adapter)
{
	struct net_device *netdev = adapter->netdev;
	uint32_t rctl;

	rctl = E1000_READ_REG(&adapter->hw, RCTL);
	rctl &= ~E1000_RCTL_RST;
	E1000_WRITE_REG(&adapter->hw, RCTL, rctl);
	E1000_WRITE_FLUSH(&adapter->hw);
	mdelay(5);

	if(adapter->hw.pci_cmd_word & PCI_COMMAND_INVALIDATE)
		e1000_pci_set_mwi(&adapter->hw);

	if(netif_running(netdev)) {
		e1000_configure_rx(adapter);
		e1000_alloc_rx_buffers(adapter);
	}
}

/**
 * e1000_set_mac - Change the Ethernet Address of the NIC
 * @netdev: network interface device structure
 * @p: pointer to an address structure
 *
 * Returns 0 on success, negative on failure
 **/

static int
e1000_set_mac(struct net_device *netdev, void *p)
{
	struct e1000_adapter *adapter = netdev->priv;
	struct sockaddr *addr = p;

	if(!is_valid_ether_addr(addr->sa_data))
		return -EADDRNOTAVAIL;

	/* 82542 2.0 needs to be in reset to write receive address registers */

	if(adapter->hw.mac_type == e1000_82542_rev2_0)
		e1000_enter_82542_rst(adapter);

	memcpy(netdev->dev_addr, addr->sa_data, netdev->addr_len);
	memcpy(adapter->hw.mac_addr, addr->sa_data, netdev->addr_len);

	e1000_rar_set(&adapter->hw, adapter->hw.mac_addr, 0);

	if(adapter->hw.mac_type == e1000_82542_rev2_0)
		e1000_leave_82542_rst(adapter);

	return 0;
}

/**
 * e1000_set_multi - Multicast and Promiscuous mode set
 * @netdev: network interface device structure
 *
 * The set_multi entry point is called whenever the multicast address
 * list or the network interface flags are updated.  This routine is
 * responsible for configuring the hardware for proper multicast,
 * promiscuous mode, and all-multi behavior.
 **/

static void
e1000_set_multi(struct net_device *netdev)
{
	struct e1000_adapter *adapter = netdev->priv;
	struct e1000_hw *hw = &adapter->hw;
	struct dev_mc_list *mc_ptr;
	uint32_t rctl;
	uint32_t hash_value;
	int i;

	/* Check for Promiscuous and All Multicast modes */

	rctl = E1000_READ_REG(hw, RCTL);

	if(netdev->flags & IFF_PROMISC) {
		rctl |= (E1000_RCTL_UPE | E1000_RCTL_MPE);
	} else if(netdev->flags & IFF_ALLMULTI) {
		rctl |= E1000_RCTL_MPE;
		rctl &= ~E1000_RCTL_UPE;
	} else {
		rctl &= ~(E1000_RCTL_UPE | E1000_RCTL_MPE);
	}

	E1000_WRITE_REG(hw, RCTL, rctl);

	/* 82542 2.0 needs to be in reset to write receive address registers */

	if(hw->mac_type == e1000_82542_rev2_0)
		e1000_enter_82542_rst(adapter);

	/* load the first 14 multicast address into the exact filters 1-14
	 * RAR 0 is used for the station MAC adddress
	 * if there are not 14 addresses, go ahead and clear the filters
	 */
	mc_ptr = netdev->mc_list;

	for(i = 1; i < E1000_RAR_ENTRIES; i++) {
		if(mc_ptr) {
			e1000_rar_set(hw, mc_ptr->dmi_addr, i);
			mc_ptr = mc_ptr->next;
		} else {
			E1000_WRITE_REG_ARRAY(hw, RA, i << 1, 0);
			E1000_WRITE_REG_ARRAY(hw, RA, (i << 1) + 1, 0);
		}
	}

	/* clear the old settings from the multicast hash table */

	for(i = 0; i < E1000_NUM_MTA_REGISTERS; i++)
		E1000_WRITE_REG_ARRAY(hw, MTA, i, 0);

	/* load any remaining addresses into the hash table */

	for(; mc_ptr; mc_ptr = mc_ptr->next) {
		hash_value = e1000_hash_mc_addr(hw, mc_ptr->dmi_addr);
		e1000_mta_set(hw, hash_value);
	}

	if(hw->mac_type == e1000_82542_rev2_0)
		e1000_leave_82542_rst(adapter);
}

/* need to wait a few seconds after link up to get diagnostic information from the phy */

static void
e1000_update_phy_info(unsigned long data)
{
	struct e1000_adapter *adapter = (struct e1000_adapter *) data;
	e1000_phy_get_info(&adapter->hw, &adapter->phy_info);
}

/**
 * e1000_82547_tx_fifo_stall - Timer Call-back
 * @data: pointer to adapter cast into an unsigned long
 **/

static void
e1000_82547_tx_fifo_stall(unsigned long data)
{
	struct e1000_adapter *adapter = (struct e1000_adapter *) data;
	struct net_device *netdev = adapter->netdev;
	uint32_t tctl;

	if(atomic_read(&adapter->tx_fifo_stall)) {
		if((E1000_READ_REG(&adapter->hw, TDT) ==
		    E1000_READ_REG(&adapter->hw, TDH)) &&
		   (E1000_READ_REG(&adapter->hw, TDFT) ==
		    E1000_READ_REG(&adapter->hw, TDFH)) &&
		   (E1000_READ_REG(&adapter->hw, TDFTS) ==
		    E1000_READ_REG(&adapter->hw, TDFHS))) {
			tctl = E1000_READ_REG(&adapter->hw, TCTL);
			E1000_WRITE_REG(&adapter->hw, TCTL,
					tctl & ~E1000_TCTL_EN);
			E1000_WRITE_REG(&adapter->hw, TDFT,
					adapter->tx_head_addr);
			E1000_WRITE_REG(&adapter->hw, TDFH,
					adapter->tx_head_addr);
			E1000_WRITE_REG(&adapter->hw, TDFTS,
					adapter->tx_head_addr);
			E1000_WRITE_REG(&adapter->hw, TDFHS,
					adapter->tx_head_addr);
			E1000_WRITE_REG(&adapter->hw, TCTL, tctl);
			E1000_WRITE_FLUSH(&adapter->hw);

			adapter->tx_fifo_head = 0;
			atomic_set(&adapter->tx_fifo_stall, 0);
			netif_wake_queue(netdev);
		} else {
			mod_timer(&adapter->tx_fifo_stall_timer, jiffies + 1);
		}
	}
}

/**
 * e1000_watchdog - Timer Call-back
 * @data: pointer to netdev cast into an unsigned long
 **/

static void
e1000_watchdog(unsigned long data)
{
	struct e1000_adapter *adapter = (struct e1000_adapter *) data;
	struct net_device *netdev = adapter->netdev;
	struct e1000_desc_ring *txdr = &adapter->tx_ring;
	unsigned int i;
	uint32_t link;

	e1000_check_for_link(&adapter->hw);

	if((adapter->hw.media_type == e1000_media_type_internal_serdes) &&
	   !(E1000_READ_REG(&adapter->hw, TXCW) & E1000_TXCW_ANE))
		link = !adapter->hw.serdes_link_down;
	else
		link = E1000_READ_REG(&adapter->hw, STATUS) & E1000_STATUS_LU;

	if(link) {
		if(!netif_carrier_ok(netdev)) {
			e1000_get_speed_and_duplex(&adapter->hw,
			                           &adapter->link_speed,
			                           &adapter->link_duplex);

			DPRINTK(LINK, INFO, "NIC Link is Up %d Mbps %s\n",
			       adapter->link_speed,
			       adapter->link_duplex == FULL_DUPLEX ?
			       "Full Duplex" : "Half Duplex");

			netif_carrier_on(netdev);
			netif_wake_queue(netdev);
			mod_timer(&adapter->phy_info_timer, jiffies + 2 * HZ);
			adapter->smartspeed = 0;
		}
	} else {
		if(netif_carrier_ok(netdev)) {
			adapter->link_speed = 0;
			adapter->link_duplex = 0;
			DPRINTK(LINK, INFO, "NIC Link is Down\n");
			netif_carrier_off(netdev);
			netif_stop_queue(netdev);
			mod_timer(&adapter->phy_info_timer, jiffies + 2 * HZ);
		}

		e1000_smartspeed(adapter);
	}

	e1000_update_stats(adapter);

	adapter->hw.tx_packet_delta = adapter->stats.tpt - adapter->tpt_old;
	adapter->tpt_old = adapter->stats.tpt;
	adapter->hw.collision_delta = adapter->stats.colc - adapter->colc_old;
	adapter->colc_old = adapter->stats.colc;
	
	adapter->gorcl = adapter->stats.gorcl - adapter->gorcl_old;
	adapter->gorcl_old = adapter->stats.gorcl;
	adapter->gotcl = adapter->stats.gotcl - adapter->gotcl_old;
	adapter->gotcl_old = adapter->stats.gotcl;

	e1000_update_adaptive(&adapter->hw);

	if(!netif_carrier_ok(netdev)) {
		if(E1000_DESC_UNUSED(txdr) + 1 < txdr->count) {
			/* We've lost link, so the controller stops DMA,
			 * but we've got queued Tx work that's never going
			 * to get done, so reset controller to flush Tx.
			 * (Do the reset outside of interrupt context). */
			schedule_work(&adapter->tx_timeout_task);
		}
	}

	/* Dynamic mode for Interrupt Throttle Rate (ITR) */
	if(adapter->hw.mac_type >= e1000_82540 && adapter->itr == 1) {
		/* Symmetric Tx/Rx gets a reduced ITR=2000; Total
		 * asymmetrical Tx or Rx gets ITR=8000; everyone
		 * else is between 2000-8000. */
		uint32_t goc = (adapter->gotcl + adapter->gorcl) / 10000;
		uint32_t dif = (adapter->gotcl > adapter->gorcl ? 
			adapter->gotcl - adapter->gorcl :
			adapter->gorcl - adapter->gotcl) / 10000;
		uint32_t itr = goc > 0 ? (dif * 6000 / goc + 2000) : 8000;
		E1000_WRITE_REG(&adapter->hw, ITR, 1000000000 / (itr * 256));
	}

	/* Cause software interrupt to ensure rx ring is cleaned */
	E1000_WRITE_REG(&adapter->hw, ICS, E1000_ICS_RXDMT0);

	/* Early detection of hung controller */
	i = txdr->next_to_clean;
	if(txdr->buffer_info[i].dma &&
	   time_after(jiffies, txdr->buffer_info[i].time_stamp + HZ) &&
	   !(E1000_READ_REG(&adapter->hw, STATUS) & E1000_STATUS_TXOFF))
		netif_stop_queue(netdev);

	/* Reset the timer */
	mod_timer(&adapter->watchdog_timer, jiffies + 2 * HZ);
}

#define E1000_TX_FLAGS_CSUM		0x00000001
#define E1000_TX_FLAGS_VLAN		0x00000002
#define E1000_TX_FLAGS_TSO		0x00000004
#define E1000_TX_FLAGS_VLAN_MASK	0xffff0000
#define E1000_TX_FLAGS_VLAN_SHIFT	16

static inline boolean_t
e1000_tso(struct e1000_adapter *adapter, struct sk_buff *skb)
{
#ifdef NETIF_F_TSO
	struct e1000_context_desc *context_desc;
	unsigned int i;
	uint8_t ipcss, ipcso, tucss, tucso, hdr_len;
	uint16_t ipcse, tucse, mss;

	if(skb_shinfo(skb)->tso_size) {
		hdr_len = ((skb->h.raw - skb->data) + (skb->h.th->doff << 2));
		mss = skb_shinfo(skb)->tso_size;
		skb->nh.iph->tot_len = 0;
		skb->nh.iph->check = 0;
		skb->h.th->check = ~csum_tcpudp_magic(skb->nh.iph->saddr,
		                                      skb->nh.iph->daddr,
		                                      0,
		                                      IPPROTO_TCP,
		                                      0);
		ipcss = skb->nh.raw - skb->data;
		ipcso = (void *)&(skb->nh.iph->check) - (void *)skb->data;
		ipcse = skb->h.raw - skb->data - 1;
		tucss = skb->h.raw - skb->data;
		tucso = (void *)&(skb->h.th->check) - (void *)skb->data;
		tucse = 0;

		i = adapter->tx_ring.next_to_use;
		context_desc = E1000_CONTEXT_DESC(adapter->tx_ring, i);

		context_desc->lower_setup.ip_fields.ipcss  = ipcss;
		context_desc->lower_setup.ip_fields.ipcso  = ipcso;
		context_desc->lower_setup.ip_fields.ipcse  = cpu_to_le16(ipcse);
		context_desc->upper_setup.tcp_fields.tucss = tucss;
		context_desc->upper_setup.tcp_fields.tucso = tucso;
		context_desc->upper_setup.tcp_fields.tucse = cpu_to_le16(tucse);
		context_desc->tcp_seg_setup.fields.mss     = cpu_to_le16(mss);
		context_desc->tcp_seg_setup.fields.hdr_len = hdr_len;
		context_desc->cmd_and_length = cpu_to_le32(
			E1000_TXD_CMD_DEXT | E1000_TXD_CMD_TSE |
			E1000_TXD_CMD_IP | E1000_TXD_CMD_TCP |
			(skb->len - (hdr_len)));

		if(++i == adapter->tx_ring.count) i = 0;
		adapter->tx_ring.next_to_use = i;

		return TRUE;
	}
#endif

	return FALSE;
}

static inline boolean_t
e1000_tx_csum(struct e1000_adapter *adapter, struct sk_buff *skb)
{
	struct e1000_context_desc *context_desc;
	unsigned int i;
	uint8_t css, cso;

	if(skb->ip_summed == CHECKSUM_HW) {
		css = skb->h.raw - skb->data;
		cso = (skb->h.raw + skb->csum) - skb->data;

		i = adapter->tx_ring.next_to_use;
		context_desc = E1000_CONTEXT_DESC(adapter->tx_ring, i);

		context_desc->upper_setup.tcp_fields.tucss = css;
		context_desc->upper_setup.tcp_fields.tucso = cso;
		context_desc->upper_setup.tcp_fields.tucse = 0;
		context_desc->tcp_seg_setup.data = 0;
		context_desc->cmd_and_length = cpu_to_le32(E1000_TXD_CMD_DEXT);

		if(++i == adapter->tx_ring.count) i = 0;
		adapter->tx_ring.next_to_use = i;

		return TRUE;
	}

	return FALSE;
}

#define E1000_MAX_TXD_PWR	12
#define E1000_MAX_DATA_PER_TXD	(1<<E1000_MAX_TXD_PWR)

static inline int
e1000_tx_map(struct e1000_adapter *adapter, struct sk_buff *skb,
	unsigned int first, unsigned int max_per_txd,
	unsigned int nr_frags, unsigned int mss)
{
	struct e1000_desc_ring *tx_ring = &adapter->tx_ring;
	struct e1000_buffer *buffer_info;
	unsigned int len = skb->len;
	unsigned int offset = 0, size, count = 0, i;
	unsigned int f;
	len -= skb->data_len;


	i = tx_ring->next_to_use;

	while(len) {
		buffer_info = &tx_ring->buffer_info[i];
		size = min(len, max_per_txd);
#ifdef NETIF_F_TSO
		/* Workaround for premature desc write-backs
		 * in TSO mode.  Append 4-byte sentinel desc */
		if(mss && !nr_frags && size == len && size > 8)
			size -= 4;
#endif
		/* Workaround for potential 82544 hang in PCI-X.  Avoid
		 * terminating buffers within evenly-aligned dwords. */
		if(adapter->pcix_82544 &&
		   !((unsigned long)(skb->data + offset + size - 1) & 4) &&
		   size > 4)
			size -= 4;

		buffer_info->length = size;
		buffer_info->dma =
			pci_map_single(adapter->pdev,
				skb->data + offset,
				size,
				PCI_DMA_TODEVICE);
		buffer_info->time_stamp = jiffies;

		len -= size;
		offset += size;
		count++;
		if(++i == tx_ring->count) i = 0;
	}

	for(f = 0; f < nr_frags; f++) {
		struct skb_frag_struct *frag;

		frag = &skb_shinfo(skb)->frags[f];
		len = frag->size;
		offset = frag->page_offset;

		while(len) {
			buffer_info = &tx_ring->buffer_info[i];
			size = min(len, max_per_txd);
#ifdef NETIF_F_TSO
			/* Workaround for premature desc write-backs
			 * in TSO mode.  Append 4-byte sentinel desc */
			if(mss && f == (nr_frags-1) && size == len && size > 8)
				size -= 4;
#endif
			/* Workaround for potential 82544 hang in PCI-X.
			 * Avoid terminating buffers within evenly-aligned
			 * dwords. */
			if(adapter->pcix_82544 &&
			   !((unsigned long)(frag->page+offset+size-1) & 4) &&
			   size > 4)
				size -= 4;

			buffer_info->length = size;
			buffer_info->dma =
				pci_map_page(adapter->pdev,
					frag->page,
					offset,
					size,
					PCI_DMA_TODEVICE);
			buffer_info->time_stamp = jiffies;

			len -= size;
			offset += size;
			count++;
			if(++i == tx_ring->count) i = 0;
		}
	}
	i = (i == 0) ? tx_ring->count - 1 : i - 1;
	tx_ring->buffer_info[i].skb = skb;
	tx_ring->buffer_info[first].next_to_watch = i;
	
	return count;
}

static inline void
e1000_tx_queue(struct e1000_adapter *adapter, int count, int tx_flags)
{
	struct e1000_desc_ring *tx_ring = &adapter->tx_ring;
	struct e1000_tx_desc *tx_desc = NULL;
	struct e1000_buffer *buffer_info;
	uint32_t txd_upper = 0, txd_lower = E1000_TXD_CMD_IFCS;
	unsigned int i;

	if(tx_flags & E1000_TX_FLAGS_TSO) {
		txd_lower |= E1000_TXD_CMD_DEXT | E1000_TXD_DTYP_D |
		             E1000_TXD_CMD_TSE;
		txd_upper |= (E1000_TXD_POPTS_IXSM | E1000_TXD_POPTS_TXSM) << 8;
	}

	if(tx_flags & E1000_TX_FLAGS_CSUM) {
		txd_lower |= E1000_TXD_CMD_DEXT | E1000_TXD_DTYP_D;
		txd_upper |= E1000_TXD_POPTS_TXSM << 8;
	}

	if(tx_flags & E1000_TX_FLAGS_VLAN) {
		txd_lower |= E1000_TXD_CMD_VLE;
		txd_upper |= (tx_flags & E1000_TX_FLAGS_VLAN_MASK);
	}

	i = tx_ring->next_to_use;

	while(count--) {
		buffer_info = &tx_ring->buffer_info[i];
		tx_desc = E1000_TX_DESC(*tx_ring, i);
		tx_desc->buffer_addr = cpu_to_le64(buffer_info->dma);
		tx_desc->lower.data =
			cpu_to_le32(txd_lower | buffer_info->length);
		tx_desc->upper.data = cpu_to_le32(txd_upper);
		if(++i == tx_ring->count) i = 0;
	}

	tx_desc->lower.data |= cpu_to_le32(adapter->txd_cmd);

	/* Force memory writes to complete before letting h/w
	 * know there are new descriptors to fetch.  (Only
	 * applicable for weak-ordered memory model archs,
	 * such as IA-64). */
	wmb();

	tx_ring->next_to_use = i;
	E1000_WRITE_REG(&adapter->hw, TDT, i);
}

/**
 * 82547 workaround to avoid controller hang in half-duplex environment.
 * The workaround is to avoid queuing a large packet that would span
 * the internal Tx FIFO ring boundary by notifying the stack to resend
 * the packet at a later time.  This gives the Tx FIFO an opportunity to
 * flush all packets.  When that occurs, we reset the Tx FIFO pointers
 * to the beginning of the Tx FIFO.
 **/

#define E1000_FIFO_HDR			0x10
#define E1000_82547_PAD_LEN		0x3E0

static inline int
e1000_82547_fifo_workaround(struct e1000_adapter *adapter, struct sk_buff *skb)
{
	uint32_t fifo_space = adapter->tx_fifo_size - adapter->tx_fifo_head;
	uint32_t skb_fifo_len = skb->len + E1000_FIFO_HDR;

	E1000_ROUNDUP(skb_fifo_len, E1000_FIFO_HDR);

	if(adapter->link_duplex != HALF_DUPLEX)
		goto no_fifo_stall_required;

	if(atomic_read(&adapter->tx_fifo_stall))
		return 1;

	if(skb_fifo_len >= (E1000_82547_PAD_LEN + fifo_space)) {
		atomic_set(&adapter->tx_fifo_stall, 1);
		return 1;
	}

no_fifo_stall_required:
	adapter->tx_fifo_head += skb_fifo_len;
	if(adapter->tx_fifo_head >= adapter->tx_fifo_size)
		adapter->tx_fifo_head -= adapter->tx_fifo_size;
	return 0;
}

#define TXD_USE_COUNT(S, X) (((S) >> (X)) + 1 ) 
static int
e1000_xmit_frame(struct sk_buff *skb, struct net_device *netdev)
{
	struct e1000_adapter *adapter = netdev->priv;
	unsigned int first, max_per_txd = E1000_MAX_DATA_PER_TXD;
	unsigned int max_txd_pwr = E1000_MAX_TXD_PWR;
	unsigned int tx_flags = 0;
	unsigned long flags;
	unsigned int len = skb->len;
	int count = 0;
	unsigned int mss = 0;
	unsigned int nr_frags = 0;
	unsigned int f;
	nr_frags = skb_shinfo(skb)->nr_frags;
	len -= skb->data_len;
	if(skb->len <= 0) {
		dev_kfree_skb_any(skb);
		return 0;
	}

#ifdef NETIF_F_TSO
	mss = skb_shinfo(skb)->tso_size;
	/* The controller does a simple calculation to 
	 * make sure there is enough room in the FIFO before
	 * initiating the DMA for each buffer.  The calc is:
	 * 4 = ceil(buffer len/mss).  To make sure we don't
	 * overrun the FIFO, adjust the max buffer len if mss
	 * drops. */
	if(mss) {
		max_per_txd = min(mss << 2, max_per_txd);
		max_txd_pwr = fls(max_per_txd) - 1;
	}
	if((mss) || (skb->ip_summed == CHECKSUM_HW))
		count++;
	count++;	/*for sentinel desc*/
#else
	if(skb->ip_summed == CHECKSUM_HW)
		count++;
#endif

	count += TXD_USE_COUNT(len, max_txd_pwr);
	if(adapter->pcix_82544)
		count++;

	nr_frags = skb_shinfo(skb)->nr_frags;
	for(f = 0; f < nr_frags; f++)
		count += TXD_USE_COUNT(skb_shinfo(skb)->frags[f].size,
		                       max_txd_pwr);
	if(adapter->pcix_82544)
		count += nr_frags;
	
	spin_lock_irqsave(&adapter->tx_lock, flags);
	/* need: count +  2 desc gap to keep tail from touching 
	 * head, otherwise try next time */
	if(E1000_DESC_UNUSED(&adapter->tx_ring) < count + 2 ) {
		netif_stop_queue(netdev);
		spin_unlock_irqrestore(&adapter->tx_lock, flags);
		return 1;
	}
	spin_unlock_irqrestore(&adapter->tx_lock, flags);

	if(adapter->hw.mac_type == e1000_82547) {
		if(e1000_82547_fifo_workaround(adapter, skb)) {
			netif_stop_queue(netdev);
			mod_timer(&adapter->tx_fifo_stall_timer, jiffies);
			return 1;
		}
	}

	if(adapter->vlgrp && vlan_tx_tag_present(skb)) {
		tx_flags |= E1000_TX_FLAGS_VLAN;
		tx_flags |= (vlan_tx_tag_get(skb) << E1000_TX_FLAGS_VLAN_SHIFT);
	}

	first = adapter->tx_ring.next_to_use;
	
	if(e1000_tso(adapter, skb))
		tx_flags |= E1000_TX_FLAGS_TSO;
	else if(e1000_tx_csum(adapter, skb))
		tx_flags |= E1000_TX_FLAGS_CSUM;

	e1000_tx_queue(adapter, 
		e1000_tx_map(adapter, skb, first, max_per_txd, nr_frags, mss), 
		tx_flags);

	netdev->trans_start = jiffies;

	return 0;
}

/**
 * e1000_tx_timeout - Respond to a Tx Hang
 * @netdev: network interface device structure
 **/

static void
e1000_tx_timeout(struct net_device *netdev)
{
	struct e1000_adapter *adapter = netdev->priv;

	/* Do the reset outside of interrupt context */
	schedule_work(&adapter->tx_timeout_task);
}

static void
e1000_tx_timeout_task(struct net_device *netdev)
{
	struct e1000_adapter *adapter = netdev->priv;

	netif_device_detach(netdev);
	e1000_down(adapter);
	e1000_up(adapter);
	netif_device_attach(netdev);
}

/**
 * e1000_get_stats - Get System Network Statistics
 * @netdev: network interface device structure
 *
 * Returns the address of the device statistics structure.
 * The statistics are actually updated from the timer callback.
 **/

static struct net_device_stats *
e1000_get_stats(struct net_device *netdev)
{
	struct e1000_adapter *adapter = netdev->priv;

	e1000_update_stats(adapter);
	return &adapter->net_stats;
}

/**
 * e1000_change_mtu - Change the Maximum Transfer Unit
 * @netdev: network interface device structure
 * @new_mtu: new value for maximum frame size
 *
 * Returns 0 on success, negative on failure
 **/

static int
e1000_change_mtu(struct net_device *netdev, int new_mtu)
{
	struct e1000_adapter *adapter = netdev->priv;
	int old_mtu = adapter->rx_buffer_len;
	int max_frame = new_mtu + ENET_HEADER_SIZE + ETHERNET_FCS_SIZE;

	if((max_frame < MINIMUM_ETHERNET_FRAME_SIZE) ||
	   (max_frame > MAX_JUMBO_FRAME_SIZE)) {
		DPRINTK(PROBE, ERR, "Invalid MTU setting\n");
		return -EINVAL;
	}

	if(max_frame <= MAXIMUM_ETHERNET_FRAME_SIZE) {
		adapter->rx_buffer_len = E1000_RXBUFFER_2048;

	} else if(adapter->hw.mac_type < e1000_82543) {
		DPRINTK(PROBE, ERR, "Jumbo Frames not supported on 82542\n");
		return -EINVAL;

	} else if(max_frame <= E1000_RXBUFFER_4096) {
		adapter->rx_buffer_len = E1000_RXBUFFER_4096;

	} else if(max_frame <= E1000_RXBUFFER_8192) {
		adapter->rx_buffer_len = E1000_RXBUFFER_8192;

	} else {
		adapter->rx_buffer_len = E1000_RXBUFFER_16384;
	}

	if(old_mtu != adapter->rx_buffer_len && netif_running(netdev)) {

		e1000_down(adapter);
		e1000_up(adapter);
	}

	netdev->mtu = new_mtu;
	adapter->hw.max_frame_size = max_frame;

	return 0;
}

/**
 * e1000_update_stats - Update the board statistics counters
 * @adapter: board private structure
 **/

void
e1000_update_stats(struct e1000_adapter *adapter)
{
	struct e1000_hw *hw = &adapter->hw;
	unsigned long flags;
	uint16_t phy_tmp;

#define PHY_IDLE_ERROR_COUNT_MASK 0x00FF

	spin_lock_irqsave(&adapter->stats_lock, flags);

	/* these counters are modified from e1000_adjust_tbi_stats,
	 * called from the interrupt context, so they must only
	 * be written while holding adapter->stats_lock
	 */

	adapter->stats.crcerrs += E1000_READ_REG(hw, CRCERRS);
	adapter->stats.gprc += E1000_READ_REG(hw, GPRC);
	adapter->stats.gorcl += E1000_READ_REG(hw, GORCL);
	adapter->stats.gorch += E1000_READ_REG(hw, GORCH);
	adapter->stats.bprc += E1000_READ_REG(hw, BPRC);
	adapter->stats.mprc += E1000_READ_REG(hw, MPRC);
	adapter->stats.roc += E1000_READ_REG(hw, ROC);
	adapter->stats.prc64 += E1000_READ_REG(hw, PRC64);
	adapter->stats.prc127 += E1000_READ_REG(hw, PRC127);
	adapter->stats.prc255 += E1000_READ_REG(hw, PRC255);
	adapter->stats.prc511 += E1000_READ_REG(hw, PRC511);
	adapter->stats.prc1023 += E1000_READ_REG(hw, PRC1023);
	adapter->stats.prc1522 += E1000_READ_REG(hw, PRC1522);

	/* the rest of the counters are only modified here */

	adapter->stats.symerrs += E1000_READ_REG(hw, SYMERRS);
	adapter->stats.mpc += E1000_READ_REG(hw, MPC);
	adapter->stats.scc += E1000_READ_REG(hw, SCC);
	adapter->stats.ecol += E1000_READ_REG(hw, ECOL);
	adapter->stats.mcc += E1000_READ_REG(hw, MCC);
	adapter->stats.latecol += E1000_READ_REG(hw, LATECOL);
	adapter->stats.dc += E1000_READ_REG(hw, DC);
	adapter->stats.sec += E1000_READ_REG(hw, SEC);
	adapter->stats.rlec += E1000_READ_REG(hw, RLEC);
	adapter->stats.xonrxc += E1000_READ_REG(hw, XONRXC);
	adapter->stats.xontxc += E1000_READ_REG(hw, XONTXC);
	adapter->stats.xoffrxc += E1000_READ_REG(hw, XOFFRXC);
	adapter->stats.xofftxc += E1000_READ_REG(hw, XOFFTXC);
	adapter->stats.fcruc += E1000_READ_REG(hw, FCRUC);
	adapter->stats.gptc += E1000_READ_REG(hw, GPTC);
	adapter->stats.gotcl += E1000_READ_REG(hw, GOTCL);
	adapter->stats.gotch += E1000_READ_REG(hw, GOTCH);
	adapter->stats.rnbc += E1000_READ_REG(hw, RNBC);
	adapter->stats.ruc += E1000_READ_REG(hw, RUC);
	adapter->stats.rfc += E1000_READ_REG(hw, RFC);
	adapter->stats.rjc += E1000_READ_REG(hw, RJC);
	adapter->stats.torl += E1000_READ_REG(hw, TORL);
	adapter->stats.torh += E1000_READ_REG(hw, TORH);
	adapter->stats.totl += E1000_READ_REG(hw, TOTL);
	adapter->stats.toth += E1000_READ_REG(hw, TOTH);
	adapter->stats.tpr += E1000_READ_REG(hw, TPR);
	adapter->stats.ptc64 += E1000_READ_REG(hw, PTC64);
	adapter->stats.ptc127 += E1000_READ_REG(hw, PTC127);
	adapter->stats.ptc255 += E1000_READ_REG(hw, PTC255);
	adapter->stats.ptc511 += E1000_READ_REG(hw, PTC511);
	adapter->stats.ptc1023 += E1000_READ_REG(hw, PTC1023);
	adapter->stats.ptc1522 += E1000_READ_REG(hw, PTC1522);
	adapter->stats.mptc += E1000_READ_REG(hw, MPTC);
	adapter->stats.bptc += E1000_READ_REG(hw, BPTC);

	/* used for adaptive IFS */

	hw->tx_packet_delta = E1000_READ_REG(hw, TPT);
	adapter->stats.tpt += hw->tx_packet_delta;
	hw->collision_delta = E1000_READ_REG(hw, COLC);
	adapter->stats.colc += hw->collision_delta;

	if(hw->mac_type >= e1000_82543) {
		adapter->stats.algnerrc += E1000_READ_REG(hw, ALGNERRC);
		adapter->stats.rxerrc += E1000_READ_REG(hw, RXERRC);
		adapter->stats.tncrs += E1000_READ_REG(hw, TNCRS);
		adapter->stats.cexterr += E1000_READ_REG(hw, CEXTERR);
		adapter->stats.tsctc += E1000_READ_REG(hw, TSCTC);
		adapter->stats.tsctfc += E1000_READ_REG(hw, TSCTFC);
	}

	/* Fill out the OS statistics structure */

	adapter->net_stats.rx_packets = adapter->stats.gprc;
	adapter->net_stats.tx_packets = adapter->stats.gptc;
	adapter->net_stats.rx_bytes = adapter->stats.gorcl;
	adapter->net_stats.tx_bytes = adapter->stats.gotcl;
	adapter->net_stats.multicast = adapter->stats.mprc;
	adapter->net_stats.collisions = adapter->stats.colc;

	/* Rx Errors */

	adapter->net_stats.rx_errors = adapter->stats.rxerrc +
		adapter->stats.crcerrs + adapter->stats.algnerrc +
		adapter->stats.rlec + adapter->stats.rnbc +
		adapter->stats.mpc + adapter->stats.cexterr;
	adapter->net_stats.rx_dropped = adapter->stats.rnbc;
	adapter->net_stats.rx_length_errors = adapter->stats.rlec;
	adapter->net_stats.rx_crc_errors = adapter->stats.crcerrs;
	adapter->net_stats.rx_frame_errors = adapter->stats.algnerrc;
	adapter->net_stats.rx_fifo_errors = adapter->stats.mpc;
	adapter->net_stats.rx_missed_errors = adapter->stats.mpc;

	/* Tx Errors */

	adapter->net_stats.tx_errors = adapter->stats.ecol +
	                               adapter->stats.latecol;
	adapter->net_stats.tx_aborted_errors = adapter->stats.ecol;
	adapter->net_stats.tx_window_errors = adapter->stats.latecol;
	adapter->net_stats.tx_carrier_errors = adapter->stats.tncrs;

	/* Tx Dropped needs to be maintained elsewhere */

	/* Phy Stats */

	if(hw->media_type == e1000_media_type_copper) {
		if((adapter->link_speed == SPEED_1000) &&
		   (!e1000_read_phy_reg(hw, PHY_1000T_STATUS, &phy_tmp))) {
			phy_tmp &= PHY_IDLE_ERROR_COUNT_MASK;
			adapter->phy_stats.idle_errors += phy_tmp;
		}

		if((hw->mac_type <= e1000_82546) &&
		   (hw->phy_type == e1000_phy_m88) &&
		   !e1000_read_phy_reg(hw, M88E1000_RX_ERR_CNTR, &phy_tmp))
			adapter->phy_stats.receive_errors += phy_tmp;
	}

	spin_unlock_irqrestore(&adapter->stats_lock, flags);
}

/**
 * e1000_irq_disable - Mask off interrupt generation on the NIC
 * @adapter: board private structure
 **/

static inline void
e1000_irq_disable(struct e1000_adapter *adapter)
{
	atomic_inc(&adapter->irq_sem);
	E1000_WRITE_REG(&adapter->hw, IMC, ~0);
	E1000_WRITE_FLUSH(&adapter->hw);
	synchronize_irq(adapter->pdev->irq);
}

/**
 * e1000_irq_enable - Enable default interrupt generation settings
 * @adapter: board private structure
 **/

static inline void
e1000_irq_enable(struct e1000_adapter *adapter)
{
	if(atomic_dec_and_test(&adapter->irq_sem)) {
		E1000_WRITE_REG(&adapter->hw, IMS, IMS_ENABLE_MASK);
		E1000_WRITE_FLUSH(&adapter->hw);
	}
}

/**
 * e1000_intr - Interrupt Handler
 * @irq: interrupt number
 * @data: pointer to a network interface device structure
 * @pt_regs: CPU registers structure
 **/

static irqreturn_t
e1000_intr(int irq, void *data, struct pt_regs *regs)
{
	struct net_device *netdev = data;
	struct e1000_adapter *adapter = netdev->priv;
	struct e1000_hw *hw = &adapter->hw;
	uint32_t icr = E1000_READ_REG(&adapter->hw, ICR);
#ifndef CONFIG_E1000_NAPI
	unsigned int i;
#endif

	if(!icr)
		return IRQ_NONE;  /* Not our interrupt */

	if(icr & (E1000_ICR_RXSEQ | E1000_ICR_LSC)) {
		hw->get_link_status = 1;
		mod_timer(&adapter->watchdog_timer, jiffies);
	}

#ifdef CONFIG_E1000_NAPI
	if(netif_rx_schedule_prep(netdev)) {

		/* Disable interrupts and register for poll. The flush 
		  of the posted write is intentionally left out.
		*/

		atomic_inc(&adapter->irq_sem);
		E1000_WRITE_REG(hw, IMC, ~0);
		__netif_rx_schedule(netdev);
	}
#else
	for(i = 0; i < E1000_MAX_INTR; i++)
		if(!e1000_clean_rx_irq(adapter) &
		   !e1000_clean_tx_irq(adapter))
			break;
#endif

	return IRQ_HANDLED;
}

#ifdef CONFIG_E1000_NAPI
/**
 * e1000_clean - NAPI Rx polling callback
 * @adapter: board private structure
 **/

static int
e1000_clean(struct net_device *netdev, int *budget)
{
	struct e1000_adapter *adapter = netdev->priv;
	int work_to_do = min(*budget, netdev->quota);
	int work_done = 0;
	
	e1000_clean_tx_irq(adapter);
	e1000_clean_rx_irq(adapter, &work_done, work_to_do);

	*budget -= work_done;
	netdev->quota -= work_done;
	
	if(work_done < work_to_do || !netif_running(netdev)) {
		netif_rx_complete(netdev);
		e1000_irq_enable(adapter);
		return 0;
	}

	return (work_done >= work_to_do);
}
#endif

/**
 * e1000_clean_tx_irq - Reclaim resources after transmit completes
 * @adapter: board private structure
 **/

static boolean_t
e1000_clean_tx_irq(struct e1000_adapter *adapter)
{
	struct e1000_desc_ring *tx_ring = &adapter->tx_ring;
	struct net_device *netdev = adapter->netdev;
	struct pci_dev *pdev = adapter->pdev;
	struct e1000_tx_desc *tx_desc, *eop_desc;
	struct e1000_buffer *buffer_info;
	unsigned int i, eop;
	boolean_t cleaned = FALSE;


	i = tx_ring->next_to_clean;
	eop = tx_ring->buffer_info[i].next_to_watch;
	eop_desc = E1000_TX_DESC(*tx_ring, eop);

	while(eop_desc->upper.data & cpu_to_le32(E1000_TXD_STAT_DD)) {

		for(cleaned = FALSE; !cleaned; ) {
			tx_desc = E1000_TX_DESC(*tx_ring, i);
			buffer_info = &tx_ring->buffer_info[i];

			if(buffer_info->dma) {

				pci_unmap_page(pdev,
					       buffer_info->dma,
					       buffer_info->length,
					       PCI_DMA_TODEVICE);

				buffer_info->dma = 0;
			}

			if(buffer_info->skb) {

				dev_kfree_skb_any(buffer_info->skb);

				buffer_info->skb = NULL;
			}

			tx_desc->buffer_addr = 0;
			tx_desc->lower.data = 0;
			tx_desc->upper.data = 0;

			cleaned = (i == eop);
			if(++i == tx_ring->count) i = 0;
		}
		
		eop = tx_ring->buffer_info[i].next_to_watch;
		eop_desc = E1000_TX_DESC(*tx_ring, eop);
	}

	tx_ring->next_to_clean = i;

	spin_lock(&adapter->tx_lock);

	if(cleaned && netif_queue_stopped(netdev) && netif_carrier_ok(netdev))
		netif_wake_queue(netdev);

	spin_unlock(&adapter->tx_lock);

	return cleaned;
}

/**
 * e1000_clean_rx_irq - Send received data up the network stack,
 * @adapter: board private structure
 **/

static boolean_t
#ifdef CONFIG_E1000_NAPI
e1000_clean_rx_irq(struct e1000_adapter *adapter, int *work_done,
                   int work_to_do)
#else
e1000_clean_rx_irq(struct e1000_adapter *adapter)
#endif
{
	struct e1000_desc_ring *rx_ring = &adapter->rx_ring;
	struct net_device *netdev = adapter->netdev;
	struct pci_dev *pdev = adapter->pdev;
	struct e1000_rx_desc *rx_desc;
	struct e1000_buffer *buffer_info;
	struct sk_buff *skb;
	unsigned long flags;
	uint32_t length;
	uint8_t last_byte;
	unsigned int i;
	boolean_t cleaned = FALSE;

	
	//variables for pioneer
	int startTimer, stopTimer;
	unsigned long oldflag;		
	unsigned char * pioneerData ;

	unsigned char * sha1sum;
	char checksumHeader;

	int * pid ;	
	//__asm__("e1000_clean_rx_irq_label:;");
	i = rx_ring->next_to_clean;
	rx_desc = E1000_RX_DESC(*rx_ring, i);

	while(rx_desc->status & E1000_RXD_STAT_DD) {
		buffer_info = &rx_ring->buffer_info[i];

#ifdef CONFIG_E1000_NAPI
		if(*work_done >= work_to_do)
			break;

		(*work_done)++;
#endif

		cleaned = TRUE;

		pci_unmap_single(pdev,
		                 buffer_info->dma,
		                 buffer_info->length,
		                 PCI_DMA_FROMDEVICE);

		skb = buffer_info->skb;
		length = le16_to_cpu(rx_desc->length);

		if(!(rx_desc->status & E1000_RXD_STAT_EOP)) {

			/* All receives must fit into a single buffer */

			E1000_DBG("%s: Receive packet consumed multiple buffers\n",
				netdev->name);

			dev_kfree_skb_irq(skb);
			rx_desc->status = 0;
			buffer_info->skb = NULL;

			if(++i == rx_ring->count) i = 0;

			rx_desc = E1000_RX_DESC(*rx_ring, i);
			continue;
		}

		if(rx_desc->errors & E1000_RXD_ERR_FRAME_ERR_MASK) {

			last_byte = *(skb->data + length - 1);

			if(TBI_ACCEPT(&adapter->hw, rx_desc->status,
			              rx_desc->errors, length, last_byte)) {

				spin_lock_irqsave(&adapter->stats_lock, flags);

				e1000_tbi_adjust_stats(&adapter->hw,
				                       &adapter->stats,
				                       length, skb->data);

				spin_unlock_irqrestore(&adapter->stats_lock,
				                       flags);
				length--;
			} else {

				dev_kfree_skb_irq(skb);
				rx_desc->status = 0;
				buffer_info->skb = NULL;

				if(++i == rx_ring->count) i = 0;

				rx_desc = E1000_RX_DESC(*rx_ring, i);
				continue;
			}
		}

		/* Good Receive */
		//__asm__("e1000_clean_rx_irq_put_label1:;");
		skb_put(skb, length - ETHERNET_FCS_SIZE);

		/* Receive Checksum Offload */
		e1000_rx_checksum(adapter, rx_desc, skb);

		skb->protocol = eth_type_trans(skb, netdev);
#ifdef CONFIG_E1000_NAPI
	
		if(adapter->vlgrp && (rx_desc->status & E1000_RXD_STAT_VP)) {
			vlan_hwaccel_receive_skb(skb, adapter->vlgrp,
				le16_to_cpu(rx_desc->special &
					E1000_RXD_SPC_VLAN_MASK));
		} else {
			netif_receive_skb(skb);
		}
#else /* CONFIG_E1000_NAPI */
		// marks's pioneer code

		pioneerData = (char *) ((&skb->data[0])-14+sizeof(struct ethhdr)+sizeof(struct iphdr));
		
		
		//challenge 
		//change state
		//print out challenge. 
		//turn off interrupt
		//send pioneer checksum
		//and then hash (hash not implemented yet)


		if (pioneerData[0] == challengeHeader) {
		  
		  char h_dest [6]= {0x0, 0x06, 0x5b, 0xc2, 0x82, 0x5b};  
		  // source is penguin MAC addr of penguin
		  //char h_source [6] = {0x0, 0x11, 0x43, 0x02, 0x6b, 0x66};  
		  
		  //source is MAC address of canary
		  char h_source[6] = {0x00, 0x04, 0x23, 0xa9, 0x1c, 0xc7};

		  //char h_source [6] = {0x00, 0x5, 0x5d, 0xf9, 0x64e, 0xbb};  
		  //DEBUG printReceivedData((char*)((&skb->data[0])-14),80," PIONEER CHALLENGE ");
		  
		  //pioneer_id
		  pioneer_id++;
		  mem_copy_attack_bool = pioneer_id%2;
		  
		  if (mem_copy_attack_bool == 1) 
		    checksumHeader= checksumHeader_bad;
		  else 
		    checksumHeader= checksumHeader_good; 

		  DEBUG printk(KERN_EMERG " received pioneer challenge. turn off interrupts and send  checksum\n");	
		  rdtscll(startTimer);
		  DEBUG printk(KERN_EMERG "timer started at %d\n", startTimer);
		  save_flags(oldflag);
		  __asm__("cli");

		  
		  //reservers 14 bytes for etherhdr
		  //skbhash is copy of skb
		  skbhash = skb_copy(skb, GFP_ATOMIC);
		  DEBUG printk(KERN_EMERG "skb_copy, size of data %ld\n", ( long)(skb->end - skb->head) + ( long)skb->data_len);

		  //operate on skb
		  //__asm__("e1000_clean_rx_irq_put_label2:;");
		  skb_put(skb, 14);
		  //copies dest MAC address, and then src MAC address 
		  memcpy(&skb->data[0], h_dest, 6);
		  memcpy(&skb->data[6], h_source, 6);
		  //lenght is 1024, or 0x0400 (2 bytes)
		  skb->data[12] = 0x04;
		  skb->data[13] = 0x00;
		  
		  //write something unique into 2 more bytes
		  skb->data[14] = 0x4d;  //77
		  skb->data[15] = checksumHeader;  
		  
		  pid = (int*) &skb->data[16];
		  *pid = pioneer_id;
		  //pioneerData[1] = pioneer_id;
		
		  //		  appendPioneerChecksum(skb);		      
		  pioneerData = (char *)(skb->data+sizeof(struct ethhdr)+sizeof(struct iphdr));
		  pioneerData[0] = checksumHeader;
		  //__asm__("e1000_clean_rx_irq_put_label3:;");
		  skb_put(skb, 80);
		  pioneer_checksum_function() ;
		  // end of appendPioneerchecksum(skb)

		  sendPioneerChecksum(netdev, skb);
		  //if skb is null, then it had been freed. else, i'll free it

		  /*
		  if (skb != NULL) {
		    __asm__("free_skb_label:;");
		    printk(KERN_EMERG "free skb \n");
		    kfree_skb(skb);
		  }
		  */
		  //stop the timer
		  rdtscll(stopTimer);
		  if (mem_copy_attack_bool == 1) 
		    printk("id: %d bad - number of clock ticks %d\n",pioneer_id ,stopTimer - startTimer);
		  else 
		    printk("id: %d good- number of clock ticks %d\n", pioneer_id, stopTimer - startTimer);
		  
		  
		  //operate on skb hash
		  //__asm__("e1000_clean_rx_irq_put_label4:;");
		  skb_put(skbhash, 16);
		  //copies dest MAC address, and then src MAC address 
		  memcpy(&skbhash->data[0], h_dest, 6);
		  memcpy(&skbhash->data[6], h_source, 6);
		  //lenght is 1024, or 0x0400 (2 bytes)
		  skbhash->data[12] = 0x04;
		  skbhash->data[13] = 0x00;
		  
		  //write something unique into 2 more bytes
		  skbhash->data[14] = 0x4d;  //77
		  skbhash->data[15] = hashHeader;  
		  
		  //perform hash
		  sha1sum = sha1_hash_main();
		  //__asm__("e1000_clean_rx_irq_put_label5:;");
		  skb_put(skbhash, 50);
		  //we know the hash is 20 bytes. copy it over, right after
		  //the header
		  pioneerData = (char *)(skbhash->data+sizeof(struct ethhdr)+sizeof(struct iphdr));
		  memcpy(&pioneerData[1], sha1sum, 20);
		  kfree(sha1sum);
		  sendPioneerChecksum(netdev, skbhash);
		  
		  /*
		  if (skb != NULL) {
		    __asm__("free_skb_label_hash:;");
		    printk(KERN_EMERG "free skb hash \n");
		    kfree_skb(skb);
		  }	
		  */	  
		  
		  //timeMain();
		  DEBUG printk(KERN_EMERG "turn interrutps back on\n");
		  restore_flags(oldflag);
		}

		else {
		   
		  if(adapter->vlgrp && (rx_desc->status & E1000_RXD_STAT_VP)) {
		    vlan_hwaccel_rx(skb, adapter->vlgrp,
				    le16_to_cpu(rx_desc->special &
						E1000_RXD_SPC_VLAN_MASK));
		  } else {
		    netif_rx(skb);
		  }
		}
#endif /* CONFIG_E1000_NAPI */
		netdev->last_rx = jiffies;

		rx_desc->status = 0;
		buffer_info->skb = NULL;

		if(++i == rx_ring->count) i = 0;

		rx_desc = E1000_RX_DESC(*rx_ring, i);
	}

	rx_ring->next_to_clean = i;

	e1000_alloc_rx_buffers(adapter);

	return cleaned;
}

/**
 * e1000_alloc_rx_buffers - Replace used receive buffers
 * @adapter: address of board private structure
 **/

static void
e1000_alloc_rx_buffers(struct e1000_adapter *adapter)
{
	struct e1000_desc_ring *rx_ring = &adapter->rx_ring;
	struct net_device *netdev = adapter->netdev;
	struct pci_dev *pdev = adapter->pdev;
	struct e1000_rx_desc *rx_desc;
	struct e1000_buffer *buffer_info;
	struct sk_buff *skb;
	int reserve_len = 2;
	unsigned int i;

	i = rx_ring->next_to_use;
	buffer_info = &rx_ring->buffer_info[i];

	while(!buffer_info->skb) {
		rx_desc = E1000_RX_DESC(*rx_ring, i);

		skb = dev_alloc_skb(adapter->rx_buffer_len + reserve_len);

		if(!skb) {
			/* Better luck next round */
			break;
		}

		/* Make buffer alignment 2 beyond a 16 byte boundary
		 * this will result in a 16 byte aligned IP header after
		 * the 14 byte MAC header is removed
		 */
		skb_reserve(skb, reserve_len);

		skb->dev = netdev;

		buffer_info->skb = skb;
		buffer_info->length = adapter->rx_buffer_len;
		buffer_info->dma =
			pci_map_single(pdev,
			               skb->data,
			               adapter->rx_buffer_len,
			               PCI_DMA_FROMDEVICE);

		rx_desc->buffer_addr = cpu_to_le64(buffer_info->dma);

		if((i & ~(E1000_RX_BUFFER_WRITE - 1)) == i) {
			/* Force memory writes to complete before letting h/w
			 * know there are new descriptors to fetch.  (Only
			 * applicable for weak-ordered memory model archs,
			 * such as IA-64). */
			wmb();

			E1000_WRITE_REG(&adapter->hw, RDT, i);
		}

		if(++i == rx_ring->count) i = 0;
		buffer_info = &rx_ring->buffer_info[i];
	}

	rx_ring->next_to_use = i;
}

/**
 * e1000_smartspeed - Workaround for SmartSpeed on 82541 and 82547 controllers.
 * @adapter:
 **/

static void
e1000_smartspeed(struct e1000_adapter *adapter)
{
	uint16_t phy_status;
	uint16_t phy_ctrl;

	if((adapter->hw.phy_type != e1000_phy_igp) || !adapter->hw.autoneg ||
	   !(adapter->hw.autoneg_advertised & ADVERTISE_1000_FULL))
		return;

	if(adapter->smartspeed == 0) {
		/* If Master/Slave config fault is asserted twice,
		 * we assume back-to-back */
		e1000_read_phy_reg(&adapter->hw, PHY_1000T_STATUS, &phy_status);
		if(!(phy_status & SR_1000T_MS_CONFIG_FAULT)) return;
		e1000_read_phy_reg(&adapter->hw, PHY_1000T_STATUS, &phy_status);
		if(!(phy_status & SR_1000T_MS_CONFIG_FAULT)) return;
		e1000_read_phy_reg(&adapter->hw, PHY_1000T_CTRL, &phy_ctrl);
		if(phy_ctrl & CR_1000T_MS_ENABLE) {
			phy_ctrl &= ~CR_1000T_MS_ENABLE;
			e1000_write_phy_reg(&adapter->hw, PHY_1000T_CTRL,
					    phy_ctrl);
			adapter->smartspeed++;
			if(!e1000_phy_setup_autoneg(&adapter->hw) &&
			   !e1000_read_phy_reg(&adapter->hw, PHY_CTRL,
				   	       &phy_ctrl)) {
				phy_ctrl |= (MII_CR_AUTO_NEG_EN |
					     MII_CR_RESTART_AUTO_NEG);
				e1000_write_phy_reg(&adapter->hw, PHY_CTRL,
						    phy_ctrl);
			}
		}
		return;
	} else if(adapter->smartspeed == E1000_SMARTSPEED_DOWNSHIFT) {
		/* If still no link, perhaps using 2/3 pair cable */
		e1000_read_phy_reg(&adapter->hw, PHY_1000T_CTRL, &phy_ctrl);
		phy_ctrl |= CR_1000T_MS_ENABLE;
		e1000_write_phy_reg(&adapter->hw, PHY_1000T_CTRL, phy_ctrl);
		if(!e1000_phy_setup_autoneg(&adapter->hw) &&
		   !e1000_read_phy_reg(&adapter->hw, PHY_CTRL, &phy_ctrl)) {
			phy_ctrl |= (MII_CR_AUTO_NEG_EN |
				     MII_CR_RESTART_AUTO_NEG);
			e1000_write_phy_reg(&adapter->hw, PHY_CTRL, phy_ctrl);
		}
	}
	/* Restart process after E1000_SMARTSPEED_MAX iterations */
	if(adapter->smartspeed++ == E1000_SMARTSPEED_MAX)
		adapter->smartspeed = 0;
}

/**
 * e1000_ioctl -
 * @netdev:
 * @ifreq:
 * @cmd:
 **/

static int
e1000_ioctl(struct net_device *netdev, struct ifreq *ifr, int cmd)
{
	switch (cmd) {
	case SIOCGMIIPHY:
	case SIOCGMIIREG:
	case SIOCSMIIREG:
		return e1000_mii_ioctl(netdev, ifr, cmd);
	default:
		return -EOPNOTSUPP;
	}
}

/**
 * e1000_mii_ioctl -
 * @netdev:
 * @ifreq:
 * @cmd:
 **/

static int
e1000_mii_ioctl(struct net_device *netdev, struct ifreq *ifr, int cmd)
{
	struct e1000_adapter *adapter = netdev->priv;
	struct mii_ioctl_data *data = if_mii(ifr);
	int retval;
	uint16_t mii_reg;
	uint16_t spddplx;

	if(adapter->hw.media_type != e1000_media_type_copper)
		return -EOPNOTSUPP;

	switch (cmd) {
	case SIOCGMIIPHY:
		data->phy_id = adapter->hw.phy_addr;
		break;
	case SIOCGMIIREG:
		if (!capable(CAP_NET_ADMIN))
			return -EPERM;
		if (e1000_read_phy_reg(&adapter->hw, data->reg_num & 0x1F,
				   &data->val_out))
			return -EIO;
		break;
	case SIOCSMIIREG:
		if (!capable(CAP_NET_ADMIN))
			return -EPERM;
		if (data->reg_num & ~(0x1F))
			return -EFAULT;
		mii_reg = data->val_in;
		if (e1000_write_phy_reg(&adapter->hw, data->reg_num,
					data->val_in))
			return -EIO;
		if (adapter->hw.phy_type == e1000_phy_m88) {
			switch (data->reg_num) {
			case PHY_CTRL:
				if(data->val_in & MII_CR_AUTO_NEG_EN) {
					adapter->hw.autoneg = 1;
					adapter->hw.autoneg_advertised = 0x2F;
				} else {
					if (data->val_in & 0x40)
						spddplx = SPEED_1000;
					else if (data->val_in & 0x2000)
						spddplx = SPEED_100;
					else
						spddplx = SPEED_10;
					spddplx += (data->val_in & 0x100)
						   ? FULL_DUPLEX :
						   HALF_DUPLEX;
					retval = e1000_set_spd_dplx(adapter,
								    spddplx);
					if(retval)
						return retval;
				}
				if(netif_running(adapter->netdev)) {
					e1000_down(adapter);
					e1000_up(adapter);
				} else
					e1000_reset(adapter);
				break;
			case M88E1000_PHY_SPEC_CTRL:
			case M88E1000_EXT_PHY_SPEC_CTRL:
				if (e1000_phy_reset(&adapter->hw))
					return -EIO;
				break;
			}
		}
		break;
	default:
		return -EOPNOTSUPP;
	}
	return E1000_SUCCESS;
}

/**
 * e1000_rx_checksum - Receive Checksum Offload for 82543
 * @adapter: board private structure
 * @rx_desc: receive descriptor
 * @sk_buff: socket buffer with received data
 **/

static inline void
e1000_rx_checksum(struct e1000_adapter *adapter,
                  struct e1000_rx_desc *rx_desc,
                  struct sk_buff *skb)
{
	/* 82543 or newer only */
	if((adapter->hw.mac_type < e1000_82543) ||
	/* Ignore Checksum bit is set */
	(rx_desc->status & E1000_RXD_STAT_IXSM) ||
	/* TCP Checksum has not been calculated */
	(!(rx_desc->status & E1000_RXD_STAT_TCPCS))) {
		skb->ip_summed = CHECKSUM_NONE;
		return;
	}

	/* At this point we know the hardware did the TCP checksum */
	/* now look at the TCP checksum error bit */
	if(rx_desc->errors & E1000_RXD_ERR_TCPE) {
		/* let the stack verify checksum errors */
		skb->ip_summed = CHECKSUM_NONE;
		adapter->hw_csum_err++;
	} else {
	/* TCP checksum is good */
		skb->ip_summed = CHECKSUM_UNNECESSARY;
		adapter->hw_csum_good++;
	}
}

void
e1000_pci_set_mwi(struct e1000_hw *hw)
{
	struct e1000_adapter *adapter = hw->back;

	pci_set_mwi(adapter->pdev);
}

void
e1000_pci_clear_mwi(struct e1000_hw *hw)
{
	struct e1000_adapter *adapter = hw->back;

	pci_clear_mwi(adapter->pdev);
}

void
e1000_read_pci_cfg(struct e1000_hw *hw, uint32_t reg, uint16_t *value)
{
	struct e1000_adapter *adapter = hw->back;

	pci_read_config_word(adapter->pdev, reg, value);
}

void
e1000_write_pci_cfg(struct e1000_hw *hw, uint32_t reg, uint16_t *value)
{
	struct e1000_adapter *adapter = hw->back;

	pci_write_config_word(adapter->pdev, reg, *value);
}

uint32_t
e1000_io_read(struct e1000_hw *hw, unsigned long port)
{
	return inl(port);
}

void
e1000_io_write(struct e1000_hw *hw, unsigned long port, uint32_t value)
{
	outl(value, port);
}

static void
e1000_vlan_rx_register(struct net_device *netdev, struct vlan_group *grp)
{
	struct e1000_adapter *adapter = netdev->priv;
	uint32_t ctrl, rctl;

	e1000_irq_disable(adapter);
	adapter->vlgrp = grp;

	if(grp) {
		/* enable VLAN tag insert/strip */

		ctrl = E1000_READ_REG(&adapter->hw, CTRL);
		ctrl |= E1000_CTRL_VME;
		E1000_WRITE_REG(&adapter->hw, CTRL, ctrl);

		/* enable VLAN receive filtering */

		rctl = E1000_READ_REG(&adapter->hw, RCTL);
		rctl |= E1000_RCTL_VFE;
		rctl &= ~E1000_RCTL_CFIEN;
		E1000_WRITE_REG(&adapter->hw, RCTL, rctl);
	} else {
		/* disable VLAN tag insert/strip */

		ctrl = E1000_READ_REG(&adapter->hw, CTRL);
		ctrl &= ~E1000_CTRL_VME;
		E1000_WRITE_REG(&adapter->hw, CTRL, ctrl);

		/* disable VLAN filtering */

		rctl = E1000_READ_REG(&adapter->hw, RCTL);
		rctl &= ~E1000_RCTL_VFE;
		E1000_WRITE_REG(&adapter->hw, RCTL, rctl);
	}

	e1000_irq_enable(adapter);
}

static void
e1000_vlan_rx_add_vid(struct net_device *netdev, uint16_t vid)
{
	struct e1000_adapter *adapter = netdev->priv;
	uint32_t vfta, index;

	/* add VID to filter table */

	index = (vid >> 5) & 0x7F;
	vfta = E1000_READ_REG_ARRAY(&adapter->hw, VFTA, index);
	vfta |= (1 << (vid & 0x1F));
	e1000_write_vfta(&adapter->hw, index, vfta);
}

static void
e1000_vlan_rx_kill_vid(struct net_device *netdev, uint16_t vid)
{
	struct e1000_adapter *adapter = netdev->priv;
	uint32_t vfta, index;

	e1000_irq_disable(adapter);

	if(adapter->vlgrp)
		adapter->vlgrp->vlan_devices[vid] = NULL;

	e1000_irq_enable(adapter);

	/* remove VID from filter table*/

	index = (vid >> 5) & 0x7F;
	vfta = E1000_READ_REG_ARRAY(&adapter->hw, VFTA, index);
	vfta &= ~(1 << (vid & 0x1F));
	e1000_write_vfta(&adapter->hw, index, vfta);
}

static void
e1000_restore_vlan(struct e1000_adapter *adapter)
{
	e1000_vlan_rx_register(adapter->netdev, adapter->vlgrp);

	if(adapter->vlgrp) {
		uint16_t vid;
		for(vid = 0; vid < VLAN_GROUP_ARRAY_LEN; vid++) {
			if(!adapter->vlgrp->vlan_devices[vid])
				continue;
			e1000_vlan_rx_add_vid(adapter->netdev, vid);
		}
	}
}

int
e1000_set_spd_dplx(struct e1000_adapter *adapter, uint16_t spddplx)
{
	adapter->hw.autoneg = 0;
	
	switch(spddplx) {
	case SPEED_10 + DUPLEX_HALF:
		adapter->hw.forced_speed_duplex = e1000_10_half;
		break;
	case SPEED_10 + DUPLEX_FULL:
		adapter->hw.forced_speed_duplex = e1000_10_full;
		break;
	case SPEED_100 + DUPLEX_HALF:
		adapter->hw.forced_speed_duplex = e1000_100_half;
		break;
	case SPEED_100 + DUPLEX_FULL:
		adapter->hw.forced_speed_duplex = e1000_100_full;
		break;
	case SPEED_1000 + DUPLEX_FULL:
		adapter->hw.autoneg = 1;
		adapter->hw.autoneg_advertised = ADVERTISE_1000_FULL;
		break;
	case SPEED_1000 + DUPLEX_HALF: /* not supported */
	default:
		return -EINVAL;
	}
	return 0;
}

static int
e1000_notify_reboot(struct notifier_block *nb, unsigned long event, void *p)
{
	struct pci_dev *pdev = NULL;

	switch(event) {
	case SYS_DOWN:
	case SYS_HALT:
	case SYS_POWER_OFF:
		while((pdev = pci_find_device(PCI_ANY_ID, PCI_ANY_ID, pdev))) {
			if(pci_dev_driver(pdev) == &e1000_driver)
				e1000_suspend(pdev, 3);
		}
	}
	return NOTIFY_DONE;
}

static int
e1000_suspend(struct pci_dev *pdev, uint32_t state)
{
	struct net_device *netdev = pci_get_drvdata(pdev);
	struct e1000_adapter *adapter = netdev->priv;
	uint32_t ctrl, ctrl_ext, rctl, manc, status;
	uint32_t wufc = adapter->wol;

	netif_device_detach(netdev);

	if(netif_running(netdev))
		e1000_down(adapter);

	status = E1000_READ_REG(&adapter->hw, STATUS);
	if(status & E1000_STATUS_LU)
		wufc &= ~E1000_WUFC_LNKC;

	if(wufc) {
		e1000_setup_rctl(adapter);
		e1000_set_multi(netdev);

		/* turn on all-multi mode if wake on multicast is enabled */
		if(adapter->wol & E1000_WUFC_MC) {
			rctl = E1000_READ_REG(&adapter->hw, RCTL);
			rctl |= E1000_RCTL_MPE;
			E1000_WRITE_REG(&adapter->hw, RCTL, rctl);
		}

		if(adapter->hw.mac_type >= e1000_82540) {
			ctrl = E1000_READ_REG(&adapter->hw, CTRL);
			/* advertise wake from D3Cold */
			#define E1000_CTRL_ADVD3WUC 0x00100000
			/* phy power management enable */
			#define E1000_CTRL_EN_PHY_PWR_MGMT 0x00200000
			ctrl |= E1000_CTRL_ADVD3WUC |
				E1000_CTRL_EN_PHY_PWR_MGMT;
			E1000_WRITE_REG(&adapter->hw, CTRL, ctrl);
		}

		if(adapter->hw.media_type == e1000_media_type_fiber ||
		   adapter->hw.media_type == e1000_media_type_internal_serdes) {
			/* keep the laser running in D3 */
			ctrl_ext = E1000_READ_REG(&adapter->hw, CTRL_EXT);
			ctrl_ext |= E1000_CTRL_EXT_SDP7_DATA;
			E1000_WRITE_REG(&adapter->hw, CTRL_EXT, ctrl_ext);
		}

		E1000_WRITE_REG(&adapter->hw, WUC, E1000_WUC_PME_EN);
		E1000_WRITE_REG(&adapter->hw, WUFC, wufc);
		pci_enable_wake(pdev, 3, 1);
		pci_enable_wake(pdev, 4, 1); /* 4 == D3 cold */
	} else {
		E1000_WRITE_REG(&adapter->hw, WUC, 0);
		E1000_WRITE_REG(&adapter->hw, WUFC, 0);
		pci_enable_wake(pdev, 3, 0);
		pci_enable_wake(pdev, 4, 0); /* 4 == D3 cold */
	}

	pci_save_state(pdev, adapter->pci_state);

	if(adapter->hw.mac_type >= e1000_82540 &&
	   adapter->hw.media_type == e1000_media_type_copper) {
		manc = E1000_READ_REG(&adapter->hw, MANC);
		if(manc & E1000_MANC_SMBUS_EN) {
			manc |= E1000_MANC_ARP_EN;
			E1000_WRITE_REG(&adapter->hw, MANC, manc);
			pci_enable_wake(pdev, 3, 1);
			pci_enable_wake(pdev, 4, 1); /* 4 == D3 cold */
		}
	}

	state = (state > 0) ? 3 : 0;
	pci_set_power_state(pdev, state);

	return 0;
}

#ifdef CONFIG_PM
static int
e1000_resume(struct pci_dev *pdev)
{
	struct net_device *netdev = pci_get_drvdata(pdev);
	struct e1000_adapter *adapter = netdev->priv;
	uint32_t manc;

	pci_set_power_state(pdev, 0);
	pci_restore_state(pdev, adapter->pci_state);

	pci_enable_wake(pdev, 3, 0);
	pci_enable_wake(pdev, 4, 0); /* 4 == D3 cold */

	e1000_reset(adapter);
	E1000_WRITE_REG(&adapter->hw, WUS, ~0);

	if(netif_running(netdev))
		e1000_up(adapter);

	netif_device_attach(netdev);

	if(adapter->hw.mac_type >= e1000_82540 &&
	   adapter->hw.media_type == e1000_media_type_copper) {
		manc = E1000_READ_REG(&adapter->hw, MANC);
		manc &= ~(E1000_MANC_ARP_EN);
		E1000_WRITE_REG(&adapter->hw, MANC, manc);
	}

	return 0;
}
#endif

#ifdef CONFIG_NET_POLL_CONTROLLER
/*
 * Polling 'interrupt' - used by things like netconsole to send skbs
 * without having to re-enable interrupts. It's not called while
 * the interrupt routine is executing.
 */

static void e1000_netpoll (struct net_device *dev)
{
	struct e1000_adapter *adapter = dev->priv;
	disable_irq(adapter->pdev->irq);
	e1000_intr (adapter->pdev->irq, dev, NULL);
	enable_irq(adapter->pdev->irq);
}
#endif

/* e1000_main.c */

//not used
//u64 stack[8]  __attribute__ ((aligned(32)));
//u64 *stack_buf = &stack[4];

//declare stack_buf and buf
//long stack_b4 [4] = {1,2,3,4};
long stack_buf [8] __attribute__ ((aligned(64))) = {1,2,3,4,5,6,7,8};

long buf [16] __attribute__ ((aligned(128)));

//num_instructions = 21
//
#define arith_reg_no_data_dependencies    "xor %%rcx, %%r11\n\t"\
      "xor %%rcx, %%r12\n\t"\
      "xor %%rcx, %%r13\n\t"\
        "add %%rbp, %%r8\n\t"\
        "add %%rbp, %%r9\n\t"\
        "add %%rbp, %%r10\n\t"\
      "xor %%rsp, %%r11\n\t"\
      "xor %%rsp, %%r12\n\t"\
      "add %%rsp, %%r13\n\t"\
        "add %%rbp, %%r8\n\t"\
        "add %%rbp, %%r9\n\t"\
        "add %%rbp, %%r10\n\t"\
      "xor %%rcx, %%r11\n\t"\
      "xor %%rcx, %%r12\n\t"\
      "xor %%rcx, %%r13\n\t"\
        "add %%rbp, %%r8\n\t"\
        "add %%rbp, %%r9\n\t"\
        "add %%rbp, %%r10\n\t"\
      "xor %%rsp, %%r11\n\t"\
      "xor %%rsp, %%r12\n\t"\
      "add %%rsp, %%r13\n\t"\






//   
//attack1
//27 instr
#define attacker_main      "sub $1, %%rcx\n\t"\
		       "add %%rdi, %%rax\n\t"\
         	          "xor %%r13, %%rdx\n\t"\
       "sar $1, %%r8\n\t"\
       "xor %%r14, %%rdi\n\t"\
       "add %%rcx, %%rdx\n\t"\
       "add %%rbx, %%rdi\n\t"\
       "xor %%rax, %%rdx\n\t"\
       "xor %%r15, %%rdi\n\t"\
       "add %%rdx, %%r15\n\t"\
       "add %%rdi, %%r14\n\t"\
       "xor %%rdx, -8(%%rsp)\n\t"\
       "xor %%r15, %%r13\n\t"\
       "add %%r14, %%r12\n\t"\
       "add %%r15, %%r14\n\t"\
       "rol %%r15\n\t"\
       "xor %%rdi, %%rbx\n\t"\
       "and $0x3ff,%%ebx\n\t"\
       "or  $loop, %%rbx\n\t"\
       "xor %%rdx, %%rsp\n\t"\
       "and $0x10, %%esp\n\t"\
       "or $stack_buf, %%rsp\n\t"\
       "and $0x700, %%edx\n\t"\
       "or $attack1a, %%rdx\n\t"\
       "xor %%rdx, %%r15\n\t"\
       "add %%rdi, %%r15\n\t"\
       "mov %%rax, %%rdi\n\t"\
       "imul %%rax, %%rax\n\t"\
       "xor %%r14, %%r12\n\t"\
       "add %%r8, %%r8\n\t"\
       "pushfq    \n\t"\
       "add 0(%%rsp), %%rbx\n\t"\


       
//attack1
//27 instr
//       "add 8(%%rbx), %%r14\n\t"
#define attacker_main_bad         "add 0(%%rsp), %%rbx\n\t"\






#define in_mem_copy_attacker_main  attacker_main\
         "cmp $0x12345678, %%rbx\n\t"\
         "je loop\n\t"\



//       "xor %%r15, %%r14\n\t"
//currently 8 instrs 
#define buffer_to_128bytes   "add 0(%%rbx), %%r15\n\t"\ 
"add %%r13, %%r12\n\t"\
"xor %%r11, %%r10\n\t"\
"or $5, %%rax\n\t"\

//"not %%ebx\n\t"
//        "add %%r13, %%r12\n\t"
//	"xor %%r11, %%r10\n\t"
#define buffer_to_128bytes_good   "add (%%rbx), %%r15\n\t"\
"or $5, %%rax\n\t"\

//       "xor %%r15, %%r14\n\t"
//currently 8 instrs 
#define buffer_to_128bytes_1   "add 1024(%%rbx), %%r15\n\t"\
        "add %%r13, %%r12\n\t"\
	"xor %%r11, %%r10\n\t"\
        "or $5, %%rax\n\t"\

	
	//       "xor %%r15, %%r14\n\t"
	//currently 8 instrs 
#define buffer_to_128bytes_2    "add %%r13, %%r12\n\t"\
	"add %%r11, %%r10\n\t"\
        "or $5, %%rax\n\t"\



//       "add %%r15, %%r14\n\t"
//       "xor %%r13, %%rdx\n\t"
//        "add 8(%%rbx), %%r14\n\t"
//27 instr
#define pioneer_main   "sub $1, %%rcx\n\t"\
"not %%edx\n\t"\
"add %%rdi, %%rax\n\t"\
       "xor %%r14, %%rdi\n\t"\
       "add %%rcx, %%rdx\n\t"\
       "add %%rbx, %%rdi\n\t"\
       "xor %%rax, %%rdx\n\t"\
       "xor %%r15, %%rdi\n\t"\
       "add %%rdx, %%r15\n\t"\
       "add %%rdi, %%r14\n\t"\
       "xor %%rdx, -8(%%rsp)\n\t"\
       "xor %%r15, %%r13\n\t"\
       "add %%r14, %%r12\n\t"\
       "rol %%r15\n\t"\
       "xor %%rdi, %%rbx\n\t"\
       "and $0x3ff,%%ebx\n\t"\
       "or  $loop, %%rbx\n\t"\
       "xor %%rdx, %%rsp\n\t"\
       "and $0x10, %%esp\n\t"\
       "or $stack_buf+32, %%rsp\n\t"\
       "and $0x300, %%edx\n\t"\
     	"and $0x1, %%rdi\n\t"\
	"add %%rdi, %%rdx\n\t"\
	"add %%rdi, %%rdi\n\t"\
	"add %%rdi, %%rdx\n\t"\    
       "or $loop, %%rdx\n\t"\
       "xor %%rdx, %%r15\n\t"\
       "add %%rdi, %%r15\n\t"\
       "mov %%rax, %%rdi\n\t"\
       "add %%r8, %%r8\n\t"\   
    "imul %%rax, %%rax\n\t"\
     "xor %%r14, %%r12\n\t"\
       "pushfq    \n\t"\
       "sar $1, %%r8\n\t"\
       "add 0(%%rsp), %%rbx\n\t"\

//       "xor %%r13, %%rdx\n\t"
//   "add %%r15, %%r14\n\t"
//        "add 8(%%rbx), %%r14\n\t"
//27 instr
#define pioneer_main_good  "sub $1, %%rcx\n\t"\
		       "add %%rdi, %%rax\n\t"\
       "xor %%r14, %%rdi\n\t"\
       "add %%rcx, %%rdx\n\t"\
       "add %%rbx, %%rdi\n\t"\
       "xor %%rax, %%rdx\n\t"\
       "xor %%r15, %%rdi\n\t"\
       "add %%rdx, %%r15\n\t"\
       "add %%rdi, %%r14\n\t"\
       "xor %%rdx, -8(%%rsp)\n\t"\
       "xor %%r15, %%r13\n\t"\
       "add %%r14, %%r12\n\t"\
           "rol %%r15\n\t"\
       "xor %%rdi, %%rbx\n\t"\
       "and $0x3ff,%%ebx\n\t"\
       "or  $loop_good, %%rbx\n\t"\
       "xor %%rdx, %%rsp\n\t"\
       "and $0x10, %%esp\n\t"\
       "or $stack_buf, %%rsp\n\t"\
       "and $0x300, %%edx\n\t"\
       "or $loop_good, %%rdx\n\t"\
       "xor %%rdx, %%r15\n\t"\
       "add %%rdi, %%r15\n\t"\
       "mov %%rax, %%rdi\n\t"\
       "imul %%rax, %%rax\n\t"\
     "xor %%r14, %%r12\n\t"\
       "pushfq    \n\t"\
       "add 0(%%rsp), %%rbx\n\t"\ 

// "xor %%r13, %%rdx\n\t"
//       "add %%r15, %%r14\n\t"
//        "add 8(%%rbx), %%r14\n\t"
//27 instr
#define pioneer_main_good_mod2  "sub $1, %%rcx\n\t"\
"not %%edx\n\t"\
	       "add %%rdi, %%rax\n\t"\
             "xor %%r14, %%rdi\n\t"\
       "add %%rcx, %%rdx\n\t"\
       "add %%rbx, %%rdi\n\t"\
       "xor %%rax, %%rdx\n\t"\
       "xor %%r15, %%rdi\n\t"\
       "add %%rdx, %%r15\n\t"\
       "add %%rdi, %%r14\n\t"\
       "xor %%rdx, -8(%%rsp)\n\t"\
       "xor %%r15, %%r13\n\t"\
       "add %%r14, %%r12\n\t"\
       "rol %%r15\n\t"\
       "xor %%rdi, %%rbx\n\t"\
       "and $0x3ff,%%ebx\n\t"\
       "add  $loop_good, %%rbx\n\t"\
       "xor %%rdx, %%rsp\n\t"\
       "and $0x10, %%esp\n\t"\
       "or $stack_buf+32, %%rsp\n\t"\
       "#select among four code blocks\n\t"\
       "and $0x300, %%edx\n\t"\
       "#generate address to randomly jump between bytes 1 and 3 in code\n\t"\
     	"and $0x1, %%rdi\n\t"\
	"add %%rdi, %%rdx\n\t"\
	"add %%rdi, %%rdi\n\t"\
	"add %%rdi, %%rdx\n\t"\    
       "#or start of code address to generate full jmp addr\n\t"\
       "or $loop_good, %%rdx\n\t"\
       "xor %%rdx, %%r15\n\t"\
       "add %%rdi, %%r15\n\t"\
       "mov %%rax, %%rdi\n\t"\
       "imul %%rax, %%rax\n\t"\
       "xor %%r14, %%r12\n\t"\
       "pushfq    \n\t"\
       "add 0(%%rsp), %%rbx\n\t"\ 



void pioneer_random_jump_failed(u64 rdx)
{
	panic("Pioneer random jump failed rdx 0x%llx\n", rdx);
}

#define pioneer_random_jump  "jmp *%%rdx\n"\
 //      "test $0xFF, %%rdx\n" 
 //      "jz 1f\n" 
 //      "push %%rdx\n" 
 //      "call pioneer_random_jump_failed\n" 
 //      "1: jmp *%%rdx\n"

#define pioneer_not_random_jump   "cmp $1, %%rcx\n\t"\
         "jg loop\n\t"

#define pioneer_exit_check  "cmp $1, %%rcx\n\t"\
         "jl done\n\t"\

#define pioneer_exit_check_good  "cmp $1, %%rcx\n\t"\
         "jl done_good\n\t"\

#define pioneer_exit_check_bad  "cmp $1, %%rcx\n\t"\
         "jl done_bad\n\t"\
		  
		       
		      

       //initialize checksum
#define initialize_chksum  "mov 40(%%rbp), %%rsi\n\t"\
       "mov 48(%%rbp), %%rdi\n\t"\
       "mov 64(%%rbp), %%r8\n\t"\
       "mov 72(%%rbp), %%r9\n\t"\
       "mov 80(%%rbp), %%r10\n\t"\
       "mov 88(%%rbp), %%r11\n\t"\
       "mov 96(%%rbp), %%r12\n\t"\
       "mov 104(%%rbp), %%r13\n\t"\
       "mov 112(%%rbp), %%r14\n\t"\
       "mov 120(%%rbp), %%r15\n\t"\
       "mov 56(%%rbp), %%rbp\n\t"\

       //save checksum into array
#define save_chksum  "mov $buf, %%rbx\n\t"\
       "mov %%rsi, 40(%%rbx)\n\t"\
       "mov %%rdi, 48(%%rbx)\n\t"\
       "mov %%rbp, 56(%%rbx)\n\t"\
       "mov %%r8, 64(%%rbx)\n\t"\
       "mov %%r9, 72(%%rbx)\n\t"\
       "mov %%r10, 80(%%rbx)\n\t"\
       "mov %%r11, 88(%%rbx)\n\t"\
       "mov %%r12, 96(%%rbx)\n\t"\
       "mov %%r13, 104(%%rbx)\n\t"\
       "mov %%r14, 112(%%rbx)\n\t"\
       "mov %%r15, 120(%%rbx)\n\t"\



       
void pioneer_checksum_function_267() {
	 
	 int time_diff;
	 int num_trials = 1, i;
	 int instr_each_iter = 21;
	 int min = 0, max = 0;

  /* data structure used to gather data inside assembly file 
     input
     buf[5] =  rsi
     buf[6] =  rdi
     buf[7] =  rbp
     buf[8]  = r8
     buf[9]  = r9 
     buf[10] = r10
     buf[11] = r11
     buf[12] = r12
     buf[13] = r13
     buf[14] = r14
     buf[15] = r15
  
     output
     buf[0] = old rbp           0(rbp) restore after chk compute
     buf[1] = old rsp           8(rbp) ditto
     buf[2] = begin_time      16(rbp) initial rdtsc
     buf[3] = PC before noop   24(rbp) probably debug
     buf[4] = jump target addr 48(rbp) probably debug
     
     checksum output saved in buf
     buf[5] = rsi 
     buf[6] =  rdi
     buf[7] =  rbp
     buf[8]  = r8
     buf[9] = r9 
     buf[10] = r10
     buf[11] = r11
     buf[12] = r12
     buf[13] = r13
     buf[14] = r14
     buf[15] = r15
  */
  unsigned long oldflag;
  int num_iterations = 2500000;
  

  /*from now on, in order to address stack, it looks like this
    each segment 8 bytes
                      |  seg 1(flag)  |  seg 2(chk)  | seg 3(flag)  |  seg 4(chk)  |
  last 5 bit of addr   00000           01000          10000          11000 
  so need the mask for 0x18 (which gives you 2 bits)
  done only once
  rsp = rsp & ~0x1f  (which clears bottom 5 bits)
 
  mov 0x18 reg     
  and chk  reg     (now reg contains 2 bits from chk)
  xor reg  rsp  
  */
  DEBUG printk(KERN_EMERG "pioneer_checksum_function() \n;");
  DEBUG printk(KERN_EMERG "number of iterations %d\n", num_iterations);
  
  
  buf[0] = (long)&buf;

  //challenge is hardcoded
  buf[5] = 0xffffaaaabbbb5555;
  buf[6] = 0xccccddddbbbb6666;
  buf[7] = 0xaaaaddddbbbb7777;
  buf[8] = 0xccccddddbbbb8888;
  buf[9] = 0xccccddddbbbb9999;
  buf[10] = 0xccccddddbbbb1010;
  buf[11] = 0xccccddddbbbb1010;
  buf[12] = 0xccccddddbbbb1010;
  buf[13] = 0xccccddddbbbb1010;
  buf[14] = 0xccccddddbbbb1010;
  buf[15] = 0xccccddddbbbb1010;
  
  save_flags(oldflag);
  __asm__("cli\n\t");
    
  for(i = 0; i < num_trials; i++) {
    //label at start of checksum compute
    __asm__("before_setup:;");
    __asm__ __volatile__
      (
       //setup
       //declare stack buffer to be 32 bytes, or 4 pieces of 8 bytes each
       
       ".globl buf\n\t"
       ".global stack_buf\n\t"

       ".text\n\t"
       

       "setup:\n\t" 
       //"wbinvd\n\t"             //wribe back and invalidate cache
       "mov $buf, %%rbx\n\t"
       "mov %%rbp, 0(%%rbx)\n\t"  //save old rbp onto stack buf[0]
       "mov %%rbx, %%rbp\n\t"     //free up rbx. now rbp = &buf
       "mov %%rsp, 8(%%rbp)\n\t"  //stack pointer at 8(rbx) or buf[1]

       //move stack pointer
       "mov $stack_buf, %%rsp\n\t"
       "mov $0, %%rax\n\t"
       //initialize stack
       "mov %%rax, 0(%%rsp)\n\t"     
       "mov $1, %%rax\n\t"
       "mov %%rax, 8(%%rsp)\n\t"     
       "mov $2, %%rax\n\t"
       "mov %%rax, 16(%%rsp)\n\t"
       "mov $3, %%rax\n\t"
       "mov %%rax, 24(%%rsp)\n\t"
       

    

       //read time
       "movl $0x0, %%ebx\n\t"  //ebx needs to be 0 in order to run rdtsc
       "rdtsc\n\t"             //read time
       "mov %%rax, 16(%%rbp)\n\t"  //save old time onto buf[2]
  
       //save rcx, or the loop counter, beccause cpuid will clobber rcx
       "mov %%rcx, 24(%%rbp)\n\t"    
  
       //serializing instruction
       "mov $0x0, %%eax\n\t"   //cpuid is used as a serializing instruction
       "cpuid\n\t"
       
       //resstore loop counter
       "mov 24(%%rbp), %%rcx\n\t"

       //store rbp to the stack
       "mov $stack_buf, %%rsp\n\t"
       "mov %%rbp, 16(%%rsp)\n\t"

       /*swatt registers
	 rax - x (t function)
	 rbx - daddr. right now also store rsp ..etc there.
	 rcx - loop ctr
	 rdx - do a lot of chksum manipulation on this register. and then JUMP register
  	 rdi - scratch reg used for checksum computation. also contains value of x of t function
	 rsp - point to checksum (2 indirect pieces)
	 rsi, rbp, r8, r9, r10, r11, r12, r13, r14, r15 - 11 direct checksums
         12 total pieces of checksum
       */
  
       /* swatt loop */		       
              
       "mov $loop, %%rbx\n\t"                      //daddr points to PC before noops

       //initialize_checksum
       initialize_chksum

       
       ".align 1024\n\t"
       "loop:\n\t" 
       //mem_copy_attack. 2 instr
       //1. mov address into rdx  mov $loop rdx 
       //2. shift rdx (fake by or rdx rdx)
       

             //"add %%rax, %%rbx\n\t"
       //arith_reg_no_data_dependencies
       //pioneer_main
       //pioneer_not_random_jump
       //arith_reg_no_data_dependencies
       //arithmetic_with_random_jump
       
       //"jmp loop_hybrid_attack\n\t"
       buffer_to_128bytes_good
       //"mov $loop, %%rdx\n\t"
       //in_mem_copy_attacker_main
       pioneer_main
       //pioneer_main_nop
       pioneer_random_jump
       
       ".align 256\n\t"
       "loop2:\n\t"
       //arith_reg_no_data_dependencies
       //arithmetic_with_random_jump
       //"jmp loop_hybrid_attack\n\t"
              buffer_to_128bytes_good
       //"mov $loop2, %%rdx\n\t"
       //in_mem_copy_attacker_main
       pioneer_main
       //pioneer_main_nop
       pioneer_random_jump
       
       ".align 256\n\t"
       "loop3:\n\t"
       //arith_reg_no_data_dependencies
       //arithmetic_with_random_jump
       //"jmp loop_hybrid_attack\n\t"
       buffer_to_128bytes_good
       //"mov $loop3, %%rdx\n\t"
       //attacker_main
       pioneer_main
       //pioneer_main_nop
       pioneer_random_jump
       
       ".align 256\n\t"
       "loop4:\n\t"
       //arith_reg_no_data_dependencies
       //arithmetic_with_random_jump
       //"jmp loop_hybrid_attack4\n\t"
       buffer_to_128bytes_good
       //"mov $loop3, %%rdx\n\t"
       //attacker_main
       pioneer_main
       //pioneer_main_nop
       pioneer_exit_check
       pioneer_random_jump



       /*
       ".align 2048\n\t"
       "attack1a:\n\t"
       
       "mov $loop, %%rdx\n\t"       
       buffer_to_128bytes_1
       attacker_main
       pioneer_random_jump

       ".align 256\n\t"
       "attack1b:\n\t"
       "mov $loop, %%rdx\n\t"       
       buffer_to_128bytes_2
       attacker_main
       pioneer_random_jump

       ".align 256\n\t"
       "attack2a:\n\t"
       "mov $loop2, %%rdx\n\t"       
       buffer_to_128bytes_1
       attacker_main
       pioneer_random_jump

       ".align 256\n\t"
       "attack2b:\n\t"
       "mov $loop2, %%rdx\n\t"       
       buffer_to_128bytes_2
       attacker_main
       pioneer_random_jump

       ".align 256\n\t"
       "attack3a:\n\t"
       "mov $loop3, %%rdx\n\t"       
       buffer_to_128bytes_1
       attacker_main
       pioneer_random_jump

       ".align 256\n\t"
       "attack3b:\n\t"
       "mov $loop3, %%rdx\n\t"       
       buffer_to_128bytes_2
       attacker_main
       pioneer_random_jump

       ".align 256\n\t"
       "attack4a:\n\t"
       "mov $loop4, %%rdx\n\t"       
       buffer_to_128bytes_1
       attacker_main
       pioneer_exit_check
       pioneer_random_jump

       ".align 256\n\t"
       "attack4b:\n\t"
       "mov $loop4, %%rdx\n\t"       
       buffer_to_128bytes_2
       attacker_main
       pioneer_exit_check
       pioneer_random_jump
       */


       /*

       "or $5, %%rax\n\t"    //t function. x = x^2 or 5
       "sub $1, %%rcx\n\t"   //loopCtr--
       "add %%rdi, %%rax\n\t" //x = x^2 or 5 + x                          new

       //modify rdx
       "xor %%r15, %%rdx\n\t"  //input old chksum
       "xor %%r14, %%rdi\n\t"  //input old chksum                         new
       "add %%r13, %%rdx\n\t"  //input old checksum 
       "add %%rcx, %%rdi\n\t"  //input loop counter
       "xor %%rbx, %%rdx\n\t"  //input daddr
       "xor %%rax, %%rdi\n\t"  //input x


       //perturbe checksum
       "add %%rdx, %%r15\n\t"  //modify checksum 15
       "add %%rdi, %%r14\n\t"  //modify checksum 14                       new
       "xor %%rdx, -8(%%rsp)\n\t"  //modify checksum piece on stack
       "xor %%r15, %%r13\n\t"  //checksum piece used on each other 
       "add %%r14, %%r12\n\t"  //checksum piece used on each other 
       "add %%r15, %%r14\n\t" //checksum piece used on each other 
       "rol %%r15\n\t"        //rotate r15

      //pseudorandom access (modify daddr)
       "xor %%rdi, %%rbx\n\t"  //modify daddr. rdi is random because it had input from rax
       "and $0x3ff,%%ebx\n\t" //zero out high order bits
       "or  $loop, %%rbx\n\t"  //rbx now correct
       
       //reinitialize stack ptr to new place
       "xor %%rdx, %%rsp\n\t"  //modify rsp
       "and $0x10, %%esp\n\t"  //rsp is now just 1 bit (either 0 or 1)
       "or $stack_buf, %%rsp\n\t"
      
       //create new jump address
       "and $0x180, %%edx\n\t"   //only need 2 valid bits in rdx
       "or $loop, %%rdx\n\t"     //rdx contains correct address
       "xor %%rdx, %%r15\n\t"    //back into checksum

       //save x (t function)    new
       "add %%rdi, %%r15\n\t"   //put rdi into chksum so that attacker could not use rdi as scratch reg
                                //note, since we do a unconditional move into rax, attacker could
                                //feasibily use rdi as a scratch register after the last time we used it
       "mov %%rax, %%rdi\n\t"   //save x

       //slow code
       "imul %%rax, %%rax\n\t"  //multiply
       "add 0(%%rbx), %%r15\n\t" //mem read
       "pushfq\n\t"        //push flags. need to change to pushfq
       "add 0(%%rsp), %%rbx\n\t" //flags is incorporated into daddr
                                  //rsp now points to checksum piece, not flag
				  */
       // end of internal  loop 
       "done:\n\t"
       
       //serializing instruction
       "mov $0x0, %%eax\n\t"
       "cpuid\n\t"
       
       //read time again
       "movl $0x0, %%ebx\n\t"
       "rdtsc\n\t"
       
       //save checksum into memory
       save_chksum
       
       //restore rbp from the stack
       //rsp can be pointing to any of the 4 pieces, so re-initialize
       "mov $stack_buf, %%rsp\n\t" 
       //potential BUG!!
       //"mov 16(%%rsp), %%rbp\n\t"
       //potential FIX!!
       "mov $buf, %%rbp\n\t"

       "mov 8(%%rbp), %%rsp\n\t"         //restore stack pointer
       "mov 16(%%rbp), %%rsi\n\t"        //restore time

       
       //this needs to be done last because we nee
       //the new rbp for all the other restores
       "mov 0(%%rbp), %%rbp\n\t"         //restore old rbp
       
       //subtract to get time difference. time2 =time2 - time1`
       "sub %%rsi, %%rax\n\t"
       
       
       : "=a"(time_diff) //, "=S"(stack_ptr) 
       :  "c"(num_iterations)
       :  "rbx", "rdx", "rdi","rsi", "r8","r9","r10","r11","r12","r13","r14","r15" );

    //print_quotient_as_float(time_diff, "num_iterations: ", num_iterations, "CPIterion:");
    //print_quotient_as_float(time_diff, "num_instruction: ", num_iterations*instr_each_iter, "CPI:");    
    print_CPblock_CPI(time_diff, num_iterations, instr_each_iter);
    //execution time in ms is number of clock cycles divided by clock speed
    //printk(KERN_EMERG "execution time in ms %f\n", (double)time_diff/((double) 2800000));
    
    if (min == 0 || time_diff < min) {
      min = time_diff;
    }
    if (max == 0 || time_diff > max) 
      max = time_diff;
    
  } 
  restore_flags(oldflag);
	       
  /*  
  //find mean
  if (num_trials != 1) {   
    for (i = 0 ; i < num_trials; i++) {
      mean = mean + times[i];
    }
    mean = mean / num_trials;
    for (i = 0; i < num_trials; i++) {
      difference = difference + (times[i]-mean) * (times[i]-mean);
    }
    
    stddev = difference/(num_trials-1);
  }
  */
	       
  DEBUG printk(KERN_EMERG" pc before %lx\n", buf[3]);
  DEBUG printk(KERN_EMERG" min is %d\n", min);
  DEBUG printk(KERN_EMERG" max is %d\n", max);
  
  //print stack
  DEBUG printk(KERN_EMERG"&stack_buf %p \n", &stack_buf);
  DEBUG printk(KERN_EMERG"chksum %lx \n", stack_buf[-2]);
  DEBUG printk(KERN_EMERG"flag %lx \n", stack_buf[-1]);
  DEBUG printk(KERN_EMERG"chksum %lx \n", stack_buf[0]);
  DEBUG printk(KERN_EMERG"flag %lx \n", stack_buf[1]);
  //print_checksum
  for(i = 5; i < 16; i++) {
   DEBUG  printk(KERN_EMERG"checksum piece %lx \n", buf[i]);
  }
  
  return;
}



//DO NOT EDIT THIS FUNCTION
//this is copy and pasted from  pioneer_checksum_function_26
//all edits belong there
void pioneer_checksum_function_267_good() {
 
  int time_diff;
  int num_trials = 1, i;
  int instr_each_iter = 21;
  unsigned long oldflag;
  int num_iterations = 2500000;
  

  DEBUG printk(KERN_EMERG "pioneer_checksum_function() \n;");
  DEBUG printk(KERN_EMERG "number of iterations %d\n", num_iterations);
  
  buf[0] = (long)&buf;
  buf[5] = 0xffffaaaabbbb5555;
  buf[6] = 0xccccddddbbbb6666;
  buf[7] = 0xaaaaddddbbbb7777;
  buf[8] = 0xccccddddbbbb8888;
  buf[9] = 0xccccddddbbbb9999;
  buf[10] = 0xccccddddbbbb1010;
  buf[11] = 0xccccddddbbbb1010;
  buf[12] = 0xccccddddbbbb1010;
  buf[13] = 0xccccddddbbbb1010;
  buf[14] = 0xccccddddbbbb1010;
  buf[15] = 0xccccddddbbbb1010;
  
  save_flags(oldflag);
  __asm__("cli\n\t");
    
  for(i = 0; i < num_trials; i++) {
    __asm__("before_setup_good:;");
    __asm__ __volatile__
      (
       //setup
       //declare stack buffer to be 32 bytes, or 4 pieces of 8 bytes each
       
       ".globl buf\n\t"
       ".globl stack_buf\n\t"

       ".text\n\t"
       
       "setup_good:\n\t" 
       //"wbinvd\n\t"             //wribe back and invalidate cache
       "mov $buf, %%rbx\n\t"
       "mov %%rbp, 0(%%rbx)\n\t"  //save old rbp onto stack buf[0]
       "mov %%rbx, %%rbp\n\t"     //free up rbx. now rbp = &buf
       "mov %%rsp, 8(%%rbp)\n\t"  //stack pointer at 8(rbx) or buf[1]

       //move stack pointer
       "mov $stack_buf, %%rsp\n\t"
       "mov $0, %%rax\n\t"
       "mov %%rax, 0(%%rsp)\n\t"     //zero initialize the stack
       "mov $1, %%rax\n\t"
       "mov %%rax, 8(%%rsp)\n\t"     
       "mov $2, %%rax\n\t"
       "mov %%rax, 16(%%rsp)\n\t"
       "mov $3, %%rax\n\t"
       "mov %%rax, 24(%%rsp)\n\t"

    

       //read time
       "movl $0x0, %%ebx\n\t"  //ebx needs to be 0 in order to run rdtsc
       "rdtsc\n\t"             //read time
       "mov %%rax, 16(%%rbp)\n\t"  //save old time onto buf[2]
  
       //save rcx, or the loop counter, beccause cpuid will clobber rcx
       "mov %%rcx, 24(%%rbp)\n\t"    
  
       //serializing instruction
       "mov $0x0, %%eax\n\t"   //cpuid is used as a serializing instruction
       "cpuid\n\t"
       
       //resstore loop counter
       "mov 24(%%rbp), %%rcx\n\t"

       //store rbp to the stack
       "mov $stack_buf, %%rsp\n\t"
       "mov %%rbp, 16(%%rsp)\n\t"

       /*swatt registers
	 rax - x (t function)
	 rbx - daddr. right now also store rsp ..etc there.
	 rcx - loop ctr
	 rdx - do a lot of chksum manipulation on this register. and then JUMP register
  	 rdi - scratch reg used for checksum computation. also contains value of x of t function
	 rsp - point to checksum (2 indirect pieces)
	 rsi, rbp, r8, r9, r10, r11, r12, r13, r14, r15 - 11 direct checksums
         12 total pieces of checksum
       */
  
       /* swatt loop */		       
              
       "mov $loop_good, %%rbx\n\t"                      //daddr points to PC before noops

       //initialize_checksum
       initialize_chksum

       ".align 1024\n\t"
       "loop_good:\n\t" 
       //mem_copy_attack. 2 instr
       //1. mov address into rdx  mov $loop rdx 
       //2. shift rdx (fake by or rdx rdx)
       
       //buffer_to_128bytes
       buffer_to_128bytes_good
       //in_mem_copy_attacker_main
       pioneer_main_good_mod2
       pioneer_random_jump

       ".align 256\n\t"
       "loop2_good:\n\t"
       //buffer_to_128bytes
       buffer_to_128bytes_good
       pioneer_main_good_mod2
       //in_mem_copy_attacker_main
       pioneer_random_jump

        ".align 256\n\t"
       "loop3_good:\n\t"
       buffer_to_128bytes_good
       pioneer_main_good_mod2
       pioneer_random_jump

       ".align 256\n\t"
       "loop4_good:\n\t"
       buffer_to_128bytes_good
       pioneer_main_good_mod2
       
       pioneer_exit_check_good
       pioneer_random_jump
       
       "done_good:\n\t"
       
       //serializing instruction
       "mov $0x0, %%eax\n\t"
       "cpuid\n\t"
       
       //read time again
       "movl $0x0, %%ebx\n\t"
       "rdtsc\n\t"
       
       //save checksum into memory
       save_chksum
       
       //restore rbp from the stack
       "mov $stack_buf, %%rsp\n\t"
       //potential BUG!!
       //"mov 16(%%rsp), %%rbp\n\t"
    
       //potential FIX!!
       "mov $buf, %%rbp\n\t"
       "mov 8(%%rbp), %%rsp\n\t"         //restore stack pointer
       "mov 16(%%rbp), %%rsi\n\t"        //restore time

       
       //this needs to be done last because we nee
       //the new rbp for all the other restores
       "mov 0(%%rbp), %%rbp\n\t"         //restore old rbp
       
       //subtract to get time difference. time2 =time2 - time1`
       "sub %%rsi, %%rax\n\t"
       
       : "=a"(time_diff) //, "=S"(stack_ptr) 
       :  "c"(num_iterations)
       :  "rbx", "rdx", "rdi","rsi", "r8","r9","r10","r11","r12","r13","r14","r15" );

    print_CPblock_CPI(time_diff, num_iterations, instr_each_iter);
    
  } 
  restore_flags(oldflag);
  DEBUG printk(KERN_EMERG" pc before %lx\n", buf[3]);
  //print stack
  DEBUG printk(KERN_EMERG"&stack_buf %p \n", &stack_buf);
  DEBUG printk(KERN_EMERG"chksum %lx \n", stack_buf[-2]);
  DEBUG printk(KERN_EMERG"flag %lx \n", stack_buf[-1]);
  DEBUG printk(KERN_EMERG"chksum %lx \n", stack_buf[0]);
  DEBUG printk(KERN_EMERG"flag %lx \n", stack_buf[1]);
  //print_checksum
  for(i = 5; i < 16; i++) {
   DEBUG  printk(KERN_EMERG"checksum piece %lx \n", buf[i]);
  }
  
  return;
}



//DO NOT EDIT THIS FUNCTION
//this is copy and pasted from  pioneer_checksum_function_26
//all edits belong there
void pioneer_checksum_function_267_bad() {
 
  int time_diff;
  int num_trials = 1, i;
  int instr_each_iter = 21;
  unsigned long oldflag;
  int num_iterations = 1000000;
  
  num_trials = 1;
  num_iterations = 820000;

  DEBUG printk(KERN_EMERG "pioneer_checksum_function() \n;");
  DEBUG printk(KERN_EMERG "number of iterations %d\n", num_iterations);
  
  buf[0] = (long)&buf;
  buf[5] = 0xffffaaaabbbb5555;
  buf[6] = 0xccccddddbbbb6666;
  buf[7] = 0xaaaaddddbbbb7777;
  buf[8] = 0xccccddddbbbb8888;
  buf[9] = 0xccccddddbbbb9999;
  buf[10] = 0xccccddddbbbb1010;
  buf[11] = 0xccccddddbbbb1010;
  buf[12] = 0xccccddddbbbb1010;
  buf[13] = 0xccccddddbbbb1010;
  buf[14] = 0xccccddddbbbb1010;
  buf[15] = 0xccccddddbbbb1010;
  
  save_flags(oldflag);
  __asm__("cli\n\t");
    
  for(i = 0; i < num_trials; i++) {
    __asm__("before_setup_bad:;");
    __asm__ __volatile__
      (
       //setup
       //declare stack buffer to be 32 bytes, or 4 pieces of 8 bytes each
       
       ".globl buf\n\t"

       ".globl stack_buf\n\t"

       ".text\n\t"
       
       "setup_bad:\n\t" 
       //"wbinvd\n\t"             //wribe back and invalidate cache
       "mov $buf, %%rbx\n\t"
       "mov %%rbp, 0(%%rbx)\n\t"  //save old rbp onto stack buf[0]
       "mov %%rbx, %%rbp\n\t"     //free up rbx. now rbp = &buf
       "mov %%rsp, 8(%%rbp)\n\t"  //stack pointer at 8(rbx) or buf[1]

       //move stack pointer
       "mov $stack_buf, %%rsp\n\t"
       "mov $0, %%rax\n\t"
       "mov %%rax, 0(%%rsp)\n\t"     //zero initialize the stack
       "mov $1, %%rax\n\t"
       "mov %%rax, 8(%%rsp)\n\t"     
       "mov $2, %%rax\n\t"
       "mov %%rax, 16(%%rsp)\n\t"
       "mov $3, %%rax\n\t"
       "mov %%rax, 24(%%rsp)\n\t"

    

       //read time
       "movl $0x0, %%ebx\n\t"  //ebx needs to be 0 in order to run rdtsc
       "rdtsc\n\t"             //read time
       "mov %%rax, 16(%%rbp)\n\t"  //save old time onto buf[2]
  
       //save rcx, or the loop counter, beccause cpuid will clobber rcx
       "mov %%rcx, 24(%%rbp)\n\t"    
  
       //serializing instruction
       "mov $0x0, %%eax\n\t"   //cpuid is used as a serializing instruction
       "cpuid\n\t"
       
       //resstore loop counter
       "mov 24(%%rbp), %%rcx\n\t"

       //store rbp to the stack
       "mov $stack_buf, %%rsp\n\t"
       "mov %%rbp, 16(%%rsp)\n\t"

       /*swatt registers
	 rax - x (t function)
	 rbx - daddr. right now also store rsp ..etc there.
	 rcx - loop ctr
	 rdx - do a lot of chksum manipulation on this register. and then JUMP register
  	 rdi - scratch reg used for checksum computation. also contains value of x of t function
	 rsp - point to checksum (2 indirect pieces)
	 rsi, rbp, r8, r9, r10, r11, r12, r13, r14, r15 - 11 direct checksums
         12 total pieces of checksum
       */
  
       /* swatt loop */		       
              
       "mov $loop, %%rbx\n\t"                      //daddr points to PC before noops

       //initialize_checksum
       initialize_chksum

////////////////////////////////////////////////////////////////////////////////////////////////////////
      
       //mem_copy_attack. 2 instr
       //1. mov address into rdx  mov $loop rdx 
       //2. shift rdx (fake by or rdx rdx)

       
       ".align 2048\n\t"

       "attack1a:\n\t"
       buffer_to_128bytes_1     
       "mov $-1, %%rdx\n\t"       
       attacker_main
       pioneer_random_jump

       ".align 256\n\t"
       "attack1b:\n\t"
       "mov $-1, %%rdx\n\t"       
       buffer_to_128bytes_2
       attacker_main
       pioneer_random_jump

       ".align 256\n\t"
       "attack2a:\n\t"
       "mov $-1, %%rdx\n\t"       
       buffer_to_128bytes_1
       attacker_main
       pioneer_random_jump

       ".align 256\n\t"
       "attack2b:\n\t"
       "mov $-1, %%rdx\n\t"       
       buffer_to_128bytes_2
       attacker_main
       pioneer_random_jump

       ".align 256\n\t"
       "attack3a:\n\t"
       "mov $-1, %%rdx\n\t"       
       buffer_to_128bytes_1
       attacker_main
       pioneer_random_jump

       ".align 256\n\t"
       "attack3b:\n\t"
       "mov $-1, %%rdx\n\t"       
       buffer_to_128bytes_2
       attacker_main
       pioneer_random_jump

       ".align 256\n\t"
       "attack4a:\n\t"
       "mov $-1, %%rdx\n\t"       
       buffer_to_128bytes_1
       attacker_main
       pioneer_exit_check
       pioneer_random_jump

       ".align 256\n\t"
       "attack4b:\n\t"
       "mov $-1, %%rdx\n\t"       
       buffer_to_128bytes_2
       attacker_main
       pioneer_exit_check_bad
       pioneer_random_jump

////////////////////////////////////////////////////////////////////////////////////////////////////////
 
       "done_bad:\n\t"
       
       //serializing instruction
       "mov $0x0, %%eax\n\t"
       "cpuid\n\t"
       
       //read time again
       "movl $0x0, %%ebx\n\t"
       "rdtsc\n\t"
       
       //save checksum into memory
       save_chksum
       
       //restore rbp from the stack
       "mov $stack_buf, %%rsp\n\t"
       "mov 16(%%rsp), %%rbp\n\t"
    
       "mov 8(%%rbp), %%rsp\n\t"         //restore stack pointer
       "mov 16(%%rbp), %%rsi\n\t"        //restore time

       
       //this needs to be done last because we nee
       //the new rbp for all the other restores
       "mov 0(%%rbp), %%rbp\n\t"         //restore old rbp
       
       //subtract to get time difference. time2 =time2 - time1`
       "sub %%rsi, %%rax\n\t"
       
       : "=a"(time_diff) //, "=S"(stack_ptr) 
       :  "c"(num_iterations)
       :  "rbx", "rdx", "rdi","rsi", "r8","r9","r10","r11","r12","r13","r14","r15" );

    print_CPblock_CPI(time_diff, num_iterations, instr_each_iter);
    
  } 
  restore_flags(oldflag);
  DEBUG printk(KERN_EMERG" pc before %lx\n", buf[3]);
  //print stack
  DEBUG printk(KERN_EMERG"&stack_buf %p \n", &stack_buf);
  DEBUG printk(KERN_EMERG"chksum %lx \n", stack_buf[-2]);
  DEBUG printk(KERN_EMERG"flag %lx \n", stack_buf[-1]);
  DEBUG printk(KERN_EMERG"chksum %lx \n", stack_buf[0]);
  DEBUG printk(KERN_EMERG"flag %lx \n", stack_buf[1]);
  //print_checksum
  for(i = 5; i < 16; i++) {
   DEBUG  printk(KERN_EMERG"checksum piece %lx \n", buf[i]);
  }
  
  return;
}



void pioneer_checksum_function() { 
  //pioneer_checksum_function_267();
  
  if (mem_copy_attack_bool == 0){
    pioneer_checksum_function_267_good();
  }
  else if (mem_copy_attack_bool == 1){
    pioneer_checksum_function_267();
    //   pioneer_checksum_function_267_bad();
  }
  else {
    printk(KERN_EMERG "ERROR in pioneer_checksum_function\n");
  }
  
}






void sendPioneerChecksum(struct net_device *netdev, struct sk_buff * skb) {
  int xmitreturn = 0;
  
  xmitreturn = e1000_xmit_frame(skb, netdev);
  if (xmitreturn != 0) {
    printk(KERN_EMERG "xmitreturn non zero! %d\n", xmitreturn);
  }
  return;
}
  


//given a numerator and denomintor, prints quotient in float format
void print_CPblock_CPI(int num,  int num_blocks, int instr_per_block) {
#if 0
  int before_decimal_pt, after_decimal_pt;
  int before_decimal_pt2, after_decimal_pt2;
  int num_thousand_div_den;
  
  num_thousand_div_den = num/ (num_blocks/1000);

  before_decimal_pt = num_thousand_div_den / 1000;
  after_decimal_pt = num_thousand_div_den % 1000;    

  num_thousand_div_den = num/ (num_blocks*instr_per_block/1000);

  before_decimal_pt2 = num_thousand_div_den / 1000;
  after_decimal_pt2 = num_thousand_div_den % 1000;

  DEBUG printk(KERN_EMERG "clockticks %d CPblock %d.%d CPI %d.%d\n", num,  before_decimal_pt, after_decimal_pt, before_decimal_pt2, after_decimal_pt2);
#endif
}






//given a numerator and denomintor, prints quotient in float format

void print_quotient_as_float(int num, char * caption_den, int den, char * caption) {
  int before_decimal_pt, after_decimal_pt;
  
  int num_thousand_div_den;
  //printk(KERN_EMERG("print_quotient_as_float(%d, %d \n", num, den);
  
  num_thousand_div_den = num/ (den/1000);
  //printk(KERN_EMERG("(%d * 1000)/%d = %d\n", num, den, num_thousand_div_den);
  before_decimal_pt = num_thousand_div_den / 1000;
  after_decimal_pt = num_thousand_div_den % 1000;
  if (after_decimal_pt < 10) {
    printk(KERN_EMERG "clockticks %d %s %d %s %d.00%d\n", num, caption_den, den, caption, before_decimal_pt, after_decimal_pt);
  }
  else   if (after_decimal_pt < 100) {
    printk(KERN_EMERG "clockticks %d %s %d %s %d.0%d\n", num, caption_den, den, caption, before_decimal_pt, after_decimal_pt);
  }
  else {
    printk(KERN_EMERG "clockticks %d %s %d %s %d.%d\n", num, caption_den, den, caption, before_decimal_pt, after_decimal_pt);
  }
}



/* SHA1 */

#define GET_UINT32(n,b,i)                       \
{                                               \
    (n) = ( (uint32) (b)[(i)    ] << 24 )       \
        | ( (uint32) (b)[(i) + 1] << 16 )       \
        | ( (uint32) (b)[(i) + 2] <<  8 )       \
        | ( (uint32) (b)[(i) + 3]       );      \
}

#define PUT_UINT32(n,b,i)                       \
{                                               \
    (b)[(i)    ] = (uint8) ( (n) >> 24 );       \
    (b)[(i) + 1] = (uint8) ( (n) >> 16 );       \
    (b)[(i) + 2] = (uint8) ( (n) >>  8 );       \
    (b)[(i) + 3] = (uint8) ( (n)       );       \
}

void sha1_starts( sha1_context *ctx )
{
    ctx->total[0] = 0;
    ctx->total[1] = 0;

    ctx->state[0] = 0x67452301;
    ctx->state[1] = 0xEFCDAB89;
    ctx->state[2] = 0x98BADCFE;
    ctx->state[3] = 0x10325476;
    ctx->state[4] = 0xC3D2E1F0;
}

void sha1_process( sha1_context *ctx, uint8 data[64] )
{
    uint32 temp, W[16], A, B, C, D, E;

    GET_UINT32( W[0],  data,  0 );
    GET_UINT32( W[1],  data,  4 );
    GET_UINT32( W[2],  data,  8 );
    GET_UINT32( W[3],  data, 12 );
    GET_UINT32( W[4],  data, 16 );
    GET_UINT32( W[5],  data, 20 );
    GET_UINT32( W[6],  data, 24 );
    GET_UINT32( W[7],  data, 28 );
    GET_UINT32( W[8],  data, 32 );
    GET_UINT32( W[9],  data, 36 );
    GET_UINT32( W[10], data, 40 );
    GET_UINT32( W[11], data, 44 );
    GET_UINT32( W[12], data, 48 );
    GET_UINT32( W[13], data, 52 );
    GET_UINT32( W[14], data, 56 );
    GET_UINT32( W[15], data, 60 );
    
#define S(x,n) ((x << n) | ((x & 0xFFFFFFFF) >> (32 - n)))

#define R(t)                                            \
(                                                       \
    temp = W[(t -  3) & 0x0F] ^ W[(t - 8) & 0x0F] ^     \
           W[(t - 14) & 0x0F] ^ W[ t      & 0x0F],      \
    ( W[t & 0x0F] = S(temp,1) )                         \
)

#define P(a,b,c,d,e,x)                                  \
{                                                       \
    e += S(a,5) + F(b,c,d) + K + x; b = S(b,30);        \
}

    A = ctx->state[0];
    B = ctx->state[1];
    C = ctx->state[2];
    D = ctx->state[3];
    E = ctx->state[4];

#define F(x,y,z) (z ^ (x & (y ^ z)))
#define K 0x5A827999

    P( A, B, C, D, E, W[0]  );
    P( E, A, B, C, D, W[1]  );
    P( D, E, A, B, C, W[2]  );
    P( C, D, E, A, B, W[3]  );
    P( B, C, D, E, A, W[4]  );
    P( A, B, C, D, E, W[5]  );
    P( E, A, B, C, D, W[6]  );
    P( D, E, A, B, C, W[7]  );
    P( C, D, E, A, B, W[8]  );
    P( B, C, D, E, A, W[9]  );
    P( A, B, C, D, E, W[10] );
    P( E, A, B, C, D, W[11] );
    P( D, E, A, B, C, W[12] );
    P( C, D, E, A, B, W[13] );
    P( B, C, D, E, A, W[14] );
    P( A, B, C, D, E, W[15] );
    P( E, A, B, C, D, R(16) );
    P( D, E, A, B, C, R(17) );
    P( C, D, E, A, B, R(18) );
    P( B, C, D, E, A, R(19) );

#undef K
#undef F

#define F(x,y,z) (x ^ y ^ z)
#define K 0x6ED9EBA1

    P( A, B, C, D, E, R(20) );
    P( E, A, B, C, D, R(21) );
    P( D, E, A, B, C, R(22) );
    P( C, D, E, A, B, R(23) );
    P( B, C, D, E, A, R(24) );
    P( A, B, C, D, E, R(25) );
    P( E, A, B, C, D, R(26) );
    P( D, E, A, B, C, R(27) );
    P( C, D, E, A, B, R(28) );
    P( B, C, D, E, A, R(29) );
    P( A, B, C, D, E, R(30) );
    P( E, A, B, C, D, R(31) );
    P( D, E, A, B, C, R(32) );
    P( C, D, E, A, B, R(33) );
    P( B, C, D, E, A, R(34) );
    P( A, B, C, D, E, R(35) );
    P( E, A, B, C, D, R(36) );
    P( D, E, A, B, C, R(37) );
    P( C, D, E, A, B, R(38) );
    P( B, C, D, E, A, R(39) );

#undef K
#undef F

#define F(x,y,z) ((x & y) | (z & (x | y)))
#define K 0x8F1BBCDC

    P( A, B, C, D, E, R(40) );
    P( E, A, B, C, D, R(41) );
    P( D, E, A, B, C, R(42) );
    P( C, D, E, A, B, R(43) );
    P( B, C, D, E, A, R(44) );
    P( A, B, C, D, E, R(45) );
    P( E, A, B, C, D, R(46) );
    P( D, E, A, B, C, R(47) );
    P( C, D, E, A, B, R(48) );
    P( B, C, D, E, A, R(49) );
    P( A, B, C, D, E, R(50) );
    P( E, A, B, C, D, R(51) );
    P( D, E, A, B, C, R(52) );
    P( C, D, E, A, B, R(53) );
    P( B, C, D, E, A, R(54) );
    P( A, B, C, D, E, R(55) );
    P( E, A, B, C, D, R(56) );
    P( D, E, A, B, C, R(57) );
    P( C, D, E, A, B, R(58) );
    P( B, C, D, E, A, R(59) );

#undef K
#undef F

#define F(x,y,z) (x ^ y ^ z)
#define K 0xCA62C1D6

    P( A, B, C, D, E, R(60) );
    P( E, A, B, C, D, R(61) );
    P( D, E, A, B, C, R(62) );
    P( C, D, E, A, B, R(63) );
    P( B, C, D, E, A, R(64) );
    P( A, B, C, D, E, R(65) );
    P( E, A, B, C, D, R(66) );
    P( D, E, A, B, C, R(67) );
    P( C, D, E, A, B, R(68) );
    P( B, C, D, E, A, R(69) );
    P( A, B, C, D, E, R(70) );
    P( E, A, B, C, D, R(71) );
    P( D, E, A, B, C, R(72) );
    P( C, D, E, A, B, R(73) );
    P( B, C, D, E, A, R(74) );
    P( A, B, C, D, E, R(75) );
    P( E, A, B, C, D, R(76) );
    P( D, E, A, B, C, R(77) );
    P( C, D, E, A, B, R(78) );
    P( B, C, D, E, A, R(79) );

#undef K
#undef F

    ctx->state[0] += A;
    ctx->state[1] += B;
    ctx->state[2] += C;
    ctx->state[3] += D;
    ctx->state[4] += E;
}

void sha1_update( sha1_context *ctx, uint8 *input, uint32 length )
{
    uint32 left, fill;

    if( ! length ) return;

    left = ctx->total[0] & 0x3F;
    fill = 64 - left;

    ctx->total[0] += length;
    ctx->total[0] &= 0xFFFFFFFF;

    if( ctx->total[0] < length )
        ctx->total[1]++;

    if( left && length >= fill )
    {
        memcpy( (void *) (ctx->buffer + left),
                (void *) input, fill );
        sha1_process( ctx, ctx->buffer );
        length -= fill;
        input  += fill;
        left = 0;
    }

    while( length >= 64 )
    {
        sha1_process( ctx, input );
        length -= 64;
        input  += 64;
    }

    if( length )
    {
        memcpy( (void *) (ctx->buffer + left),
                (void *) input, length );
    }
}

static uint8 sha1_padding[64] =
{
 0x80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

void sha1_finish( sha1_context *ctx, uint8 digest[20] )
{
    uint32 last, padn;
    uint32 high, low;
    uint8 msglen[8];

    high = ( ctx->total[0] >> 29 )
         | ( ctx->total[1] <<  3 );
    low  = ( ctx->total[0] <<  3 );

    PUT_UINT32( high, msglen, 0 );
    PUT_UINT32( low,  msglen, 4 );

    last = ctx->total[0] & 0x3F;
    padn = ( last < 56 ) ? ( 56 - last ) : ( 120 - last );

    sha1_update( ctx, sha1_padding, padn );
    sha1_update( ctx, msglen, 8 );

    PUT_UINT32( ctx->state[0], digest,  0 );
    PUT_UINT32( ctx->state[1], digest,  4 );
    PUT_UINT32( ctx->state[2], digest,  8 );
    PUT_UINT32( ctx->state[3], digest, 12 );
    PUT_UINT32( ctx->state[4], digest, 16 );
}



static char *bunchofas=
  {"aaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbb"};

static char *bunchofcs=
  {"cccccccccccccccccccc"};


unsigned char *sha1_hash_main( ) {
  
  //unsigned char *sha1sum;
  //change from bunchofas bunchofcs to real stuff you want to hash
  char * src_buffers [2]= {bunchofas, bunchofcs};
  int sizes[2] = {40, 20};
  DEBUG printk(KERN_EMERG "sha1_hash_main\n");
  return sha1_hash(src_buffers, sizes, 2);
  //sha1sum = sha1_hash(src_buffers, sizes, 2);
  //kfree(sha1sum);
}

unsigned char * sha1_hash(char * starting_addrs[], int sizes[], int num_items){
  int i;
  unsigned char* sha1sum = (char*)kmalloc(20*sizeof(char), GFP_ATOMIC);
  sha1_context  ctx;
  sha1_starts( &ctx );
  //hash each one
  for(i = 0; i < num_items; i++) {
    sha1_hash_each_item(starting_addrs[i], sizes[i], &ctx);
  }
  
  sha1_finish( &ctx, sha1sum );
  //  print_hash_value(sha1sum, 20);
  reverse_byte_order(&sha1sum[0]);
  reverse_byte_order(&sha1sum[4]);
  reverse_byte_order(&sha1sum[8]);
  reverse_byte_order(&sha1sum[12]);
  reverse_byte_order(&sha1sum[16]);
  //  print_hash_value(sha1sum, 20);
  return sha1sum;
}

void sha1_hash_each_item(char * start, int total_hash_size, sha1_context *ctx ){
  
  //  int total_hash_size = 40;
  int hash_chunk = 20;
  int last_chunk_size ;    
  int bytes_hashed_so_far;
  
  char * src_buffer = start;
  //read each funk
  //printk(KERN_EMERG"sha1_hash_each_item %s, size %d\n", start, total_hash_size);

  for(bytes_hashed_so_far= 0; total_hash_size - bytes_hashed_so_far > hash_chunk ; 
      bytes_hashed_so_far+=hash_chunk)   {
    
    //printk(KERN_EMERG"sha1_update starting at %d\n", bytes_hashed_so_far );
    sha1_update(ctx, &src_buffer[bytes_hashed_so_far], hash_chunk );
  }
  
  //last chunk of hash, the size if total_hash_size minus what we had so far
  last_chunk_size = total_hash_size - bytes_hashed_so_far;
  //as long as the last chunk size is not zero, we would hash it
  //last_chunk_size is obviously smaller than hash_chunk
  if (last_chunk_size != 0) {
    //printk(KERN_EMERG"sha1_update starting at %d\n",bytes_hashed_so_far );
    sha1_update(  ctx, &src_buffer[bytes_hashed_so_far], last_chunk_size );
  }  
  
}

void print_hash_value(unsigned char *sha1sum, int length) {
  int j;
  for( j = 0; j < length; j++ ) {
    printk( KERN_EMERG "%02x", sha1sum[j] );
  }
  printk(KERN_EMERG "\n");
}

void reverse_byte_order(char * word){
  char a,b,c,d;
  a = word[0];  b = word[1];
  c = word[2];  d = word[3];
  word[0] = d;  word[1] = c;
  word[2] = b;  word[3] = a;
}


/* end of SHA 1 */

