#include "global.h"
#include "Switch.h"
#include "Log.h"
#include "Parser.h"
#include "Simulator.h"

#include <stdio.h>
#include <unistd.h>
#include <assert.h>
#include <iostream>

void printUsage(char *prog)
{
  cerr << prog << ": usage: " << endl
       << prog << " -f simulationFile [-h] [-l logfile]" << endl;
}

int main(int argc, char *argv[])
{
  extern char *optarg;
  int rc;
  char *filename = NULL;
  char *logfile = NULL;

  while ((rc = getopt(argc, argv, "f:hl:")) != -1) {
    switch (rc) {
    case 'f':
      filename = strdup(optarg);
      assert(filename);
      break;
    case 'l':
      logfile = strdup(optarg);
      assert(logfile);
      break;
    case 'h':
    default:
      printUsage(argv[0]);
      exit(1);
    }
  }

  if (filename == NULL) {
    cerr << "Error! You must provide a simulation file on the command line." 
         << endl;
    printUsage(argv[0]);
    exit(1);
  }

  if (logfile != NULL) {
    log_init(logfile);
  } else {
    log_init("./bridge-sim.log");
  }

  stp_trace("simulation scenario file is %s", filename);

  Simulator simulator;
  Parser parser(&simulator);
  parser.Parse(filename);
  
  simulator.Run();

  log_close();

  free(filename);
  filename = NULL;

  if (logfile) {
    free(logfile);
    logfile = NULL;
  }
}

