#ifndef TIMER_H_INCLUDED
#define TIMER_H_INCLUDED

#include "Event.h"

class TimerEvent;
class Simulator;

// a timer that periodically calls its Callback function
class Timer
{
 public:
  Timer(const char *name, double offset, double period, Simulator *sim);
  virtual ~Timer();

  // users of class Timer should subclass it and overload the Callback
  // method
  virtual void Callback() = 0;

 protected:
  const char *Name;
  const double Period;
  Simulator *simulator;
  TimerEvent *CurrentEv;

  void NewEvent(double when);
  void Action(); 
  friend class TimerEvent;
};


class TimerEvent : public Event
{
 public:
  TimerEvent(Timer *tim, double when) : Event("TimerEvent", when), Owner(tim) { }
  ~TimerEvent() { }

  void Callback() { Owner->Action(); }

 protected:
  Timer *Owner;
};

#endif // TIMER_H_INCLUDED
