#include "global.h"
#include "Timer.h"
#include "Simulator.h"

Timer::Timer(const char *name, double offset, double period, Simulator *sim) : 
  Name(name), Period(period), simulator(sim), CurrentEv(NULL)
{
  assert(offset < Period);
  assert(offset >= 0);
  NewEvent(Period+offset);
}

Timer::~Timer()
{
  if (CurrentEv) {
    CurrentEv->CancelEvent();
    // drop our pointer to currentEv.  class Simulator will take care of deleting it.
    CurrentEv = NULL;
  }
}

void Timer::NewEvent(double offset)
{
  assert(!CurrentEv);
  double when = GetCurrentTime() + offset;
  CurrentEv = new TimerEvent(this, when);
  simulator->AddEvent(CurrentEv);
}

void Timer::Action()
{
  CurrentEv = NULL;
  NewEvent(Period);

  Callback();
}

