#ifndef SWITCH_H_INCLUDED
#define SWITCH_H_INCLUDED

#include <vector>
#include <stdlib.h>  // for size_t

#include "RapidSpanningTree.h"
#include "Timer.h"

class Simulator;
class Switch;

class OneSecondTimer : public Timer
{
 public:
  OneSecondTimer(double offset, Switch *sw, Simulator *sim) 
    : Timer("OneSecondTimer", offset, 1.0, sim), S(sw)
    { }
  virtual ~OneSecondTimer() { }
  void Callback();

 protected:
  Switch *S;
};

struct Interface
{
  Interface() { enabled = false; }
  virtual ~Interface() { }
  bool enabled;  // currently enabled to forward packets?
  bool used;  // currently used by the simulator?
};

class Switch 
{
 public:
  Switch(unsigned long switchID, unsigned numPorts, double offset, Simulator *sim);
  virtual ~Switch();

  // call this right after calling the constructor
  void Init();

  RapidSpanningTree& GetRSTP() { return RSTP; }

  unsigned long GetSwitchID() { return SwitchID; }

  // returns the number of the next unused port, and then enables that
  // port (which marks the port used).  suggestedPortNum is just that
  // - a suggestion about which port it'd be nice to use.
  // GetUnusedPort will try to use the suggested port, but it makes no
  // promises.
  unsigned GetUnusedPort(unsigned suggestedPortNum);

  void EnablePort(unsigned port);
  void DisablePort(unsigned port);

  // returns 0 on success.  called by rstp code.  this code or stuff
  // it calls will call "delete pkt".  port_index is the index of the
  // sending port
  int Send(int vlan_id, unsigned port_index, char *pkt, size_t pktlen);

  // called by system to deliver code to the RSTP instance on port
  // port_index.  Recv will delete pkt after the call into RSTP
  // finishes
  void Recv(int vlan_id, unsigned port_index, char *pkt, size_t pktlen);

  void OneSecondCallback();

  // stuff the mac addr into char array mac, which must be 6 chars
  // long
  void GetPortMac(unsigned port_index, unsigned char *mac);

  // returns true for enabled, false for disabled
  bool GetPortStatus(unsigned port_index);

 protected:
  unsigned NumPorts;
  unsigned long SwitchID;

  // for logging
  char *SwitchName;

  vector<Interface> Interfaces;

  // do we also need to access ports by address?
  // hash_map<Address, Interface> InterfaceMap;

  Simulator *simulator;
  RapidSpanningTree RSTP;
  OneSecondTimer OST;
};


#endif // SWITCH_H_INCLUDED
