/************************************************************************ 
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

/* Generic (abstract state machine) state machine : 17.13, 17.14 */
 
#ifndef _STP_STATER_H__
#define _STP_STATER_H__

#include <string.h>

#define BEGIN  9999 /* distinct from any valid state */

class STPM;
class Port;
class RapidSpanningTree;
struct ltstatemachine;  // defined at bottom of this file

enum CallbackType {
  CB_init_machine,
  CB_enter_state,
  CB_change_state,
  CB_check_condition
};

class StateMachine
{
 public:
  virtual void EnterState() = 0;
  virtual bool CheckCondition() = 0;
  virtual char *GetStateName(int) = 0;

  StateMachine(char *name);
  virtual ~StateMachine();
  unsigned ChangeState();
  bool Hop2State(unsigned int new_state, bool logChange = true);

  char *GetName() { return name; }
  char GetDebug() { return debug; }
  void SetDebug(char val) { debug = val; }

 protected:
  char*         name; /* for debugging */
  char          debug; /* 0- no dbg, 1 - port, 2 - stpm */
  unsigned int  ignoreHop2State;

  bool          changeState;
  unsigned int  State;

  friend class RapidSpanningTree;
  friend class STPM;
  friend struct ltstatemachine;
};

// useful for sets of StateMachines
struct ltstatemachine {
  bool operator()(const StateMachine *s1, const StateMachine *s2) const
  { 
    assert(s1);
    assert(s2);
    assert(s1->name);
    assert(s2->name);
    return strcmp(s1->name, s2->name) < 0;
  }
};

#endif /* _STP_STATER_H__ */

