/************************************************************************ 
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

/* Generic (abstract) state machine : 17.13, 17.14 */
 
#include "global.h"
#include "StateMachine.h"
#include "Log.h"

#include <string.h>
#include <stdlib.h>

StateMachine::StateMachine(char *cname)
{
  State = BEGIN;
  name = strdup(cname);
  changeState = false;
  this->debug = true;
  this->ignoreHop2State = BEGIN;
}

StateMachine::~StateMachine()
{
  free(name);
  name = "nada";
}

unsigned StateMachine::ChangeState()
{
  int number_of_loops;

  for (number_of_loops = 0; ; number_of_loops++) {
    if (!changeState) return number_of_loops;
    EnterState();
    changeState = false;
    CheckCondition();
  }
  return number_of_loops;
}

bool StateMachine::Hop2State(unsigned int new_state, bool logChange)
{
  switch (debug) {
    case 0: 
      break;
    case 1:
      if (new_state == State || new_state == ignoreHop2State) {
        break;
      }
      if (logChange) {
        stp_trace ("%s: %s=>%s", this->name, GetStateName(State),
                   GetStateName(new_state));
      }
      break;
    case 2:
      if (new_state == this->State) {
        break;
      }
      if (logChange) {
        stp_trace ("%s: %s=>%s", this->name, GetStateName(State),
                   GetStateName(new_state));
      }
      break;
  }

  State = new_state;
  changeState = true;
  return true;
}
