#ifndef RAPIDSPANNINGTREE_H_INCLUDED
#define RAPIDSPANNINGTREE_H_INCLUDED

#include "STPM.h"
#include "bitmap.h"
#include "uid_stp.h"
#include <ext/hash_map>

class Port;

/* bridge configuration */

#define DEF_BR_PRIO 32768
#define MIN_BR_PRIO 0
#define MAX_BR_PRIO 61440

#define DEF_BR_HELLOT   2
#define MIN_BR_HELLOT   1
#define MAX_BR_HELLOT   10

#define DEF_BR_MAXAGE   20
#define MIN_BR_MAXAGE   6
#define MAX_BR_MAXAGE   40

#define DEF_BR_FWDELAY  15
#define MIN_BR_FWDELAY  4
#define MAX_BR_FWDELAY  30

#define DEF_FORCE_VERS  2 /* NORMAL_RSTP */

/* port configuration */

#define DEF_PORT_PRIO   128
#define MIN_PORT_PRIO   0
#define MAX_PORT_PRIO   240 /* in steps of 16 */

#define DEF_ADMIN_NON_STP   false
#define DEF_ADMIN_EDGE      true
#define DEF_LINK_DELAY      3 /* see edge.c */
#define DEF_P2P         P2P_AUTO

class Switch;

class RapidSpanningTree
{
 public:

  RapidSpanningTree(Switch *owner);
  virtual ~RapidSpanningTree();

  Switch *GetSwitch(void) { return Owner; }

  /* Section 1: Create/Delete/Start/Stop the RSTP instance */

  void /* init the engine */ STP_IN_init (unsigned max_port_index);
  
  int STP_IN_stpm_create (int vlan_id, char* name, BITMAP_T* port_bmp);
  
  int STP_IN_stpm_delete (int vlan_id);

  int STP_IN_stop_all (void);

  int STP_IN_delete_all (void);

  /* Section 2. "Get" management */

  bool STP_IN_get_is_stpm_enabled (int vlan_id);

  int STP_IN_stpm_get_vlan_id_by_name (char* name, int* vlan_id);

  int STP_IN_stpm_get_name_by_vlan_id (int vlan_id, char* name, size_t buffsize);

  const char* STP_IN_get_error_explanation (int rstp_err_no);

  int STP_IN_stpm_get_cfg (int vlan_id, UID_STP_CFG_T* uid_cfg);

  int STP_IN_stpm_get_state (int vlan_id, UID_STP_STATE_T* entry);

  int STP_IN_port_get_cfg (int vlan_id, unsigned port_index, UID_STP_PORT_CFG_T* uid_cfg);

  int STP_IN_port_get_state (int vlan_id, UID_STP_PORT_STATE_T* entry);

  /* Section 3. "Set" management */

  int STP_IN_stpm_set_cfg (int vlan_id, BITMAP_T* port_bmp, UID_STP_CFG_T* uid_cfg);

  int STP_IN_set_port_cfg (int vlan_id, UID_STP_PORT_CFG_T* uid_cfg);

  int STP_IN_dbg_set_port_trace (char* mach_name, int enadis,
				 int vlan_id, BITMAP_T* ports,
				 int is_print_err);

  /* Section 4. RSTP functionality events */

  int STP_IN_one_second (void);

  int /* for Link UP/DOWN */ STP_IN_enable_port (unsigned port_index, bool enable);

  int /* call it, when port speed has been changed, speed in Kb/s  */
    STP_IN_changed_port_speed (unsigned port_index, long speed);

  int /* call it, when current port duplex mode has been changed  */
    STP_IN_changed_port_duplex (unsigned port_index);

  int STP_IN_check_bpdu_header (BPDU_T* bpdu, size_t len);

  int STP_IN_rx_bpdu (int vlan_id, unsigned port_index, BPDU_T* bpdu, size_t len);


  STPM* stpapi_stpm_find (int vlan_id);
  
  int stp_in_stpm_enable (int vlan_id, char* name,
			  BITMAP_T* port_bmp,
			  UID_STP_MODE_T admin_state);
  STPM* stp_in_stpm_create (int vlan_id, char* name, BITMAP_T* port_bmp,
			    int* err_code);

  int STP_check_bridge_priority(STPM *stpm); // acm: i moved this func from STPM to here

 protected:
  Switch *Owner;

  // repository of spanning tree machines.  map from vlan id to stpm
  typedef hash_map<int, STPM* > STPMHash;
  STPMHash STPMs;

  int _stp_in_stpm_enable (int vlan_id, char* name,
			   BITMAP_T* port_bmp,
			   UID_STP_MODE_T admin_state);
  Port *_stpapi_port_find (STPM *t, unsigned port_index);
  void _conv_br_id_2_uid (IN BRIDGE_ID* f, OUT UID_BRIDGE_ID_T* t);
  int _check_stpm_config (IN UID_STP_CFG_T* uid_cfg);
  void _stp_in_enable_port_on_stpm (STPM* stpm, unsigned port_index, 
                                    bool enable);
};


#endif // RAPIDSPANNINGTREE_H_INCLUDED
