/************************************************************************ 
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

/* STP PORT instance : 17.18, 17.15 */
 
#ifndef _STP_PORT_H__
#define _STP_PORT_H__

#include "STPM.h"

#include "StateMachine.h"
#include "RoleTransitions.h"
#include "PortStateTransitions.h"
#include "TopologyChange.h"
#include "ProtocolMigration.h"
#include "Transmit.h"
#include "P2P.h"
#include "Edge.h"
#include "PathCost.h"

#include "stp_bpdu.h"
#include "vector.h"
#include "times.h"
#include "uid_stp.h"

#include <stdlib.h>  // for a def of size_t, if you can believe it
#include <set>

class RoleSelection;

#define TIMERS_NUMBER   9
typedef unsigned int    PORT_TIMER_T;

typedef enum {
  Mine,
  Aged,
  Received,
  Disabled
} INFO_IS_T;

typedef enum {
  SuperiorDesignateMsg,
  RepeatedDesignateMsg,
  ConfirmedRootMsg,
  OtherMsg
} RCVD_MSG_T;

// PortInfo must be included below def of RCVD_MSG_T
#include "PortInfo.h"

typedef enum {
  DisabledPort = 0,
  AlternatePort,
  BackupPort,
  RootPort,
  DesignatedPort,
  NonStpPort
} PORT_ROLE_T;

class Port {
 public:
  Port(STPM *owner, int port_index);
  virtual ~Port();

  int STP_port_rx_bpdu (BPDU_T* bpdu, size_t len);

  void STP_port_init (STPM *stpm, bool check_link);

  int STP_port_trace_state_machine (char* mach_name, int enadis, int vlan_id);

  void STP_port_trace_flags (char* title);

  unsigned long GetUsedSpeed(void) { return usedSpeed; }

 protected:

  /* per Port state machines */
  PortInfo                      *info;      /* 17.21 */
  RoleTransitions          *roletrns;  /* 17.23 */
  PortStateTransitions  *sttrans;   /* 17.24 */
  TopologyChange        *topoch;    /* 17.25 */
  ProtocolMigration       *migrate;   /* 17.26 */
  Transmit                     *transmit;  /* 17.26 */
  P2P                             *p2p;       /* 6.4.3, 6.5.1 */
  Edge                           *edge;      /*  */
  PathCost                     *pcost;     /*  */

  set<StateMachine *, ltstatemachine>     machines; /* list of machines */

  STPM *owner; /* Bridge, that this port belongs to */
  
  /* per port Timers */
  PORT_TIMER_T      fdWhile;      /* 17.15.1 */
  PORT_TIMER_T      helloWhen;    /* 17.15.2 */
  PORT_TIMER_T      mdelayWhile;  /* 17.15.3 */
  PORT_TIMER_T      rbWhile;      /* 17.15.4 */
  PORT_TIMER_T      rcvdInfoWhile;/* 17.15.5 */
  PORT_TIMER_T      rrWhile;      /* 17.15.6 */
  PORT_TIMER_T      tcWhile;      /* 17.15.7 */
  PORT_TIMER_T      txCount;      /* 17.18.40 */
  PORT_TIMER_T      lnkWhile;

  PORT_TIMER_T*     timers[TIMERS_NUMBER]; /*list of timers */

  bool              agreed;        /* 17.18.1 */
  PRIO_VECTOR_T     designPrio;    /* 17.18.2 */
  TIMEVALUES_T      designTimes;   /* 17.18.3 */
  bool              forward;       /* 17.18.4 */
  bool              forwarding;    /* 17.18.5 */
  INFO_IS_T         infoIs;        /* 17.18.6 */
  bool              initPm;        /* 17.18.7  */
  bool              learn;         /* 17.18.8 */
  bool              learning;      /* 17.18.9 */
  bool              mcheck;        /* 17.18.10 */
  PRIO_VECTOR_T     msgPrio;       /* 17.18.11 */
  TIMEVALUES_T      msgTimes;      /* 17.18.12 */
  bool              newInfo;       /* 17.18.13 */
  bool              operEdge;      /* 17.18.14 */
  bool              adminEdge;     /* 17.18.14 */
  bool              portEnabled;   /* 17.18.15 */
  PORT_ID           port_id;       /* 17.18.16 */
  PRIO_VECTOR_T     portPrio;      /* 17.18.17 */
  TIMEVALUES_T      portTimes;     /* 17.18.18 */
  bool              proposed;      /* 17.18.19 */
  bool              proposing;     /* 17.18.20 */
  bool              rcvdBpdu;      /* 17.18.21 */
  RCVD_MSG_T        rcvdMsg;       /* 17.18.22 */
  bool              rcvdRSTP;      /* 17/18.23 */
  bool              rcvdSTP;       /* 17.18.24 */
  bool              rcvdTc;        /* 17.18.25 */
  bool              rcvdTcAck;     /* 17.18.26 */
  bool              rcvdTcn;       /* 17.18.27 */
  bool              reRoot;        /* 17.18.28 */
  bool              reselect;      /* 17.18.29 */
  PORT_ROLE_T       role;          /* 17.18.30 */
  bool              selected;      /* 17.18.31 */
  PORT_ROLE_T       selectedRole;  /* 17.18.32 */
  bool              sendRSTP;      /* 17.18.33 */
  bool              sync;          /* 17.18.34 */
  bool              synced;        /* 17.18.35 */
  bool              tc;            /* 17.18.36 */
  bool              tcAck;         /* 17.18.37 */
  bool              tcProp;        /* 17.18.38 */

  bool              updtInfo;      /* 17.18.41 */

  /* message information */
  unsigned char     msgBpduVersion;
  unsigned char     msgBpduType;
  unsigned char     msgPortRole;
  unsigned char     msgFlags;

  unsigned long     adminPCost; /* may be ADMIN_PORT_PATH_COST_AUTO */
  unsigned long     operPCost;
  unsigned long     operSpeed;
  unsigned long     usedSpeed;
  int               LinkDelay;   /* TBD: LinkDelay may be managed ? */
  bool              adminEnable; /* 'has LINK' */
  bool              wasInitBpdu;  
  bool              admin_non_stp;

  bool              p2p_recompute;
  bool              operPointToPointMac;
  ADMIN_P2P_T       adminPointToPointMac;

  /* statistics */
  unsigned long     rx_cfg_bpdu_cnt;
  unsigned long     rx_rstp_bpdu_cnt;
  unsigned long     rx_tcn_bpdu_cnt;

  unsigned long     uptime;       /* 14.8.2.1.3.a */

  int               port_index;
  char*             port_name;

  unsigned int	    skip_rx;
  unsigned int	    skip_tx;

  friend class RapidSpanningTree;
  friend class STPM;
  friend class RoleSelection;
  friend class Edge;
  friend class ProtocolMigration;
  friend class P2P;
  friend class PathCost;
  friend class PortInfo;
  friend class RoleTransitions;
  friend class PortStateTransitions;
  friend class TopologyChange;
  friend class Transmit;
};

#endif /*  _STP_PORT_H__ */

