/************************************************************************ 
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

/* Point To Point MAC mode selection machine : 6.4.3, 6.5.1 */
 
#include "global.h"
#include "STPM.h"
#include "Port.h"
#include "P2P.h"
#include "stp_to.h" /* for STP_OUT_get_duplex */

#define STATES { \
  CHOOSE(INIT),     \
  CHOOSE(RECOMPUTE),    \
  CHOOSE(STABLE),    \
}

#define GET_STATE_NAME P2P::GetStateName
#include "choose.h"

P2P::P2P(Port *p) : StateMachine("P2P"), owner(p)
{
  // empty
}

void P2P::EnterState ()
{
  Port *port = owner;

  switch (State) {
    case BEGIN:
    case INIT:
      port->p2p_recompute = true;
      break;
    case RECOMPUTE:
      switch (port->adminPointToPointMac) {
      case P2P_FORCE_TRUE:
        port->operPointToPointMac = true;
        break;
      case P2P_FORCE_FALSE:
        port->operPointToPointMac = false;
        break;
      default:
      case P2P_AUTO:
        port->operPointToPointMac = STP_OUT_get_duplex (port->port_index);
      }
      port->p2p_recompute = false;
      break;
    case STABLE:
      break;
  }
}

bool P2P::CheckCondition()
{
  Port *port = owner;

  switch (State) {
    case BEGIN:
    case INIT:
      return Hop2State(STABLE);
    case RECOMPUTE:
      return Hop2State(STABLE);
    case STABLE:
      if (port->p2p_recompute) {
        return Hop2State(RECOMPUTE);
      }
      break;
  }
  return false;
}
