#ifndef LOG_H_INCLUDED
#define LOG_H_INCLUDED

struct LogContext;

unsigned pushLogContext(LogContext* a);
void popLogContext(unsigned uid);

struct LogContext {
  const char *name;
  unsigned uid;

  LogContext(const char *n) : name(n) { uid = pushLogContext(this); }
  ~LogContext() { popLogContext(uid); }
};


/* hand it a file name, it'll create the log file that stp_trace will
   write to.  otherwise, stp_trace will print to stdout */
void log_init(const char *name); 
void log_close(void);

// most basic logging primitive
unsigned long stp_trace (const char* fmt, ...);  /* in log.c */

/* to write a single log message via multiple calls, use these */

unsigned long stp_trace_begin(void);
unsigned long stp_trace_more(const char* fmt, ...);  /* in log.c */
unsigned long stp_trace_end(void);

/* log the bpdu.  the bpdu is passed in as a character array that is
   length bytes long.  in log.c.  setting xmitOrRecv to true means
   that the bpdu is being sent, false means the bpdu is being
   received */
void stp_trace_bpdu(const char *bpdu, const unsigned length,
                    const bool xmitOrRecv, const unsigned portNum);



#endif // LOG_H_INCLUDED
