#ifndef EVENT_H_INCLUDED
#define EVENT_H_INCLUDED

#include <assert.h>
#include "global.h"

class Event
{
 public:
  Event(const char *name, double when) : Name(name), When(when), Dummy(false) { 
    assert(when >= GetCurrentTime());
  }

  // only class Simulator should ever delete an even once it's been
  // enqueued!
  virtual ~Event() { }

  // system will call this at CurrentTime == when
  virtual void Callback() = 0;

  const char *GetName() const { return Name; }
  double GetWhen() const { return When; }

  // call this to cancel the event.  when an event is cancelled, its
  // Callback will never be called.  the event will be deleted, but
  // not right away.
  void CancelEvent() { Dummy = true; }

  bool IsCancelled() { return Dummy; }

 protected:
  const char *Name;
  const double When;
  bool Dummy;
};

struct gtevent {
  bool operator() (const Event *a, const Event *b) const
  {
    return a->GetWhen() > b->GetWhen();
  }
};


#endif // EVENT_H_INCLUDED
