/************************************************************************ 
 * RSTP library - Rapid Spanning Tree (802.1t, 802.1w) 
 * Copyright (C) 2001-2003 Optical Access 
 * Author: Alex Rozin 
 * 
 * This file is part of RSTP library. 
 * 
 * RSTP library is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU Lesser General Public License as published by the 
 * Free Software Foundation; version 2.1 
 * 
 * RSTP library is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser 
 * General Public License for more details. 
 * 
 * You should have received a copy of the GNU Lesser General Public License 
 * along with RSTP library; see the file COPYING.  If not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 **********************************************************************/

/* Note: this state mashine distinkts from described in P802.1t Clause 18. */
/* I am ready to discuss it                                                */
 
#include "global.h"
#include "STPM.h"
#include "Port.h"
#include "Edge.h"
#include "Log.h"

#define STATES {        \
  CHOOSE(DISABLED),         \
  CHOOSE(DETECTED),     \
  CHOOSE(DELEAYED),     \
  CHOOSE(RESOLVED),     \
}

#define GET_STATE_NAME Edge::GetStateName
#include "choose.h"

#define DEFAULT_LINK_DELAY  3

Edge::Edge(Port *p) : StateMachine("Edge"), owner(p)
{
  // empty
}

void Edge::EnterState()
{
  Port *port = owner;

  switch (State) {
    case BEGIN:
      break;
    case DISABLED:
      port->operEdge = port->adminEdge;
      port->wasInitBpdu = false;
      port->lnkWhile = 0;
      port->portEnabled = false;
      break;
    case DETECTED:
      port->portEnabled = true;
      port->lnkWhile = port->LinkDelay;
      port->operEdge = false;
      break;
    case DELEAYED:
      break;
    case RESOLVED:
      if (! port->wasInitBpdu) {
          port->operEdge = port->adminEdge;
      }
      break;
  }
}

bool Edge::CheckCondition()
{
  Port *port = owner;

  switch (State) {
    case BEGIN:
      return Hop2State(DISABLED);
    case DISABLED:
      if (port->adminEnable) {
        return Hop2State(DETECTED);
      }
      break;
    case DETECTED:
      return Hop2State(DELEAYED);
    case DELEAYED:
      if (port->wasInitBpdu) {
        if (debug)
            stp_trace ("port %s 'edge' resolved by BPDU", port->port_name);
        return Hop2State(RESOLVED);
      }

      if (! port->lnkWhile)  {
        if (debug)
          stp_trace ("port %s 'edge' resolved by timer", port->port_name);
        return Hop2State(RESOLVED);
      }

      if (! port->adminEnable) {
        return Hop2State(DISABLED);
      }
      break;
    case RESOLVED:
      if (! port->adminEnable) {
        return Hop2State(DISABLED);
      }
      break;
  }
  return false;
}

