#ifndef ARGPARSER_H_INCLUDED
#define ARGPARSER_H_INCLUDED

#include <string>
#include <istream>
#include <ext/hash_map>

struct Arg;

struct hashstr 
{
  unsigned operator() (const string& a) const {
    struct hash<char *> strhash;
    return strhash(a.c_str());
  }
};

class ArgParser
{
 public:
  ArgParser() { }
  ~ArgParser() { }

  typedef hash_map<string, struct Arg *, hashstr > ArgMap;

  void AddArg(struct Arg *a);
  void Parse(istream& line, unsigned lineNum);
  ArgMap& Results() { return Args; }

 protected:
  ArgMap Args;
};

struct Arg
{
  Arg(const char *argName, ArgParser& ap) : name(argName) { ap.AddArg(this); }
  virtual ~Arg() { }
  virtual void Parse(istream& is)=0;
  string name;
};

template<class T> struct TArg : public Arg
{
  TArg(const char *s, T defval, ArgParser& ap) : Arg(s, ap), val(defval) { } 
  void Parse(istream& is) { is >> val; }
  T val;
};

typedef TArg<double> DoubleArg;
typedef TArg<string> StringArg;
typedef TArg<unsigned> UnsignedArg;



#endif // ARGPARSER_H_INCLUDED
