#include "global.h"
#include "ArgParser.h"

#include <sstream>
#include <iostream>

void ArgParser::AddArg(struct Arg *a)
{
  assert(a);
  assert(Args.find(a->name) == Args.end());
  Args[a->name] = a;
}

void ArgParser::Parse(istream &str, unsigned lineNum)
{
  string argName;

  while (1) {
    str >> argName;
    if (argName.empty()) {
      return;
    }
    ArgMap::iterator ami = Args.find(argName);
    if (ami != Args.end()) {
      ami->second->Parse(str);
    } else {
      cerr << "Parse error on line " << lineNum << "!!!" << endl;
      cerr << "Argument parser found token \"" << argName 
           << "\" but that's not a recognized option." << endl;
      cerr << "Recognized options are:";
      for (ami = Args.begin(); ami != Args.end(); ami++) {
        cerr << " " << ami->second->name;
      }
      cerr << endl;
      exit(1);
    }
    argName.clear();
  }
}
